/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.network.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.tradplus.ads.common.util.BitmapUtil;
import com.tradplus.ads.common.util.FileUtil;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.mobileads.TradPlus;
import com.tradplus.ads.network.util.ImageLruCache;
import com.tradplus.ads.network.util.ImageUrlLoader;
import com.tradplus.ads.network.util.ResourceDiskCacheManager;
import com.tradplus.ads.network.util.ResourceDownloadBaseUrlLoader;
import com.tradplus.ads.network.util.ResourceEntry;
import java.io.FileInputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.AbstractSequentialList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class ImageLoader {
    private static ImageLoader b;
    private ImageLruCache<String, WeakReference<Bitmap>> c;
    private final Object d = new Object();
    Context a;
    private LinkedHashMap<String, List<ImageLoaderListener>> e = new LinkedHashMap();
    private Handler f = new Handler(Looper.getMainLooper()){

        public final void handleMessage(Message object) {
            if (object.what == 1) {
                String string = object.getData().getString("image_key");
                object = ImageLoader.this.getBitmapFromMemCache(string);
                Object object2 = (LinkedList)ImageLoader.this.e.get(string);
                if (object2 != null) {
                    object2 = ((AbstractSequentialList)object2).iterator();
                    while (object2.hasNext()) {
                        ImageLoaderListener imageLoaderListener = (ImageLoaderListener)object2.next();
                        if (imageLoaderListener == null) continue;
                        if (object != null) {
                            imageLoaderListener.onSuccess(string, (Bitmap)object);
                            continue;
                        }
                        imageLoaderListener.onFail(string, "Bitmap load fail");
                    }
                }
                ImageLoader.this.e.remove(string);
                return;
            }
            if (object.what == 2) {
                String string = object.getData().getString("image_key");
                object = object.getData().getString("image_message");
                Object object3 = (LinkedList)ImageLoader.this.e.get(string);
                if (object3 != null) {
                    object3 = ((AbstractSequentialList)object3).iterator();
                    while (object3.hasNext()) {
                        ImageLoaderListener imageLoaderListener = (ImageLoaderListener)object3.next();
                        if (imageLoaderListener == null) continue;
                        imageLoaderListener.onFail(string, (String)object);
                    }
                }
                ImageLoader.this.e.remove(string);
            }
        }
    };

    public void addBitmapToMemoryCache(String string, Bitmap bitmap) {
        if (this.getBitmapFromMemCache(string) == null && bitmap != null) {
            this.c.put(string, new WeakReference<Bitmap>(bitmap));
        }
    }

    public Bitmap getBitmapFromMemCache(String object) {
        if ((object = this.c.get((String)object)) != null) {
            return (Bitmap)((Reference)object).get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Bitmap getBitmapFromDiskCache(ResourceEntry object, int n2, int n3) {
        if (object == null) return null;
        if (TextUtils.isEmpty((CharSequence)((ResourceEntry)object).resourceUrl)) {
            return null;
        }
        String string = FileUtil.hashKeyForDisk(((ResourceEntry)object).resourceUrl);
        Bitmap bitmap = null;
        Object object2 = this.d;
        synchronized (object2) {
            block13: {
                object = ResourceDiskCacheManager.getInstance(this.a).getFileInputStream(((ResourceEntry)object).resourceType, string);
                if (object == null) {
                    return null;
                }
                try {
                    void var3_4;
                    void var2_2;
                    bitmap = BitmapUtil.getBitmap(((FileInputStream)object).getFD(), (int)var2_2, (int)var3_4);
                }
                catch (Throwable throwable) {
                    try {
                        if (object == null) return bitmap;
                        ((FileInputStream)object).close();
                    }
                    catch (Exception exception) {}
                    break block13;
                }
                catch (Throwable throwable) {
                    n2 = throwable;
                    try {
                        if (object == null) throw n2;
                        ((FileInputStream)object).close();
                        throw n2;
                    }
                    catch (Exception exception) {}
                    throw n2;
                }
                try {
                    if (object == null) return bitmap;
                    ((FileInputStream)object).close();
                }
                catch (Exception exception) {}
            }
            return bitmap;
        }
    }

    private ImageLoader(Context context) {
        this.a = context.getApplicationContext();
        int n2 = (int)Runtime.getRuntime().maxMemory() / 5;
        LogUtil.ownShow("ImageLoad init cache size: " + n2 + "B");
        this.c = new ImageLruCache<String, WeakReference<Bitmap>>(n2){

            @Override
            protected final /* synthetic */ int a(Object object) {
                object = (object = (WeakReference)object) != null ? (Bitmap)((Reference)object).get() : null;
                int n2 = object != null ? object.getRowBytes() * object.getHeight() : 0;
                LogUtil.ownShow("sizeOf: Bitmap size:" + n2 + "B.");
                return n2;
            }

            @Override
            protected final /* synthetic */ void a(boolean bl, Object object, Object object2, Object object3) {
                String string = (String)object;
                object = (WeakReference)object3;
                object3 = (WeakReference)object2;
                super.a(bl, string, object3, object);
                try {
                    Bitmap bitmap = object3 != null ? (Bitmap)((Reference)object3).get() : null;
                    if (bitmap == null) {
                        LogUtil.ownShow("entryRemoved: Bitmap has been release.");
                    }
                    if (object3 != null && !object3.equals(object) && bitmap != null && !bitmap.isRecycled()) {
                        bitmap.recycle();
                        LogUtil.ownShow("entryRemoved: Bitmap recycle.");
                    }
                    return;
                }
                catch (Exception exception) {
                    if (TradPlus.getLocalDebugMode()) {
                        exception.printStackTrace();
                    }
                    return;
                }
            }
        };
    }

    public static ImageLoader getInstance(Context context) {
        if (b == null) {
            b = new ImageLoader(context);
        }
        return b;
    }

    public void load(ResourceEntry resourceEntry, ImageLoaderListener imageLoaderListener) {
        this.load(resourceEntry, -1, -1, imageLoaderListener);
    }

    public void load(ResourceEntry object, int n2, final int n3, ImageLoaderListener imageLoaderListener) {
        if (object == null || TextUtils.isEmpty((CharSequence)((ResourceEntry)object).resourceUrl)) {
            if (imageLoaderListener != null) {
                imageLoaderListener.onFail("", "No url info.");
            }
            return;
        }
        Object object2 = this.getBitmapFromMemCache(((ResourceEntry)object).resourceUrl);
        if (object2 != null) {
            imageLoaderListener.onSuccess(((ResourceEntry)object).resourceUrl, (Bitmap)object2);
            return;
        }
        object2 = this.getBitmapFromDiskCache((ResourceEntry)object, n2, n3);
        if (object2 != null) {
            imageLoaderListener.onSuccess(((ResourceEntry)object).resourceUrl, (Bitmap)object2);
            return;
        }
        object2 = imageLoaderListener;
        final int n4 = n3;
        n3 = n2;
        Object object3 = object;
        object = this;
        if (!((ImageLoader)object).e.containsKey(((ResourceEntry)object3).resourceUrl)) {
            LinkedList<Bitmap> linkedList = new LinkedList<Bitmap>();
            linkedList.add((Bitmap)object2);
            ((ImageLoader)object).e.put(((ResourceEntry)object3).resourceUrl, linkedList);
            object3 = new ImageUrlLoader((ResourceEntry)object3);
            ((ImageUrlLoader)object3).setListener(new ImageUrlLoader.HttpLoadListener(){

                @Override
                public final void onLoadSuccess(ResourceEntry resourceEntry) {
                    LogUtil.ownShow("Load Success:" + resourceEntry.resourceUrl);
                    Message message = ImageLoader.this.f.obtainMessage();
                    ImageLoader.this.f.obtainMessage().what = 1;
                    Bundle bundle = new Bundle();
                    bundle.putString("image_key", resourceEntry.resourceUrl);
                    message.setData(bundle);
                    bundle = ImageLoader.this.getBitmapFromDiskCache(resourceEntry, n3, n4);
                    if (bundle != null) {
                        ImageLoader.this.addBitmapToMemoryCache(resourceEntry.resourceUrl, (Bitmap)bundle);
                    }
                    ImageLoader.this.f.sendMessage(message);
                }

                @Override
                public final void onLoadFail(ResourceEntry resourceEntry, String string) {
                    string = ImageLoader.this.f.obtainMessage();
                    ImageLoader.this.f.obtainMessage().what = 2;
                    Bundle bundle = new Bundle();
                    bundle.putString("image_key", resourceEntry.resourceUrl);
                    string.setData(bundle);
                    ImageLoader.this.f.sendMessage((Message)string);
                }
            });
            ((ResourceDownloadBaseUrlLoader)object3).start();
            return;
        }
        LinkedList linkedList = (LinkedList)((ImageLoader)object).e.get(((ResourceEntry)object3).resourceUrl);
        if (linkedList != null && !linkedList.contains(object2)) {
            linkedList.add(object2);
        }
    }

    public void recycle() {
        try {
            if (this.c != null) {
                this.c.evictAll();
            }
            if (this.e != null) {
                this.e.clear();
            }
            return;
        }
        catch (Exception exception) {
            if (TradPlus.getLocalDebugMode()) {
                exception.printStackTrace();
            }
            return;
        }
    }

    public static interface ImageLoaderListener {
        public void onSuccess(String var1, Bitmap var2);

        public void onFail(String var1, String var2);
    }
}

