/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.unity;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.tradplus.ads.base.CommonUtil;
import com.tradplus.ads.base.bean.TPAdError;
import com.tradplus.ads.base.bean.TPAdInfo;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.common.util.ResourceUtils;
import com.tradplus.ads.common.util.ScreenUtil;
import com.tradplus.ads.mgr.nativead.TPNativeAdRenderImpl;
import com.tradplus.ads.open.DownloadListener;
import com.tradplus.ads.open.LoadAdEveryLayerListener;
import com.tradplus.ads.open.banner.BannerAdListener;
import com.tradplus.ads.open.nativead.TPNativeAdRender;
import com.tradplus.ads.open.nativead.TPNativeBanner;
import com.tradplus.ads.unity.NetworkInfo;
import com.tradplus.ads.unity.TradplusUnityPlugin;
import java.util.HashMap;

public class NativeBannerUnityPlugin
extends TradplusUnityPlugin
implements DownloadListener {
    private TPNativeBanner mTPNativeBanner;
    private RelativeLayout mMainRelativeLayout;
    private int mWight;
    private int mHeight;
    private Activity activity = TradplusUnityPlugin.getActivity();
    private String mLayoutIdByName;
    private static final String TAG = "NativeBannerPlugin";
    private int mAlignment;
    private HashMap<String, Object> hashMap = new HashMap();
    private boolean isHide = false;
    BannerAdListener mBannerAdListener = new BannerAdListener(){

        @Override
        public final void onAdClicked(TPAdInfo tPAdInfo) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)"onAdClicked: ");
            TradplusUnityPlugin.UnityEvent.onNativeBannerAdClicked.Emit(JSON.toJSONString((Object)tPAdInfo));
        }

        @Override
        public final void onAdImpression(TPAdInfo tPAdInfo) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)"onAdImpression: ");
            TradplusUnityPlugin.UnityEvent.onNativeBannerAdImpression.Emit(JSON.toJSONString((Object)tPAdInfo));
        }

        @Override
        public final void onAdLoaded(final TPAdInfo tPAdInfo) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)"onAdLoaded: ");
            if (NativeBannerUnityPlugin.this.mWight == 0 && NativeBannerUnityPlugin.this.mHeight == 0) {
                NativeBannerUnityPlugin.this.mWight = 320;
                NativeBannerUnityPlugin.this.mHeight = 50;
            }
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)("height :" + NativeBannerUnityPlugin.this.mHeight));
            final float f2 = ScreenUtil.getScreenDensity((Activity)NativeBannerUnityPlugin.this.activity);
            TradplusUnityPlugin.runSafelyOnUiThread(new Runnable(){

                @Override
                public final void run() {
                    View view;
                    if (NativeBannerUnityPlugin.this.mMainRelativeLayout == null) {
                        NativeBannerUnityPlugin.this.mMainRelativeLayout = ScreenUtil.prepLayout((int)NativeBannerUnityPlugin.this.mAlignment, (RelativeLayout)NativeBannerUnityPlugin.this.mMainRelativeLayout, (Context)NativeBannerUnityPlugin.this.activity);
                        Log.i((String)NativeBannerUnityPlugin.TAG, (String)("alignment: " + NativeBannerUnityPlugin.this.mAlignment));
                        NativeBannerUnityPlugin.this.activity.addContentView((View)NativeBannerUnityPlugin.this.mMainRelativeLayout, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                        NativeBannerUnityPlugin.this.mMainRelativeLayout.removeAllViews();
                        view = new RelativeLayout((Context)NativeBannerUnityPlugin.this.activity);
                        view.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams((int)((float)NativeBannerUnityPlugin.this.mWight * f2), -2));
                        NativeBannerUnityPlugin.this.mMainRelativeLayout.addView(view);
                        view.removeAllViews();
                        if (NativeBannerUnityPlugin.this.mTPNativeBanner.getParent() != null) {
                            ((ViewGroup)NativeBannerUnityPlugin.this.mTPNativeBanner.getParent()).removeView((View)NativeBannerUnityPlugin.this.mTPNativeBanner);
                        }
                        view.addView((View)NativeBannerUnityPlugin.this.mTPNativeBanner);
                        NativeBannerUnityPlugin.this.mMainRelativeLayout.setVisibility(NativeBannerUnityPlugin.this.isHide ? 8 : 0);
                    }
                    if (tPAdInfo.height != 0 && "audience-network".equals(tPAdInfo.adSourceName)) {
                        TradplusUnityPlugin.UnityEvent.onNativeBannerAdLoaded.Emit(JSON.toJSONString((Object)tPAdInfo), String.valueOf(tPAdInfo.height));
                        return;
                    }
                    if (NativeBannerUnityPlugin.this.mTPNativeBanner != null) {
                        LinearLayout.LayoutParams layoutParams;
                        view = NativeBannerUnityPlugin.this.mTPNativeBanner.findViewById(CommonUtil.getResId((Context)TradplusUnityPlugin.getActivity(), (String)"tp_ll_nativebanner", (String)"id"));
                        View view2 = NativeBannerUnityPlugin.this.mTPNativeBanner.findViewById(CommonUtil.getResId((Context)TradplusUnityPlugin.getActivity(), (String)"tp_ll_ad_choices", (String)"id"));
                        if (view2 != null) {
                            layoutParams = (LinearLayout.LayoutParams)view2.getLayoutParams();
                            layoutParams.width = NativeBannerUnityPlugin.this.mWight == -1 ? DeviceUtils.getScreenWidth((Context)TradplusUnityPlugin.getActivity()) : (int)((float)NativeBannerUnityPlugin.this.mWight * f2);
                            view2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                        }
                        if (view != null) {
                            layoutParams = (LinearLayout.LayoutParams)view.getLayoutParams();
                            layoutParams.width = NativeBannerUnityPlugin.this.mWight == -1 ? DeviceUtils.getScreenWidth((Context)TradplusUnityPlugin.getActivity()) : (int)((float)NativeBannerUnityPlugin.this.mWight * f2);
                            layoutParams.height = (int)((float)NativeBannerUnityPlugin.this.mHeight * f2);
                            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                        }
                    }
                    TradplusUnityPlugin.UnityEvent.onNativeBannerAdLoaded.Emit(JSON.toJSONString((Object)tPAdInfo), String.valueOf(NativeBannerUnityPlugin.this.mHeight));
                }
            });
        }

        @Override
        public final void onAdLoadFailed(TPAdError tPAdError) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)("onAdLoadFailed: msg : " + tPAdError.getErrorMsg()));
            if (NativeBannerUnityPlugin.this.mAdUnitId == null) {
                return;
            }
            TradplusUnityPlugin.UnityEvent.onNativeBannerAdLoadFailed.Emit(NativeBannerUnityPlugin.this.mAdUnitId, tPAdError.getErrorMsg());
        }

        @Override
        public final void onAdClosed(TPAdInfo tPAdInfo) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)"onAdClosed: ");
            TradplusUnityPlugin.UnityEvent.onNativeBannerAdClosed.Emit(JSON.toJSONString((Object)tPAdInfo));
        }

        @Override
        public final void onAdShowFailed(TPAdError tPAdError, TPAdInfo tPAdInfo) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)"onAdShowFailed: ");
            TradplusUnityPlugin.UnityEvent.onNativeBannerShowFailed.Emit(JSON.toJSONString((Object)tPAdInfo), tPAdError.getErrorMsg());
        }
    };
    LoadAdEveryLayerListener mLoadAdEveryLayerListener = new LoadAdEveryLayerListener(){

        @Override
        public final void onAdAllLoaded(boolean bl) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)"onAdAllLoaded: isSuccess : ".concat(String.valueOf(bl)));
            if (NativeBannerUnityPlugin.this.mAdUnitId == null) {
                return;
            }
            TradplusUnityPlugin.UnityEvent.onNativeBannerAdAllLoaded.Emit(String.valueOf(bl), NativeBannerUnityPlugin.this.mAdUnitId);
        }

        @Override
        public final void oneLayerLoadFailed(TPAdError tPAdError, TPAdInfo tPAdInfo) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)("oneLayerLoadFailed: msg : " + tPAdError.getErrorMsg()));
            TradplusUnityPlugin.UnityEvent.oneNativeBannerLayerLoadFailed.Emit(JSON.toJSONString((Object)tPAdInfo), tPAdError.getErrorMsg());
        }

        @Override
        public final void oneLayerLoaded(TPAdInfo tPAdInfo) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)"oneLayerLoaded: ");
            TradplusUnityPlugin.UnityEvent.oneNativeBannerLayerLoaded.Emit(JSON.toJSONString((Object)tPAdInfo));
        }

        @Override
        public final void onAdStartLoad(String string) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)"onAdStartLoad: ");
            TradplusUnityPlugin.UnityEvent.onNativeBannerAdStartLoad.Emit(NativeBannerUnityPlugin.this.mAdUnitId);
        }

        @Override
        public final void oneLayerLoadStart(TPAdInfo tPAdInfo) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)"oneLayerLoadStart: ");
            TradplusUnityPlugin.UnityEvent.oneNativeBannerLayerStartLoad.Emit(JSON.toJSONString((Object)tPAdInfo));
        }

        @Override
        public final void onAdIsLoading(String string) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)"onAdIsLoading Data : ".concat(String.valueOf(string)));
        }

        @Override
        public final void onBiddingStart(TPAdInfo tPAdInfo) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)"onBiddingStart: ");
            TradplusUnityPlugin.UnityEvent.onNativeBannerBiddingStart.Emit(JSON.toJSONString((Object)tPAdInfo));
        }

        @Override
        public final void onBiddingEnd(TPAdInfo tPAdInfo, TPAdError tPAdError) {
            Log.i((String)NativeBannerUnityPlugin.TAG, (String)("onBiddingEnd: adError :" + tPAdError.getErrorCode()));
            TradplusUnityPlugin.UnityEvent.onNativeBannerBiddingEnd.Emit(JSON.toJSONString((Object)tPAdInfo), "" + tPAdError.getErrorCode());
        }
    };

    public NativeBannerUnityPlugin(String string) {
        super(string);
    }

    public void setNativeBannerSize(int n, int n2) {
        Log.i((String)TAG, (String)("setSize: width :" + n + ", height :" + n2));
        this.mWight = n;
        this.mHeight = n2;
    }

    public void setCustomParams(String string) {
        Log.i((String)TAG, (String)"setCustomParams: map".concat(String.valueOf(string)));
        try {
            if (!TextUtils.isEmpty((CharSequence)string)) {
                this.hashMap = (HashMap)JSON.parseObject((String)string, HashMap.class);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void createNativeBanner(int n) {
        this.createNativeBanner(n, "", "");
    }

    public void createNativeBanner(int n, String string) {
        this.createNativeBanner(n, string, "");
    }

    public void createNativeBanner(int n, String string, String string2) {
        Log.i((String)TAG, (String)"createNativeBanner: ".concat(String.valueOf(string2)));
        this.mAlignment = n;
        this.mLayoutIdByName = string2;
        if (this.mTPNativeBanner == null) {
            this.mTPNativeBanner = new TPNativeBanner((Context)this.activity);
        }
        this.mTPNativeBanner.setAdListener(this.mBannerAdListener);
        this.mTPNativeBanner.setDownloadListener(this);
        this.mTPNativeBanner.setAllAdLoadListener(this.mLoadAdEveryLayerListener);
        if (!this.hashMap.isEmpty()) {
            this.mTPNativeBanner.setCustomParams(this.hashMap);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mLayoutIdByName)) {
            Object object = (ViewGroup)((LayoutInflater)this.activity.getSystemService("layout_inflater")).inflate(ResourceUtils.getLayoutIdByName((Context)this.activity, (String)this.mLayoutIdByName), null);
            object = new TPNativeAdRenderImpl((Context)this.activity, (ViewGroup)object);
            this.mTPNativeBanner.setNativeAdRender((TPNativeAdRender)object);
        }
        this.mTPNativeBanner.loadAd(this.mAdUnitId, TextUtils.isEmpty((CharSequence)string) ? "" : string, 0.0f);
    }

    public void hideNativeBanner() {
        this.isHide = true;
        TradplusUnityPlugin.runSafelyOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (NativeBannerUnityPlugin.this.mTPNativeBanner == null) {
                    return;
                }
                Log.i((String)NativeBannerUnityPlugin.TAG, (String)"NativeBanner GONE");
                NativeBannerUnityPlugin.this.mMainRelativeLayout.setVisibility(8);
            }
        });
    }

    public void displayNativeBanner() {
        this.isHide = false;
        TradplusUnityPlugin.runSafelyOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (NativeBannerUnityPlugin.this.mTPNativeBanner == null) {
                    return;
                }
                Log.i((String)NativeBannerUnityPlugin.TAG, (String)"NativeBanner VISIBLE");
                NativeBannerUnityPlugin.this.mMainRelativeLayout.setVisibility(0);
            }
        });
    }

    public void destroyNativeBanner() {
        TradplusUnityPlugin.runSafelyOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (NativeBannerUnityPlugin.this.mTPNativeBanner == null || NativeBannerUnityPlugin.this.mMainRelativeLayout == null) {
                    return;
                }
                ((ViewGroup)NativeBannerUnityPlugin.this.mMainRelativeLayout.getParent()).removeView((View)NativeBannerUnityPlugin.this.mMainRelativeLayout);
                NativeBannerUnityPlugin.this.mMainRelativeLayout = null;
                NativeBannerUnityPlugin.this.mTPNativeBanner.onDestroy();
            }
        });
    }

    public void entryAdScenario(String string) {
        if (this.mTPNativeBanner != null) {
            this.mTPNativeBanner.entryAdScenario(TextUtils.isEmpty((CharSequence)string) ? "" : string);
        }
    }

    public void reloadNativeBannerAd() {
    }

    @Override
    public void onDownloadStart(TPAdInfo tPAdInfo, long l, long l2, String string, String string2) {
        NetworkInfo networkInfo = new NetworkInfo(l, l2, string, string2);
        TradplusUnityPlugin.UnityEvent.onNativeBannerDownloadStart.Emit(JSON.toJSONString((Object)tPAdInfo), JSON.toJSONString((Object)networkInfo));
    }

    @Override
    public void onDownloadUpdate(TPAdInfo tPAdInfo, long l, long l2, String string, String string2, int n) {
        NetworkInfo networkInfo = new NetworkInfo(l, l2, string, string2);
        TradplusUnityPlugin.UnityEvent.onNativeBannerDownloadUpdate.Emit(JSON.toJSONString((Object)tPAdInfo), JSON.toJSONString((Object)networkInfo));
    }

    @Override
    public void onDownloadPause(TPAdInfo tPAdInfo, long l, long l2, String string, String string2) {
        NetworkInfo networkInfo = new NetworkInfo(l, l2, string, string2);
        TradplusUnityPlugin.UnityEvent.onNativeBannerDownloadPause.Emit(JSON.toJSONString((Object)tPAdInfo), JSON.toJSONString((Object)networkInfo));
    }

    @Override
    public void onDownloadFinish(TPAdInfo tPAdInfo, long l, long l2, String string, String string2) {
        NetworkInfo networkInfo = new NetworkInfo(l, l2, string, string2);
        TradplusUnityPlugin.UnityEvent.onNativeBannerDownloadFinish.Emit(JSON.toJSONString((Object)tPAdInfo), JSON.toJSONString((Object)networkInfo));
    }

    @Override
    public void onDownloadFail(TPAdInfo tPAdInfo, long l, long l2, String string, String string2) {
        NetworkInfo networkInfo = new NetworkInfo(l, l2, string, string2);
        TradplusUnityPlugin.UnityEvent.onNativeBannerDownloadFail.Emit(JSON.toJSONString((Object)tPAdInfo), JSON.toJSONString((Object)networkInfo));
    }

    @Override
    public void onInstalled(TPAdInfo tPAdInfo, long l, long l2, String string, String string2) {
        NetworkInfo networkInfo = new NetworkInfo(l, l2, string, string2);
        TradplusUnityPlugin.UnityEvent.onNativeBannerInstalled.Emit(JSON.toJSONString((Object)tPAdInfo), JSON.toJSONString((Object)networkInfo));
    }
}

