/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.mgr;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import android.view.ViewGroup;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.bean.TPAdError;
import com.tradplus.ads.base.common.TPDataManager;
import com.tradplus.ads.base.common.TPShareManager;
import com.tradplus.ads.base.config.ConfigLoadManager;
import com.tradplus.ads.base.filter.NetWorkFrequencyUtils;
import com.tradplus.ads.base.network.TPSettingManager;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.base.util.SegmentUtils;
import com.tradplus.ads.common.util.CustomLogUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.core.AdCacheManager;
import com.tradplus.ads.core.AdMediationManager;
import com.tradplus.ads.core.cache.AdCache;
import com.tradplus.ads.core.track.LoadLifecycleCallback;
import com.tradplus.ads.open.interstitial.InterstitialAdListener;
import com.tradplus.ads.open.interstitial.TPInterstitial;
import com.tradplus.ads.open.nativead.NativeAdListener;
import com.tradplus.ads.open.nativead.TPNative;
import com.tradplus.ads.open.reward.RewardAdListener;
import com.tradplus.ads.open.reward.TPReward;
import com.tradplus.ads.open.splash.SplashAdListener;
import com.tradplus.ads.open.splash.TPSplash;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AdShareMgr {
    public static final String NATIVE = "native";
    public static final String SPLASH = "splash";
    public static final String INTER = "interstitial";
    public static final String REWARD = "interstitial-video";
    private static ConcurrentHashMap<String, AdShareMgr> adShareManagerMap = new ConcurrentHashMap();
    private String mAdUnitId;
    private String mShareAdUnitId;
    private long mRequestSec;
    private HandlerThread mHandlerThread;
    private Handler mThreadHandler;
    private TPNative tpNative;
    private TPInterstitial tpInterstitial;
    private TPReward tpReward;
    private TPSplash tpSplash;
    private InterstitialAdListener interstitialAdListener;
    private NativeAdListener nativeAdListener;
    private RewardAdListener rewardAdListener;
    private SplashAdListener splashAdListener;

    private AdShareMgr(String string) {
        this.mAdUnitId = string;
    }

    public static synchronized AdShareMgr getInstance(String string) {
        AdShareMgr adShareMgr = adShareManagerMap.get(string);
        if (adShareMgr == null) {
            AdShareMgr adShareMgr2;
            adShareMgr = adShareMgr2;
            adShareMgr2 = new AdShareMgr(string);
            adShareMgr.mHandlerThread = new HandlerThread("tp-thread-AdShareMgr-" + string);
            adShareMgr.mHandlerThread.start();
            adShareMgr2.mThreadHandler = new Handler(adShareMgr.mHandlerThread.getLooper());
            adShareManagerMap.put(string, adShareMgr);
        }
        return adShareMgr;
    }

    private void openAutoLoad(String string, ViewGroup viewGroup) {
        Activity activity = GlobalTradPlus.getInstance().getActivity();
        Context context = GlobalTradPlus.getInstance().getContext();
        if (context == null && activity == null) {
            return;
        }
        if (activity == null || activity.isFinishing()) {
            activity = context;
        }
        AdShareMgr adShareMgr = map;
        AdShareMgr adShareMgr2 = map;
        boolean bl = TPSettingManager.getInstance().isOpenAutoLoad(((AdShareMgr)((Object)map)).mShareAdUnitId);
        Map map = GlobalTradPlus.getInstance().getUserLoadParam(((AdShareMgr)((Object)map)).mAdUnitId);
        adShareMgr2.setCustomSegmentId();
        adShareMgr.postDelayedLoadTask(() -> adShareMgr.lambda$openAutoLoad$0(string, (Context)activity, map, bl, viewGroup));
    }

    private double getEcpm(AdCache adCache) {
        double d2 = 0.0;
        if ((adCache = adCache.getConfigBean()) != null) {
            AdCache adCache2 = adCache;
            d2 = adCache2.getEcpm();
            if (adCache2.getNew_sort_type() == 9) {
                double d3;
                double d4 = this.dataForImp((ConfigResponse.WaterfallBean)adCache);
                if (d3 > 0.0) {
                    d2 = d4;
                }
            }
            LogUtil.ownShow((String)("AdShareManager getEcpm NetWorkPID == " + adCache.getAdsource_placement_id() + "  ecpm == " + d2));
        }
        return d2;
    }

    private double dataForImp(ConfigResponse.WaterfallBean waterfallBean) {
        double d2 = 0.0;
        if (waterfallBean != null && (this = waterfallBean.getPayLoadInfo()) != null && (this = this.getExt()) != null) {
            if (TextUtils.isEmpty((CharSequence)(this = this.getValue()))) {
                return d2;
            }
            try {
                d2 = Double.parseDouble((String)this);
            }
            catch (Throwable throwable) {
                d2 = TPDataManager.getInstance().dataForImp((String)this);
            }
        }
        return d2;
    }

    private void setCustomSegmentId() {
        if (TextUtils.isEmpty((CharSequence)this.mShareAdUnitId)) {
            return;
        }
        Map map = SegmentUtils.customPlacementMap;
        if (map != null && (map = (Map)map.get(this.mAdUnitId)) != null) {
            Log.i((String)"AdShareMgr", (String)("setCustomSegmentId: " + map.toString()));
            SegmentUtils.initPlacementCustomMap((String)this.mShareAdUnitId, (Map)map);
        }
    }

    private boolean checkAdShareUnitFrenquency() {
        if (!NetWorkFrequencyUtils.getInstance().checkAdShareUnitFrenquency(this.mShareAdUnitId)) {
            LogUtil.ownShow((String)("AdShareManager checkAdShareUnitFrenquency SystemClock.elapsedRealtime() == " + SystemClock.elapsedRealtime()));
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.LOAD_NETWORK_SHAREUNITIDLIMIT);
            this.sendLoadEvent();
            return true;
        }
        return false;
    }

    private void sendLoadEvent() {
        ConfigResponse configResponse = ConfigLoadManager.getInstance().getLocalConfigResponse(this.mAdUnitId);
        LoadLifecycleCallback loadLifecycleCallback = new LoadLifecycleCallback(this.mShareAdUnitId, null);
        loadLifecycleCallback.loadStart(6, configResponse);
        loadLifecycleCallback.loadEnd("30", 6, configResponse);
    }

    private void postDelayedLoadTask(Runnable runnable) {
        Handler handler = this.mThreadHandler;
        if (handler != null) {
            handler.removeCallbacksAndMessages(null);
            this.mThreadHandler.postDelayed(runnable, this.mRequestSec);
        }
    }

    private boolean isNotFinishing() {
        AdShareMgr adShareMgr = GlobalTradPlus.getInstance().getActivity();
        return adShareMgr != null && !adShareMgr.isFinishing();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private /* synthetic */ void lambda$openAutoLoad$0(String var1_1, Context var2_2, Map var3_3, boolean var4_4, ViewGroup var5_6) {
        block28: {
            block29: {
                block27: {
                    block26: {
                        block25: {
                            try {
                                if (!"native".equals(var1_1)) ** GOTO lbl24
                            }
                            catch (Throwable v0) {}
                            var1_1 = v1;
                            v1 = new TPNative(var2_2 /* !! */ , this.mShareAdUnitId);
                            this.tpNative = var1_1;
                            var2_2 /* !! */  = this.nativeAdListener;
                            if (var2_2 /* !! */  == null) ** GOTO lbl12
                            var1_1.setAdListener((NativeAdListener)var2_2 /* !! */ );
lbl12:
                            // 2 sources

                            this.tpNative.setCustomParams(var3_3);
                            if (var4_4) ** GOTO lbl23
                            if (!this.checkAdShareUnitFrenquency()) break block25;
                            return;
                        }
                        this = this.tpNative;
                        if (this == null) ** GOTO lbl23
                        this.loadAd();
lbl23:
                        // 3 sources

                        return;
lbl24:
                        // 1 sources

                        if (!"interstitial".equals(var1_1)) ** GOTO lbl45
                        var1_1 = v2;
                        v2 = new TPInterstitial(var2_2 /* !! */ , this.mShareAdUnitId);
                        this.tpInterstitial = var1_1;
                        var2_2 /* !! */  = this.interstitialAdListener;
                        if (var2_2 /* !! */  == null) ** GOTO lbl33
                        var1_1.setAdListener((InterstitialAdListener)var2_2 /* !! */ );
lbl33:
                        // 2 sources

                        this.tpInterstitial.setCustomParams(var3_3);
                        if (var4_4) ** GOTO lbl44
                        if (!this.checkAdShareUnitFrenquency()) break block26;
                        return;
                    }
                    this = this.tpInterstitial;
                    if (this == null) ** GOTO lbl44
                    this.loadAd();
lbl44:
                    // 3 sources

                    return;
lbl45:
                    // 1 sources

                    if (!"interstitial-video".equals(var1_1)) ** GOTO lbl65
                    var6_7 = v3;
                    v3 = new TPReward(var2_2 /* !! */ , this.mShareAdUnitId);
                    this.tpReward = var6_7;
                    var7_8 = this.rewardAdListener;
                    if (var7_8 == null) ** GOTO lbl54
                    var6_7.setAdListener(var7_8);
lbl54:
                    // 2 sources

                    this.tpReward.setCustomParams(var3_3);
                    if (var4_4) ** GOTO lbl65
                    if (!super.checkAdShareUnitFrenquency()) break block27;
                    return;
                }
                var4_5 = this.tpReward;
                if (var4_5 == null) ** GOTO lbl65
                var4_5.loadAd();
lbl65:
                // 4 sources

                if (!"splash".equals(var1_1)) break block28;
                var1_1 = v4;
                v4 = new TPSplash(var2_2 /* !! */ , this.mShareAdUnitId);
                this.tpSplash = var1_1;
                var2_2 /* !! */  = this.splashAdListener;
                if (var2_2 /* !! */  == null) ** GOTO lbl74
                var1_1.setAdListener((SplashAdListener)var2_2 /* !! */ );
lbl74:
                // 2 sources

                this.tpSplash.setCustomParams(var3_3);
                if (!super.checkAdShareUnitFrenquency()) break block29;
                return;
            }
            this = this.tpSplash;
            if (this == null) break block28;
            this.loadAd(var5_6);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void loadShareId(String string, String string2, int n2) {
        this.mRequestSec = n2;
        LogUtil.ownShow((String)("AdShareManager loadShareId adUnitId == " + this.mAdUnitId + ",shareId == " + string2 + ", mShareAdUnitId == " + this.mShareAdUnitId));
        if (string2 == null) {
            return;
        }
        String string3 = this.mShareAdUnitId;
        if (string3 != null) {
            if (string3.equals(string2)) return;
        }
        this.mShareAdUnitId = string2;
        this.openAutoLoad(string, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void loadSplashShareId(String string, ViewGroup viewGroup, String string2, int n2) {
        this.mRequestSec = n2;
        LogUtil.ownShow((String)("AdShareManager loadSplash adUnitId == " + this.mAdUnitId + ",shareId == " + string2 + ", mShareAdUnitId == " + this.mShareAdUnitId));
        if (string2 == null) {
            return;
        }
        String string3 = this.mShareAdUnitId;
        if (string3 != null) {
            if (string3.equals(string2)) return;
        }
        this.mShareAdUnitId = string2;
        this.openAutoLoad(string, viewGroup);
    }

    public void onDestroy() {
        Object object = this.mThreadHandler;
        if (object != null) {
            object.removeCallbacksAndMessages(null);
        }
        if (this.mShareAdUnitId != null) {
            this.mShareAdUnitId = null;
        }
        this.mRequestSec = 0L;
        object = this.tpNative;
        if (object != null) {
            ((TPNative)object).onDestroy();
            this.tpNative = null;
        }
        if ((object = this.tpInterstitial) != null) {
            ((TPInterstitial)object).onDestroy();
            this.tpInterstitial = null;
        }
        if ((object = this.tpReward) != null) {
            ((TPReward)object).onDestroy();
            this.tpReward = null;
        }
        if ((object = this.tpSplash) != null) {
            ((TPSplash)object).onClean();
            this.tpSplash = null;
        }
        LogUtil.ownShow((String)("AdShareManager adUnitId == " + this.mAdUnitId + "  unbindShareUnitId == " + this.mShareAdUnitId));
    }

    public String getShareUnitId() {
        return this.mShareAdUnitId;
    }

    public synchronized AdCache getReadyAd() {
        AdCache adCache = AdCacheManager.getInstance().getReadyAd(this.mAdUnitId);
        if (TextUtils.isEmpty((CharSequence)this.mShareAdUnitId)) {
            return adCache;
        }
        AdCache adCache2 = AdCacheManager.getInstance().getReadyAd(this.mShareAdUnitId);
        if (adCache == null && adCache2 == null) {
            return null;
        }
        if (adCache2 == null && adCache != null) {
            return adCache;
        }
        if (adCache2 != null && adCache == null) {
            AdMediationManager.getInstance((String)this.mAdUnitId).setLoadSuccess(false);
            return adCache2;
        }
        if (this.getEcpm(adCache) >= this.getEcpm(adCache2)) {
            return adCache;
        }
        return adCache2;
    }

    public synchronized AdCache sortAdCacheToShow() {
        if (TextUtils.isEmpty((CharSequence)this.mShareAdUnitId)) {
            return AdCacheManager.getInstance().getAdCacheToShow(this.mAdUnitId);
        }
        AdCache adCache = AdCacheManager.getInstance().getReadyAd(this.mAdUnitId);
        AdCache adCache2 = AdCacheManager.getInstance().getReadyAd(this.mShareAdUnitId);
        if (adCache == null && adCache2 == null) {
            return null;
        }
        if (adCache2 == null && adCache != null) {
            return AdCacheManager.getInstance().getAdCacheToShow(this.mAdUnitId);
        }
        if (adCache2 != null && adCache == null) {
            AdMediationManager.getInstance((String)this.mAdUnitId).setLoadSuccess(false);
            return AdCacheManager.getInstance().getAdCacheToShow(this.mShareAdUnitId);
        }
        if (this.getEcpm(adCache) >= this.getEcpm(adCache2)) {
            return AdCacheManager.getInstance().getAdCacheToShow(this.mAdUnitId);
        }
        AdMediationManager.getInstance((String)this.mShareAdUnitId).setLoadSuccess(false);
        return AdCacheManager.getInstance().getAdCacheToShow(this.mShareAdUnitId);
    }

    public void loadSplashAd(ViewGroup viewGroup) {
        if (TextUtils.isEmpty((CharSequence)this.mShareAdUnitId)) {
            return;
        }
        if (this.checkAdShareUnitFrenquency()) {
            return;
        }
        AdShareMgr adShareMgr = this;
        this.setCustomSegmentId();
        adShareMgr.postDelayedLoadTask(() -> {
            if (this.tpSplash != null && this.isNotFinishing()) {
                this.tpSplash.loadAd(viewGroup);
            }
        });
    }

    public void loadAd() {
        if (TextUtils.isEmpty((CharSequence)this.mShareAdUnitId)) {
            return;
        }
        if (this.checkAdShareUnitFrenquency()) {
            return;
        }
        AdShareMgr adShareMgr = this;
        LogUtil.ownShow((String)("AdShareManager loadAd mShareAdUnitId == " + this.mShareAdUnitId));
        adShareMgr.setCustomSegmentId();
        adShareMgr.postDelayedLoadTask(() -> {
            if (((AdShareMgr)this).isNotFinishing()) {
                Object object = ((AdShareMgr)this).tpNative;
                if (object != null) {
                    ((TPNative)object).loadAd();
                }
                if ((object = ((AdShareMgr)this).tpInterstitial) != null) {
                    ((TPInterstitial)object).loadAd();
                }
                if ((this = ((AdShareMgr)this).tpReward) != null) {
                    ((TPReward)this).loadAd();
                }
            }
        });
    }

    public boolean isReady() {
        if (TextUtils.isEmpty((CharSequence)((AdShareMgr)((Object)tPSplash)).mShareAdUnitId)) {
            return false;
        }
        Object object = ((AdShareMgr)((Object)tPSplash)).tpNative;
        if (object != null) {
            return ((TPNative)object).isReady();
        }
        object = ((AdShareMgr)((Object)tPSplash)).tpInterstitial;
        if (object != null) {
            return ((TPInterstitial)object).isReady();
        }
        object = ((AdShareMgr)((Object)tPSplash)).tpReward;
        if (object != null) {
            return ((TPReward)object).isReady();
        }
        TPSplash tPSplash = ((AdShareMgr)((Object)tPSplash)).tpSplash;
        if (tPSplash != null) {
            return tPSplash.isReady();
        }
        return false;
    }

    public void setInterstitialListener(InterstitialAdListener interstitialAdListener) {
        ((AdShareMgr)((Object)tPInterstitial)).interstitialAdListener = interstitialAdListener;
        TPInterstitial tPInterstitial = ((AdShareMgr)((Object)tPInterstitial)).tpInterstitial;
        if (tPInterstitial != null) {
            tPInterstitial.setAdListener(interstitialAdListener);
        }
    }

    public void setNativeAdListener(NativeAdListener nativeAdListener) {
        ((AdShareMgr)((Object)tPNative)).nativeAdListener = nativeAdListener;
        TPNative tPNative = ((AdShareMgr)((Object)tPNative)).tpNative;
        if (tPNative != null) {
            tPNative.setAdListener(nativeAdListener);
        }
    }

    public void setRewardListener(RewardAdListener rewardAdListener) {
        ((AdShareMgr)((Object)tPReward)).rewardAdListener = rewardAdListener;
        TPReward tPReward = ((AdShareMgr)((Object)tPReward)).tpReward;
        if (tPReward != null) {
            tPReward.setAdListener(rewardAdListener);
        }
    }

    public void setSplashListener(SplashAdListener splashAdListener) {
        ((AdShareMgr)((Object)tPSplash)).splashAdListener = splashAdListener;
        TPSplash tPSplash = ((AdShareMgr)((Object)tPSplash)).tpSplash;
        if (tPSplash != null) {
            tPSplash.setAdListener(splashAdListener);
        }
    }

    public boolean shouldCallLoaded() {
        try {
            return TPShareManager.getInstance().shouldCallLoaded(this.mAdUnitId, new TPShareManager.IAdMediationLoadedCallback(){

                public void setCanCallLoaded(String string, boolean bl) {
                    if (TextUtils.isEmpty((CharSequence)string)) {
                        return;
                    }
                    AdMediationManager.getInstance((String)string).canCallLoaded(bl);
                }

                public boolean getCanCallLoaded(String string) {
                    if (TextUtils.isEmpty((CharSequence)string)) {
                        return TPShareManager.getInstance().isShareId(AdShareMgr.this.mAdUnitId) ^ true;
                    }
                    return AdMediationManager.getInstance((String)string).isCanCallLoaded();
                }
            });
        }
        catch (Throwable throwable) {
            Log.i((String)"AdShareManager", (String)("shouldCallLoaded: " + throwable.getMessage()));
            return TPShareManager.getInstance().isShareId(this.mAdUnitId) ^ true;
        }
    }

    public boolean shouldCallFailed(TPAdError object) {
        TPShareManager.IAdMediationFailedCallback iAdMediationFailedCallback;
        TPAdError tPAdError;
        String string;
        TPShareManager tPShareManager;
        try {
            tPShareManager = TPShareManager.getInstance();
            string = this.mAdUnitId;
            tPAdError = object;
        }
        catch (Throwable throwable) {
            Log.i((String)"AdShareManager", (String)("shouldCallFailed: " + throwable.getMessage()));
            return TPShareManager.getInstance().isShareId(this.mAdUnitId) ^ true;
        }
        object = iAdMediationFailedCallback;
        iAdMediationFailedCallback = new TPShareManager.IAdMediationFailedCallback(){

            public void setCanCallFailed(String string, boolean bl) {
                if (TextUtils.isEmpty((CharSequence)string)) {
                    return;
                }
                AdMediationManager.getInstance((String)string).canCallFailed(bl);
            }

            public boolean getCanCallFailed(String string) {
                if (TextUtils.isEmpty((CharSequence)string)) {
                    return TPShareManager.getInstance().isShareId(AdShareMgr.this.mAdUnitId) ^ true;
                }
                return AdMediationManager.getInstance((String)string).isCanCallFailed();
            }
        };
        return tPShareManager.shouldCallFailed(string, tPAdError, (TPShareManager.IAdMediationFailedCallback)object);
    }
}

