/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.mgr.autoload;

import android.os.Handler;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.common.TPDataManager;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.network.NetStateChangeObserver;
import com.tradplus.ads.base.network.NetworkChangeManager;
import com.tradplus.ads.base.network.TPSettingManager;
import com.tradplus.ads.common.util.CustomLogUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.mgr.autoload.AutoLoadBanner;
import com.tradplus.ads.mgr.autoload.AutoLoadInterstitial;
import com.tradplus.ads.mgr.autoload.AutoLoadMediaVideo;
import com.tradplus.ads.mgr.autoload.AutoLoadNative;
import com.tradplus.ads.mgr.autoload.AutoLoadNativeBanner;
import com.tradplus.ads.mgr.autoload.AutoLoadOfferWall;
import com.tradplus.ads.mgr.autoload.AutoLoadReward;
import com.tradplus.ads.mgr.autoload.AutoLoadUnit;
import com.tradplus.ads.open.banner.TPBanner;
import com.tradplus.ads.open.interstitial.TPInterstitial;
import com.tradplus.ads.open.mediavideo.TPMediaVideo;
import com.tradplus.ads.open.nativead.TPNative;
import com.tradplus.ads.open.nativead.TPNativeBanner;
import com.tradplus.ads.open.offerwall.TPOfferWall;
import com.tradplus.ads.open.reward.TPReward;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AutoLoadManager {
    private static AutoLoadManager mInstance;
    private final long AUTO_LOAD_INTERVAL_TIME;
    private ConcurrentHashMap<String, AutoLoadUnit> mAutoLoadUnits;
    private NetStateChangeObserver netStateChangeObserver;
    private boolean isOpenDelayLoadAds;
    private Runnable autoLoadRunnable;

    private AutoLoadManager() {
        AutoLoadManager autoLoadManager = this;
        autoLoadManager.AUTO_LOAD_INTERVAL_TIME = 300000L;
        autoLoadManager.autoLoadRunnable = new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        LogUtil.ownShow((String)(CustomLogUtils.TradPlusLog.AUTOLOAD_BEGIN + ", interval time:" + 300000L));
                        AutoLoadManager.this.timeToLoadAd();
                    }
                    catch (Exception exception) {
                        if (!TPDataManager.getInstance().isDebugMode()) break block2;
                        exception.printStackTrace();
                    }
                }
                TPTaskManager.getInstance().getAutoThreadHandler().postDelayed(AutoLoadManager.this.autoLoadRunnable, 300000L);
            }
        };
        autoLoadManager.mAutoLoadUnits = new ConcurrentHashMap();
        autoLoadManager.netStateChangeObserver = new NetStateChangeObserver(){

            public void onDisconnect() {
                LogUtil.ownShow((String)"network disconnect");
            }

            public void onConnect() {
                LogUtil.ownShow((String)"network connect");
                AutoLoadManager.this.checkReloadByConnect();
            }
        };
        NetworkChangeManager.getInstance().setNetStateChangeObserver(this.netStateChangeObserver);
        NetworkChangeManager.getInstance().startConnectivityNetwork(GlobalTradPlus.getInstance().getContext());
        autoLoadManager.startAutoLoadRunnable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized AutoLoadManager getInstance() {
        if (mInstance != null) return mInstance;
        Class<AutoLoadManager> clazz = AutoLoadManager.class;
        synchronized (AutoLoadManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new AutoLoadManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private void setServerAutoLoad(AutoLoadUnit autoLoadUnit, String string) {
        if (autoLoadUnit != null) {
            autoLoadUnit.setAutoLoad(TPSettingManager.getInstance().isOpenAutoLoad(string));
        }
    }

    private void checkReloadByConnect() {
        Iterator<Map.Entry<String, AutoLoadUnit>> iterator = ((AutoLoadManager)((Object)iterator)).mAutoLoadUnits.entrySet().iterator();
        while (iterator.hasNext()) {
            AutoLoadUnit autoLoadUnit = (AutoLoadUnit)((Map.Entry)iterator.next()).getValue();
            if (!autoLoadUnit.isAutoLoad() || !autoLoadUnit.isNeedChangeNetworkAutoLoad()) continue;
            AutoLoadUnit autoLoadUnit2 = autoLoadUnit;
            autoLoadUnit2.setNeedChangeNetworkAutoLoad(false);
            autoLoadUnit2.loadAd(13);
        }
    }

    private void autuLoadClose(String string) {
        if (string != null && string.length() > 0) {
            AutoLoadUnit autoLoadUnit = this.mAutoLoadUnits.get(string);
            this.setServerAutoLoad(autoLoadUnit, string);
            if (autoLoadUnit != null && autoLoadUnit.isAutoLoad()) {
                autoLoadUnit.adClose();
                return;
            }
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void setInterstitialAutoLoad(String var1_1, TPInterstitial var2_2) {
        block8: {
            block7: {
                if (var1_1 == null || var1_1.length() <= 0) break block8;
                try {
                    v0 = this;
                    var3_3 = TPSettingManager.getInstance().isOpenAutoLoad(var1_1);
                }
                catch (Throwable v1) {}
                var4_4 = v0.mAutoLoadUnits.get(var1_1);
                if (var4_4 != null) ** GOTO lbl17
                var4_4 = v2;
                var4_4(var1_1, var2_2, var3_3);
                this.mAutoLoadUnits.put(var1_1, var4_4);
                v2.autoLoadStart();
                break block7;
lbl17:
                // 1 sources

                if (!(var4_4 instanceof AutoLoadInterstitial)) break block7;
                v3 = var4_4;
                v3.setAutoLoad(var3_3);
                ((AutoLoadInterstitial)v3).refreshTpInterstitial(var2_2);
            }
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void setRewardAutoLoad(String var1_1, TPReward var2_2) {
        block8: {
            block7: {
                if (var1_1 == null || var1_1.length() <= 0) break block8;
                try {
                    v0 = this;
                    var3_3 = TPSettingManager.getInstance().isOpenAutoLoad(var1_1);
                }
                catch (Throwable v1) {}
                var4_4 = v0.mAutoLoadUnits.get(var1_1);
                if (var4_4 != null) ** GOTO lbl17
                var4_4 = v2;
                var4_4(var1_1, var2_2, var3_3);
                this.mAutoLoadUnits.put(var1_1, var4_4);
                v2.autoLoadStart();
                break block7;
lbl17:
                // 1 sources

                if (!(var4_4 instanceof AutoLoadReward)) break block7;
                v3 = var4_4;
                v3.setAutoLoad(var3_3);
                ((AutoLoadReward)v3).refreshReward(var2_2);
            }
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void setOfferWallAutoLoad(String var1_1, TPOfferWall var2_2) {
        block8: {
            block7: {
                if (var1_1 == null || var1_1.length() <= 0) break block8;
                try {
                    v0 = this;
                    var3_3 = TPSettingManager.getInstance().isOpenAutoLoad(var1_1);
                }
                catch (Throwable v1) {}
                var4_4 = v0.mAutoLoadUnits.get(var1_1);
                if (var4_4 != null) ** GOTO lbl17
                var4_4 = v2;
                var4_4(var1_1, var2_2, var3_3);
                this.mAutoLoadUnits.put(var1_1, var4_4);
                v2.autoLoadStart();
                break block7;
lbl17:
                // 1 sources

                if (!(var4_4 instanceof AutoLoadOfferWall)) break block7;
                v3 = var4_4;
                v3.setAutoLoad(var3_3);
                ((AutoLoadOfferWall)v3).refreshOfferWall(var2_2);
            }
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void setNativeAutoLoad(String var1_1, TPNative var2_2) {
        block8: {
            block7: {
                if (var1_1 == null || var1_1.length() <= 0) break block8;
                try {
                    v0 = this;
                    var3_3 = TPSettingManager.getInstance().isOpenAutoLoad(var1_1);
                }
                catch (Throwable v1) {}
                var4_4 = v0.mAutoLoadUnits.get(var1_1);
                if (var4_4 != null) ** GOTO lbl17
                var4_4 = v2;
                var4_4(var1_1, var2_2, var3_3);
                this.mAutoLoadUnits.put(var1_1, var4_4);
                v2.autoLoadStart();
                break block7;
lbl17:
                // 1 sources

                if (!(var4_4 instanceof AutoLoadNative)) break block7;
                v3 = var4_4;
                v3.setAutoLoad(var3_3);
                ((AutoLoadNative)v3).refreshNative(var2_2);
            }
            return;
        }
    }

    public void setBannerAutoLoad(String string, TPBanner tPBanner, boolean bl) {
        block8: {
            block7: {
                AutoLoadUnit autoLoadUnit;
                block6: {
                    AutoLoadBanner autoLoadBanner;
                    if (string == null || string.length() <= 0) break block8;
                    try {
                        autoLoadUnit = ((AutoLoadManager)((Object)autoLoadBanner2)).mAutoLoadUnits.get(string);
                        if (autoLoadUnit != null) break block6;
                    }
                    catch (Throwable throwable) {}
                    AutoLoadManager autoLoadManager = autoLoadBanner2;
                    AutoLoadBanner autoLoadBanner2 = autoLoadBanner;
                    autoLoadBanner = new AutoLoadBanner(string, tPBanner, bl);
                    autoLoadManager.mAutoLoadUnits.put(string, autoLoadBanner2);
                    break block7;
                }
                if (!(autoLoadUnit instanceof AutoLoadBanner)) break block7;
                ((AutoLoadBanner)autoLoadUnit).refreshBanner(tPBanner);
            }
            return;
        }
    }

    public void setNativeBannerAutoLoad(String string, TPNativeBanner tPNativeBanner, boolean bl) {
        if (string != null && string.length() > 0) {
            AutoLoadUnit autoLoadUnit = ((AutoLoadManager)((Object)autoLoadNativeBanner2)).mAutoLoadUnits.get(string);
            if (autoLoadUnit == null) {
                AutoLoadNativeBanner autoLoadNativeBanner;
                AutoLoadManager autoLoadManager = autoLoadNativeBanner2;
                AutoLoadNativeBanner autoLoadNativeBanner2 = autoLoadNativeBanner;
                autoLoadNativeBanner = new AutoLoadNativeBanner(string, tPNativeBanner, bl);
                autoLoadManager.mAutoLoadUnits.put(string, autoLoadNativeBanner2);
            } else if (autoLoadUnit instanceof AutoLoadNativeBanner) {
                ((AutoLoadNativeBanner)autoLoadUnit).refreshNativeBanner(tPNativeBanner);
            }
            return;
        }
    }

    public void setMediaVideoAutoLoad(String string, TPMediaVideo tPMediaVideo) {
        if (string != null && string.length() > 0) {
            TPSettingManager.getInstance().isOpenAutoLoad(string);
            AutoLoadUnit autoLoadUnit = this.mAutoLoadUnits.get(string);
            if (autoLoadUnit == null) {
                AutoLoadMediaVideo autoLoadMediaVideo;
                autoLoadUnit = autoLoadMediaVideo;
                ((AutoLoadMediaVideo)autoLoadUnit)(string, tPMediaVideo, false);
                this.mAutoLoadUnits.put(string, autoLoadUnit);
                autoLoadMediaVideo.autoLoadStart();
            } else if (autoLoadUnit instanceof AutoLoadMediaVideo) {
                AutoLoadUnit autoLoadUnit2 = autoLoadUnit;
                autoLoadUnit2.setAutoLoad(false);
                ((AutoLoadMediaVideo)autoLoadUnit2).refreshMediaVideo(tPMediaVideo);
            }
            return;
        }
    }

    public void loadAdStart(String string) {
        if (string != null && string.length() > 0) {
            AutoLoadUnit autoLoadUnit = ((AutoLoadManager)((Object)autoLoadUnit)).mAutoLoadUnits.get(string);
            if (autoLoadUnit != null && autoLoadUnit.isAutoLoad()) {
                autoLoadUnit.loadAdStart();
                return;
            }
            return;
        }
    }

    public void loadAdLoaded(String string) {
        if (string != null && string.length() > 0) {
            AutoLoadUnit autoLoadUnit = ((AutoLoadManager)((Object)autoLoadUnit)).mAutoLoadUnits.get(string);
            if (autoLoadUnit == null) {
                return;
            }
            autoLoadUnit.loadAdLoaded();
            return;
        }
    }

    public void loadAdNoConnect(String string, String string2) {
        if (string != null && string.length() > 0 && string2.equals("7")) {
            AutoLoadUnit autoLoadUnit = ((AutoLoadManager)((Object)autoLoadUnit)).mAutoLoadUnits.get(string);
            if (autoLoadUnit == null) {
                return;
            }
            autoLoadUnit.setNeedChangeNetworkAutoLoad(true);
            return;
        }
    }

    public void isReadyFailed(String string, int n2) {
        if (string != null && string.length() > 0) {
            AutoLoadUnit autoLoadUnit = this.mAutoLoadUnits.get(string);
            this.setServerAutoLoad(autoLoadUnit, string);
            if (autoLoadUnit != null && autoLoadUnit.isAutoLoad()) {
                autoLoadUnit.isReadyFailed(n2);
                return;
            }
            return;
        }
    }

    public void adClose(final String string) {
        Runnable runnable;
        Handler handler = TPTaskManager.getInstance().getAutoThreadHandler();
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                AutoLoadManager.this.autuLoadClose(string);
            }
        };
        long l2 = this.isOpenDelayLoadAds ? 2000L : 0L;
        handler.postDelayed(runnable2, l2);
    }

    public void loadAdFailed(String string) {
        if (string != null && string.length() > 0) {
            AutoLoadUnit autoLoadUnit = this.mAutoLoadUnits.get(string);
            this.setServerAutoLoad(autoLoadUnit, string);
            if (autoLoadUnit == null) {
                return;
            }
            autoLoadUnit.loadAdFailed();
            return;
        }
    }

    public void timeToLoadAd() {
        Iterator<Map.Entry<String, AutoLoadUnit>> iterator = ((AutoLoadManager)((Object)iterator)).mAutoLoadUnits.entrySet().iterator();
        while (iterator.hasNext()) {
            ((AutoLoadUnit)((Map.Entry)iterator.next()).getValue()).checkAdExpired();
        }
    }

    public boolean checkReloadAdExpired(String string, int n2) {
        LogUtil.ownShow((String)("checkReloadAdExpired reload type = " + n2));
        AutoLoadUnit autoLoadUnit = ((AutoLoadManager)((Object)autoLoadUnit)).mAutoLoadUnits.get(string);
        if (autoLoadUnit != null) {
            return autoLoadUnit.checkReloadAdExpired(n2);
        }
        return false;
    }

    public void removeAutoLoadRunnable() {
        TPTaskManager.getInstance().getAutoThreadHandler().removeCallbacks(this.autoLoadRunnable);
    }

    public void startAutoLoadRunnable() {
        TPTaskManager.getInstance().getAutoThreadHandler().removeCallbacks(this.autoLoadRunnable);
        TPTaskManager.getInstance().getAutoThreadHandler().postDelayed(this.autoLoadRunnable, 300000L);
    }

    public boolean isOpenDelayLoadAds() {
        return this.isOpenDelayLoadAds;
    }

    public void setOpenDelayLoadAds(boolean bl) {
        this.isOpenDelayLoadAds = bl;
    }
}

