/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.mgr.autoload;

import android.os.Handler;
import android.os.SystemClock;
import com.tradplus.ads.base.common.TPDataManager;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.config.ConfigLoadManager;
import com.tradplus.ads.base.filter.NetWorkFrequencyUtils;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.common.util.CustomLogUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.core.AdCacheManager;
import com.tradplus.ads.core.AutoUnitCFManager;
import com.tradplus.ads.core.track.LoadLifecycleCallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AutoLoadUnit {
    private static final int[] defaultRefreshTimeRelease = new int[]{15, 30, 60, 90, 120, 120};
    private final CopyOnWriteArrayList<Integer> refreshTimeRelease;
    private final long minLoadIntervalTime;
    private boolean needChangeNetworkAutoLoad;
    private String adUnitId;
    private long lastLoadTime;
    private long lastLoadedTime;
    private final AtomicInteger loadErrorNum;
    private boolean isAutoLoad;
    private boolean isCf;
    private final long defaultReloadRunnableTime;
    private Runnable autoreLoadRunnable;
    private Runnable loadFailedDelay;

    public AutoLoadUnit(String object, boolean n2) {
        Runnable runnable;
        AtomicInteger atomicInteger;
        CopyOnWriteArrayList copyOnWriteArrayList;
        Object object2 = copyOnWriteArrayList;
        copyOnWriteArrayList = new CopyOnWriteArrayList();
        this.refreshTimeRelease = object2;
        this.minLoadIntervalTime = 5000L;
        object2 = atomicInteger;
        atomicInteger = new AtomicInteger(0);
        this.loadErrorNum = object2;
        this.isCf = false;
        this.defaultReloadRunnableTime = 300000L;
        object2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                AutoLoadUnit autoLoadUnit = AutoLoadUnit.this;
                autoLoadUnit.timeToLoadAd(autoLoadUnit.loadErrorNum.get() + 500);
            }
        };
        this.loadFailedDelay = object2;
        this.adUnitId = object;
        this.isAutoLoad = n2;
        object = defaultRefreshTimeRelease;
        n2 = defaultRefreshTimeRelease.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object3 = object[i2];
            this.refreshTimeRelease.add((int)object3);
        }
    }

    private void sendReloadEventByType(boolean bl, int n2, ConfigResponse configResponse) {
        block7: {
            LoadLifecycleCallback loadLifecycleCallback;
            LoadLifecycleCallback loadLifecycleCallback2 = loadLifecycleCallback;
            loadLifecycleCallback = new LoadLifecycleCallback(((AutoLoadUnit)object).adUnitId, null);
            switch (n2) {
                default: {
                    break block7;
                }
                case 9: {
                    Object object;
                    if (bl) {
                        object = "101";
                        break;
                    }
                    object = "100";
                    break;
                }
                case 8: {
                    Object object;
                    if (bl) {
                        object = "201";
                        break;
                    }
                    object = "200";
                    break;
                }
                case 7: {
                    Object object = bl ? "301" : "300";
                }
            }
            loadLifecycleCallback2.reloadEvent((String)object, configResponse);
        }
    }

    private boolean isRefreshTimeReleaseEqual(List<Integer> list) {
        if (list != null && !list.isEmpty()) {
            if (list.size() != this.refreshTimeRelease.size()) {
                return false;
            }
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Integer n2 = list.get(i2);
                Integer n3 = this.refreshTimeRelease.get(i2);
                if (n2 == null && n3 == null) continue;
                if (n2 != null && n3 != null) {
                    if (n2.equals(n3)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return this.refreshTimeRelease.isEmpty();
    }

    private boolean checkAdShareUnitFrenquency() {
        if (!NetWorkFrequencyUtils.getInstance().checkAdShareUnitFrenquency(this.adUnitId)) {
            LogUtil.ownShow((String)("AdShareManager checkAdShareUnitFrenquency SystemClock.elapsedRealtime() == " + SystemClock.elapsedRealtime()));
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.LOAD_NETWORK_SHAREUNITIDLIMIT);
            this.sendLoadEvent();
            return true;
        }
        return false;
    }

    private void sendLoadEvent() {
        ConfigResponse configResponse = ConfigLoadManager.getInstance().getLocalConfigResponse(this.adUnitId);
        LoadLifecycleCallback loadLifecycleCallback = new LoadLifecycleCallback(this.adUnitId, null);
        loadLifecycleCallback.loadStart(4, configResponse);
        loadLifecycleCallback.loadEnd("30", 4, configResponse);
    }

    public void autoLoadStart() {
        if (!this.isAutoLoad) {
            return;
        }
        CustomLogUtils.TradPlusLog tradPlusLog = CustomLogUtils.TradPlusLog.OPEN_AUTOLOAD;
        CustomLogUtils.getInstance().log(tradPlusLog, this.adUnitId);
        ConfigLoadManager.getInstance().loadConfig(this.adUnitId, new ConfigLoadManager.ConfigLoadListener(){

            public void onSuccess(ConfigResponse configResponse) {
                if (configResponse == null) {
                    AutoLoadUnit.this.loadAdFailed();
                    return;
                }
                a a2 = this;
                a2.AutoLoadUnit.this.saveServerConfigResponse(configResponse);
                AutoUnitCFManager.getInstance().putCf(AutoLoadUnit.this.adUnitId, AutoLoadUnit.this.isCf);
                a2.AutoLoadUnit.this.timeToLoadAd(1);
            }

            public void onFailed(int n2, String string) {
                AutoLoadUnit.this.loadAdFailed();
            }
        });
    }

    public void loadAdStart() {
        this.lastLoadTime = System.currentTimeMillis();
    }

    public void loadAdLoaded() {
        AutoLoadUnit autoLoadUnit = this;
        autoLoadUnit.startAutoReloadRunnable();
        autoLoadUnit.lastLoadedTime = System.currentTimeMillis();
        LogUtil.ownShow((String)("checkReloadAdExpired reload lastLoadedTime = " + this.lastLoadedTime));
        autoLoadUnit.loadErrorNum.set(0);
    }

    public void isReadyFailed(int n2) {
        CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.AUTOLOAD_ISRADEYFALSE, ":" + this.adUnitId);
        this.timeToLoadAd(n2);
    }

    public void adClose() {
        block3: {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.AUTOLOAD_ADCLOSED, ":" + this.adUnitId);
            if (this.checkAdShareUnitFrenquency()) {
                return;
            }
            try {
                this.loadAd(4);
            }
            catch (Exception exception) {
                if (!TPDataManager.getInstance().isDebugMode()) break block3;
                exception.printStackTrace();
            }
        }
    }

    public void loadAdFailed() {
        AutoLoadUnit autoLoadUnit = this;
        autoLoadUnit.startAutoReloadRunnable();
        autoLoadUnit.lastLoadedTime = System.currentTimeMillis();
        LogUtil.ownShow((String)("loadAdFailed checkReloadAdExpired reload lastLoadedTime = " + this.lastLoadedTime));
        if (!autoLoadUnit.isAutoLoad) {
            return;
        }
        AutoLoadUnit autoLoadUnit2 = this;
        int n2 = autoLoadUnit2.loadErrorNum.get();
        int n3 = autoLoadUnit2.refreshTimeRelease.size();
        if (!autoLoadUnit2.refreshTimeRelease.isEmpty() && n2 < n3) {
            Integer n4;
            block10: {
                n4 = this.refreshTimeRelease.get(n2);
                if (n4 != null) break block10;
                return;
            }
            AutoLoadUnit autoLoadUnit3 = this;
            int n5 = n4 * 1000;
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.AUTOLOAD_ALLFAILED, " " + this.adUnitId + " failed num:" + n2 + " delay time:" + n5);
            Handler handler = TPTaskManager.getInstance().getAutoThreadHandler();
            Runnable runnable = this.loadFailedDelay;
            long l2 = n5;
            handler.postDelayed(runnable, l2);
            autoLoadUnit3.loadErrorNum.incrementAndGet();
            try {
                LogUtil.ownShow((String)("loadAdFailed incrementAndGet:" + this.loadErrorNum.get()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                LogUtil.ownShow((String)("loadAdFailed IndexOutOfBoundsException, reset loadErrorNum to 0, currentErrorNum:" + n2));
                this.loadErrorNum.set(0);
                indexOutOfBoundsException.printStackTrace();
            }
            return;
        }
        CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.AUTOLOAD_ALLFAILED, " " + this.adUnitId + " don't load, but reset num to 0, max num:" + n2);
        this.loadErrorNum.set(0);
    }

    public void timeToLoadAd(int n2) {
        block5: {
            long l2 = Math.abs(System.currentTimeMillis() - this.lastLoadTime);
            if (l2 < 5000L) {
                LogUtil.ownShow((String)(this.adUnitId + " timeToLoadAd intervalTime:" + l2));
                return;
            }
            if (this.checkAdShareUnitFrenquency()) {
                return;
            }
            AutoLoadUnit autoLoadUnit = this;
            int n3 = n2;
            try {
                LogUtil.ownShow((String)(this.adUnitId + " timeToLoadAd loadAd:" + n2));
                autoLoadUnit.loadAd(n3);
            }
            catch (Exception exception) {
                if (!TPDataManager.getInstance().isDebugMode()) break block5;
                exception.printStackTrace();
            }
        }
    }

    public void checkAdExpired() {
        if (AdCacheManager.getInstance().checkAdCacheTimeout(this.adUnitId)) {
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.AUTOLOAD_CHECK_EXPIRED, ":" + this.adUnitId);
            this.timeToLoadAd(12);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean checkReloadAdExpired(int n2) {
        ConfigResponse configResponse;
        boolean bl;
        block12: {
            block13: {
                bl = false;
                configResponse = ConfigLoadManager.getInstance().getLocalConfigResponse(this.adUnitId);
                if (configResponse == null) {
                    this.sendReloadEventByType(false, n2, null);
                    return false;
                }
                ConfigResponse.ReloadBean reloadBean = configResponse.getReload_config();
                if (reloadBean == null) {
                    this.sendReloadEventByType(false, n2, configResponse);
                    return false;
                }
                if (Math.abs(System.currentTimeMillis() - this.lastLoadedTime) < (long)reloadBean.getLast_reload_interval() * 1000L) {
                    this.sendReloadEventByType(false, n2, configResponse);
                    return false;
                }
                switch (n2) {
                    default: {
                        break block12;
                    }
                    case 9: {
                        bl = reloadBean.getAdscene_reload() == 1;
                        if (bl) {
                            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.RELOAD_INTO_SCENE);
                        }
                        break block12;
                    }
                    case 8: {
                        if (reloadBean.getAuto_reload() == 1) {
                            break;
                        }
                        break block13;
                    }
                    case 7: {
                        if (reloadBean.getManual_reload() != 1) break block13;
                    }
                }
                bl = true;
                break block12;
            }
            bl = false;
        }
        this.sendReloadEventByType(bl, n2, configResponse);
        if (bl) {
            if (this.checkAdShareUnitFrenquency()) {
                return bl;
            }
            this.loadAd(n2);
        }
        return bl;
    }

    public synchronized void saveServerConfigResponse(ConfigResponse object) {
        if ((object = object.getAdunit_autoload_retry_config()) != null && !object.isEmpty()) {
            ArrayList arrayList;
            TreeMap treeMap;
            Object object2 = object;
            object = treeMap;
            treeMap = new TreeMap();
            Iterator<Object> iterator = object2.iterator();
            while (iterator.hasNext()) {
                ConfigResponse.AdunitAutoloadRetryInfoBean adunitAutoloadRetryInfoBean = (ConfigResponse.AdunitAutoloadRetryInfoBean)iterator.next();
                if (adunitAutoloadRetryInfoBean.getTimes() <= 0) continue;
                ((TreeMap)object).put(adunitAutoloadRetryInfoBean.getTimes(), adunitAutoloadRetryInfoBean);
            }
            Object object3 = object;
            object = arrayList;
            arrayList = new ArrayList();
            iterator = ((TreeMap)object3).entrySet().iterator();
            while (iterator.hasNext()) {
                ((ArrayList)object).add(((ConfigResponse.AdunitAutoloadRetryInfoBean)((Map.Entry)iterator.next()).getValue()).getSecond());
            }
            if (!((ArrayList)object).isEmpty()) {
                if (this.isRefreshTimeReleaseEqual((List<Integer>)object)) {
                    this.isCf = true;
                    return;
                }
                AutoLoadUnit autoLoadUnit = this;
                autoLoadUnit.refreshTimeRelease.clear();
                autoLoadUnit.refreshTimeRelease.addAll((Collection<Integer>)object);
                autoLoadUnit.loadErrorNum.set(0);
                autoLoadUnit.isCf = true;
            }
        }
    }

    public void startAutoReloadRunnable() {
        if (this.autoreLoadRunnable == null) {
            this.autoreLoadRunnable = this.createAutoReloadRunnable();
        }
        LogUtil.ownShow((String)"startAutoReloadRunnable reload = ");
        TPTaskManager.getInstance().getAutoThreadHandler().removeCallbacks(this.autoreLoadRunnable);
        ConfigResponse configResponse = ConfigLoadManager.getInstance().getLocalConfigResponse(this.adUnitId);
        if (configResponse != null && (configResponse = configResponse.getReload_config()) != null && configResponse.getAuto_reload() == 1) {
            long l2 = configResponse.getAuto_check_interval() * 1000;
            if (l2 <= 0L) {
                l2 = 300000L;
            }
            TPTaskManager.getInstance().getAutoThreadHandler().postDelayed(this.autoreLoadRunnable, l2);
        }
    }

    public Runnable createAutoReloadRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.AUTORELOAD_BEGIN);
                        AutoLoadUnit.this.checkReloadAdExpired(8);
                    }
                    catch (Exception exception) {
                        if (!TPDataManager.getInstance().isDebugMode()) break block2;
                        exception.printStackTrace();
                    }
                }
                AutoLoadUnit.this.startAutoReloadRunnable();
            }
        };
    }

    public boolean isAutoLoad() {
        return this.isAutoLoad;
    }

    public void setAutoLoad(boolean bl) {
        this.isAutoLoad = bl;
    }

    public abstract void loadAd(int var1);

    public boolean isNeedChangeNetworkAutoLoad() {
        return this.needChangeNetworkAutoLoad;
    }

    public void setNeedChangeNetworkAutoLoad(boolean bl) {
        this.needChangeNetworkAutoLoad = bl;
    }

    public boolean isCf() {
        return this.isCf;
    }

    public int getErrorCode() {
        return this.loadErrorNum.get() + 500;
    }
}

