/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.mgr.interactive;

import android.content.Context;
import android.os.Handler;
import android.view.View;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.adapter.TPShowAdapterListener;
import com.tradplus.ads.base.adapter.interactive.TPInterActiveAdapter;
import com.tradplus.ads.base.bean.TPAdError;
import com.tradplus.ads.base.bean.TPAdInfo;
import com.tradplus.ads.base.common.IntervalLock;
import com.tradplus.ads.base.common.TPAdInfoUtils;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.config.ConfigLoadManager;
import com.tradplus.ads.base.filter.FrequencyUtils;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.common.util.CustomLogUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.core.AdCacheManager;
import com.tradplus.ads.core.AdCustomCacheManager;
import com.tradplus.ads.core.AdMediationManager;
import com.tradplus.ads.core.GlobalImpressionManager;
import com.tradplus.ads.core.cache.AdCache;
import com.tradplus.ads.core.track.LoadAdListener;
import com.tradplus.ads.core.track.LoadLifecycleCallback;
import com.tradplus.ads.core.track.ShowAdListener;
import com.tradplus.ads.mgr.autoload.AutoLoadManager;
import com.tradplus.ads.open.DownloadListener;
import com.tradplus.ads.open.LoadAdEveryLayerListener;
import com.tradplus.ads.open.interactive.InterActiveAdListener;
import java.util.Map;

public class InterActiveMgr {
    private InterActiveAdListener mAdListener;
    private IntervalLock mIsReadyLock;
    private boolean lastReadyStatus;
    private View interActiveAdView;
    private String mAdUnitId;
    private Map<String, Object> customShowData;
    private DownloadListener downloadListener;
    private LoadAdEveryLayerListener mEveryLayerListener;
    private String mAdSceneId;
    private boolean hasCallBackToDeveloper = false;
    private boolean needManualLoaded;
    private boolean isAutoLoadCallback = false;
    private TPInterActiveAdapter tpInterActiveAdapter;
    private LoadAdListener mLoadAdListener = new LoadAdListener(){

        public void onAdLoaded(AdCache adCache) {
            InterActiveMgr.this.onLoaded(adCache);
        }

        public void onAdLoadFailed(final String string) {
            if (!InterActiveMgr.this.hasCallBackToDeveloper) {
                c c2 = this;
                InterActiveMgr.access$402(c2.InterActiveMgr.this, true);
                AdMediationManager adMediationManager = AdMediationManager.getInstance((String)c2.InterActiveMgr.this.mAdUnitId);
                adMediationManager.setLoading(false);
                adMediationManager.setAllLoadFail();
                TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        LogUtil.ownShow((String)"InterstitialMgr onAdLoadFailed set loading false");
                        LogUtil.ownShow((String)"InterstitialMgr onAdLoadFailed set allLoadFail false");
                        LogUtil.ownShow((String)"InterstitialMgr onAdLoadFailed set hasCallBackToDeveloper true");
                        d d2 = this;
                        String string2 = d2.InterActiveMgr.this.mAdUnitId;
                        AutoLoadManager.getInstance().loadAdNoConnect(string2, d2.string);
                        if (InterActiveMgr.this.mAdListener != null && InterActiveMgr.this.canCallbackLoadedOrFailed()) {
                            InterActiveMgr.this.mAdListener.onAdFailed(new TPAdError(string));
                        }
                    }
                });
            }
        }

        public void onAdClicked(final TPBaseAdapter tPBaseAdapter) {
            if (InterActiveMgr.this.mAdListener == null) {
                return;
            }
            TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    if (InterActiveMgr.this.mAdListener != null) {
                        InterActiveMgr.this.mAdListener.onAdClicked(TPAdInfoUtils.getTPAdInfo((String)InterActiveMgr.this.mAdUnitId, (TPBaseAdapter)tPBaseAdapter));
                    }
                }
            });
        }

        public void onAdClosed(final TPBaseAdapter tPBaseAdapter) {
            if (InterActiveMgr.this.mAdListener == null) {
                return;
            }
            TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    if (InterActiveMgr.this.mAdListener != null) {
                        InterActiveMgr.this.mAdListener.onAdClosed(TPAdInfoUtils.getTPAdInfo((String)InterActiveMgr.this.mAdUnitId, (TPBaseAdapter)tPBaseAdapter));
                    }
                    AutoLoadManager.getInstance().adClose(InterActiveMgr.this.mAdUnitId);
                }
            });
        }

        public void onAdShow(TPBaseAdapter tPBaseAdapter) {
            tPBaseAdapter = TPAdInfoUtils.getTPAdInfo((String)InterActiveMgr.this.mAdUnitId, (TPBaseAdapter)tPBaseAdapter);
            TPTaskManager.getInstance().runOnMainThread(new Runnable(){
                final /* synthetic */ TPAdInfo a;
                {
                    this.a = tPAdInfo;
                }

                @Override
                public void run() {
                    GlobalImpressionManager.getInstance().onAdImpression(this.a);
                    if (InterActiveMgr.this.mAdListener != null) {
                        InterActiveMgr.this.mAdListener.onAdImpression(this.a);
                    }
                }
            });
        }

        protected void onAdVideoStart(final TPBaseAdapter tPBaseAdapter) {
            TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    if (InterActiveMgr.this.mAdListener != null) {
                        InterActiveMgr.this.mAdListener.onAdVideoStart(TPAdInfoUtils.getTPAdInfo((String)InterActiveMgr.this.mAdUnitId, (TPBaseAdapter)tPBaseAdapter));
                    }
                }
            });
        }

        protected void onAdVideoEnd(final TPBaseAdapter tPBaseAdapter) {
            TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    if (InterActiveMgr.this.mAdListener != null) {
                        InterActiveMgr.this.mAdListener.onAdVideoEnd(TPAdInfoUtils.getTPAdInfo((String)InterActiveMgr.this.mAdUnitId, (TPBaseAdapter)tPBaseAdapter));
                    }
                }
            });
        }

        protected void onAdAllLoaded(final boolean bl, boolean bl2) {
            if (InterActiveMgr.this.mEveryLayerListener == null) {
                return;
            }
            TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    if (InterActiveMgr.this.mEveryLayerListener != null) {
                        InterActiveMgr.this.mEveryLayerListener.onAdAllLoaded(bl);
                    }
                }
            });
        }

        protected void oneLayerLoadFailed(final String string, final TPBaseAdapter tPBaseAdapter, final String string2) {
            if (InterActiveMgr.this.mEveryLayerListener == null) {
                return;
            }
            TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    if (InterActiveMgr.this.mEveryLayerListener != null) {
                        k k2 = this;
                        String string3 = k2.string;
                        InterActiveMgr.this.mEveryLayerListener.oneLayerLoadFailed(new TPAdError(string3, k2.string2), TPAdInfoUtils.getTPAdInfo((String)InterActiveMgr.this.mAdUnitId, (TPBaseAdapter)tPBaseAdapter));
                    }
                }
            });
        }

        protected void oneLayerLoaded(final AdCache adCache) {
            if (InterActiveMgr.this.mEveryLayerListener == null) {
                return;
            }
            TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    if (InterActiveMgr.this.mEveryLayerListener != null) {
                        Object object = adCache;
                        object = object == null ? null : object.getAdapter();
                        InterActiveMgr.this.mEveryLayerListener.oneLayerLoaded(TPAdInfoUtils.getTPAdInfo((String)InterActiveMgr.this.mAdUnitId, (TPBaseAdapter)object));
                    }
                }
            });
        }

        protected void oneLayerLoadStart(final TPBaseAdapter tPBaseAdapter) {
            if (InterActiveMgr.this.mEveryLayerListener == null) {
                return;
            }
            TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    if (InterActiveMgr.this.mEveryLayerListener != null) {
                        InterActiveMgr.this.mEveryLayerListener.oneLayerLoadStart(TPAdInfoUtils.getTPAdInfo((String)InterActiveMgr.this.mAdUnitId, (TPBaseAdapter)tPBaseAdapter));
                    }
                }
            });
        }

        protected void onAdStartLoad() {
            if (InterActiveMgr.this.mEveryLayerListener == null) {
                return;
            }
            TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    if (InterActiveMgr.this.mEveryLayerListener != null) {
                        InterActiveMgr.this.mEveryLayerListener.onAdStartLoad(InterActiveMgr.this.mAdUnitId);
                    }
                }
            });
        }

        protected void onAdVideoError(final String string, final TPBaseAdapter tPBaseAdapter, final String string2) {
            if (InterActiveMgr.this.mAdListener == null) {
                return;
            }
            TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    if (string3.InterActiveMgr.this.mAdListener != null) {
                        c c2 = string3;
                        String string3 = c2.string;
                        string3.InterActiveMgr.this.mAdListener.onAdVideoError(TPAdInfoUtils.getTPAdInfo((String)string3.InterActiveMgr.this.mAdUnitId, (TPBaseAdapter)string3.tPBaseAdapter), new TPAdError(string3, c2.string2));
                    }
                }
            });
        }
    };
    private final InterActiveAdListener interActiveAdListener = new InterActiveAdListener(){

        @Override
        public void onAdLoaded(TPAdInfo tPAdInfo) {
        }

        @Override
        public void onAdClicked(TPAdInfo tPAdInfo) {
        }

        @Override
        public void onAdImpression(TPAdInfo tPAdInfo) {
        }

        @Override
        public void onAdFailed(TPAdError tPAdError) {
        }

        @Override
        public void onAdClosed(TPAdInfo tPAdInfo) {
        }

        @Override
        public void onAdVideoError(TPAdInfo tPAdInfo, TPAdError tPAdError) {
        }

        @Override
        public void onAdVideoStart(TPAdInfo tPAdInfo) {
        }

        @Override
        public void onAdVideoEnd(TPAdInfo tPAdInfo) {
        }
    };

    public InterActiveMgr(Context context, String string) {
        GlobalTradPlus.getInstance().refreshContext(context);
        this.mIsReadyLock = new IntervalLock(1000L);
        this.mAdUnitId = string;
    }

    private void checkAutoLoadCallback(int n2) {
        this.needManualLoaded = !this.isAutoLoadCallback && 6 == n2;
    }

    private boolean canCallbackLoadedOrFailed() {
        return this.isAutoLoadCallback || this.needManualLoaded;
    }

    private void startMaxLoadTimeThread(float f2) {
        if (!this.needManualLoaded) {
            return;
        }
        TPTaskManager.getInstance().getRefreshThreadHandler().post(() -> {
            Runnable runnable;
            ConfigResponse configResponse;
            long l2;
            long l3 = 0L;
            if (f2 > 0.1f) {
                f2 -= 0.1f;
            }
            if ((l2 = new Float(f2 * 1000.0f).longValue()) <= 0L && (configResponse = ConfigLoadManager.getInstance().getMemoryConfigResponse(this.mAdUnitId)) != null) {
                float f3 = configResponse.getLoadMaxWaitTime() > 0.1f ? configResponse.getLoadMaxWaitTime() - 0.1f : configResponse.getLoadMaxWaitTime();
                l3 = new Float(f3 * 1000.0f).longValue();
            }
            if (l2 <= 0L && l3 <= 0L) {
                return;
            }
            Handler handler = TPTaskManager.getInstance().getRefreshThreadHandler();
            Runnable runnable2 = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    a a2 = a3;
                    a a3 = AdCacheManager.getInstance().getReadyAd(a3.InterActiveMgr.this.mAdUnitId);
                    a2.InterActiveMgr.this.onLoaded((AdCache)a3);
                }
            };
            if (l2 <= 0L) {
                l2 = l3;
            }
            handler.postDelayed(runnable2, l2);
        });
    }

    private LoadLifecycleCallback checkAndGetCallback(AdCache adCache) {
        if (adCache != null && adCache.getCallback() != null) {
            AdCache adCache2 = adCache;
            adCache2.getCallback().refreshListener(((InterActiveMgr)((Object)string)).mLoadAdListener);
            return adCache2.getCallback();
        }
        InterActiveMgr interActiveMgr = string;
        String string = interActiveMgr.mAdUnitId;
        return new LoadLifecycleCallback(string, interActiveMgr.mLoadAdListener);
    }

    private void onLoaded(final AdCache adCache) {
        if (adCache == null) {
            return;
        }
        if (!this.hasCallBackToDeveloper) {
            AdCustomCacheManager.getInstance().addCustomCacheLoadedTs(this.mAdUnitId);
            AdMediationManager adMediationManager = AdMediationManager.getInstance((String)this.mAdUnitId);
            adMediationManager.setLoading(false);
            adMediationManager.setLoadSuccess(true);
            TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    LogUtil.ownShow((String)"InterstitialMgr onAdLoaded set loading false");
                    LogUtil.ownShow((String)"InterstitialMgr onAdLoaded set loadSuccessButNotShow true");
                    AutoLoadManager.getInstance().loadAdLoaded(InterActiveMgr.this.mAdUnitId);
                    if (InterActiveMgr.this.mAdListener != null && InterActiveMgr.this.canCallbackLoadedOrFailed()) {
                        Object object = adCache;
                        object = object == null ? null : object.getAdapter();
                        if (object != null) {
                            InterActiveMgr.access$302(InterActiveMgr.this, (TPInterActiveAdapter)object);
                        }
                        InterActiveMgr.this.mAdListener.onAdLoaded(TPAdInfoUtils.getTPAdInfo((String)InterActiveMgr.this.mAdUnitId, (TPBaseAdapter)object));
                    }
                    b b2 = this;
                    InterActiveMgr.access$402(b2.InterActiveMgr.this, true);
                    LogUtil.ownShow((String)"InterstitialMgr onAdLoaded set 1s expired");
                    b2.InterActiveMgr.this.mIsReadyLock.setExpireSecond(0L);
                }
            });
        }
    }

    static /* synthetic */ TPInterActiveAdapter access$302(InterActiveMgr interActiveMgr, TPInterActiveAdapter tPInterActiveAdapter) {
        interActiveMgr.tpInterActiveAdapter = tPInterActiveAdapter;
        return tPInterActiveAdapter;
    }

    static /* synthetic */ boolean access$402(InterActiveMgr interActiveMgr, boolean bl) {
        interActiveMgr.hasCallBackToDeveloper = bl;
        return bl;
    }

    public void setCustomShowData(Map<String, Object> map) {
        this.customShowData = map;
    }

    public void setDownloadListener(DownloadListener downloadListener) {
        this.downloadListener = downloadListener;
    }

    public void setAdListener(InterActiveAdListener interActiveAdListener) {
        this.mAdListener = interActiveAdListener;
    }

    public void setAllAdLoadListener(LoadAdEveryLayerListener loadAdEveryLayerListener) {
        this.mEveryLayerListener = loadAdEveryLayerListener;
    }

    public void loadAd(InterActiveAdListener interActiveAdListener, int n2, float f2) {
        String string = this.mAdUnitId;
        if (string != null && string.length() > 0) {
            this.mAdUnitId = this.mAdUnitId.trim();
            if (interActiveAdListener == null) {
                interActiveAdListener = this.interActiveAdListener;
            }
            InterActiveMgr interActiveMgr = this;
            interActiveMgr.mAdListener = interActiveAdListener;
            interActiveMgr.checkAutoLoadCallback(n2);
            interActiveMgr.startMaxLoadTimeThread(f2);
            interActiveMgr.loadAd(n2);
            return;
        }
        CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.LOAD_FAILED_NULL_UNITID);
    }

    public void loadAd(int n2) {
        LoadLifecycleCallback loadLifecycleCallback;
        Object object;
        InterActiveMgr interActiveMgr = object;
        interActiveMgr.checkAutoLoadCallback(n2);
        AdMediationManager adMediationManager = AdMediationManager.getInstance((String)interActiveMgr.mAdUnitId);
        if (adMediationManager.checkIsLoading()) {
            LoadAdEveryLayerListener loadAdEveryLayerListener = ((InterActiveMgr)object).mEveryLayerListener;
            if (loadAdEveryLayerListener != null) {
                loadAdEveryLayerListener.onAdIsLoading(((InterActiveMgr)object).mAdUnitId);
            }
            if ((loadAdEveryLayerListener = adMediationManager.getLoadCallback()) != null) {
                loadAdEveryLayerListener.refreshListener(((InterActiveMgr)object).mLoadAdListener);
            }
            InterActiveMgr interActiveMgr2 = object;
            object = CustomLogUtils.TradPlusLog.LOAD_LOADING_ADS;
            CustomLogUtils.getInstance().log((CustomLogUtils.TradPlusLog)object, interActiveMgr2.mAdUnitId);
            return;
        }
        AdMediationManager adMediationManager2 = adMediationManager;
        ((InterActiveMgr)object).hasCallBackToDeveloper = false;
        adMediationManager2.setLoading(true);
        adMediationManager = loadLifecycleCallback;
        InterActiveMgr interActiveMgr3 = object;
        object = interActiveMgr3.mAdUnitId;
        loadLifecycleCallback = new LoadLifecycleCallback((String)object, interActiveMgr3.mLoadAdListener);
        adMediationManager2.loadAd((LoadLifecycleCallback)adMediationManager, n2);
    }

    public void setAutoLoadCallback(boolean bl) {
        this.isAutoLoadCallback = bl;
    }

    public View getInterActiveAd() {
        AdCache adCache = AdCacheManager.getInstance().getReadyAd(this.mAdUnitId);
        if (adCache == null) {
            return this.interActiveAdView;
        }
        if (adCache.getAdapter() != null && (adCache = (TPInterActiveAdapter)adCache.getAdapter()) != null) {
            this.interActiveAdView = adCache.getInterActiveView();
        }
        return this.interActiveAdView;
    }

    public void showAd(String string) {
        ShowAdListener showAdListener;
        if (!FrequencyUtils.getInstance().needShowAd(this.mAdUnitId)) {
            InterActiveMgr interActiveMgr = this;
            String string2 = interActiveMgr.mAdUnitId;
            LoadLifecycleCallback loadLifecycleCallback = new LoadLifecycleCallback(string2, interActiveMgr.mLoadAdListener);
            loadLifecycleCallback.showAdStart(null, string);
            loadLifecycleCallback.showAdEnd(null, string, "4", "frequency limited");
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.SHOW_ACTION, this.mAdUnitId + " frequency limited");
            return;
        }
        AdCache adCache = AdCacheManager.getInstance().getAdCacheToShow(this.mAdUnitId);
        LoadLifecycleCallback loadLifecycleCallback = this.checkAndGetCallback(adCache);
        loadLifecycleCallback.showAdStart(adCache, string);
        if (adCache == null && this.tpInterActiveAdapter == null) {
            loadLifecycleCallback.showAdEnd(null, string, "5", "cache is null");
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.SHOW_ACTION, this.mAdUnitId + ", No Ad Ready \u6ca1\u6709\u53ef\u7528\u5e7f\u544a");
            AutoLoadManager.getInstance().isReadyFailed(this.mAdUnitId, 3);
            return;
        }
        Object object = adCache == null ? this.tpInterActiveAdapter : adCache.getAdapter();
        if (!(object instanceof TPInterActiveAdapter)) {
            loadLifecycleCallback.showAdEnd(adCache, string, "104", "cache is not interactive");
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.SHOW_ACTION, this.mAdUnitId + " cache is not interactive");
            return;
        }
        TPInterActiveAdapter tPInterActiveAdapter = object;
        tPInterActiveAdapter.setCustomShowData(this.customShowData);
        TPInterActiveAdapter tPInterActiveAdapter2 = tPInterActiveAdapter;
        if (!tPInterActiveAdapter.isReady()) {
            loadLifecycleCallback.showAdEnd(adCache, string, "5");
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.SHOW_ACTION, this.mAdUnitId + " not ready");
            AutoLoadManager.getInstance().isReadyFailed(this.mAdUnitId, 3);
            return;
        }
        ShowAdListener showAdListener2 = showAdListener;
        showAdListener = new ShowAdListener(loadLifecycleCallback, (TPBaseAdapter)object, string);
        tPInterActiveAdapter2.setShowListener((TPShowAdapterListener)showAdListener2);
        object = this.interActiveAdView;
        if (object != null) {
            object.setVisibility(0);
        }
        tPInterActiveAdapter2.showAd();
        loadLifecycleCallback.showAdEnd(adCache, string, "1");
        FrequencyUtils.getInstance().addFrequencyShowCount(this.mAdUnitId);
    }

    public void setCustomParams(Map<String, Object> map) {
        if (map != null && map.size() > 0) {
            GlobalTradPlus.getInstance().setUserLoadParam(this.mAdUnitId, map);
        }
    }

    public boolean isReady() {
        if (this.mIsReadyLock.isLocked()) {
            return this.lastReadyStatus;
        }
        InterActiveMgr interActiveMgr = this;
        interActiveMgr.mIsReadyLock.setExpireSecond(1L);
        interActiveMgr.mIsReadyLock.tryLock();
        AdCache adCache = AdCacheManager.getInstance().getReadyAd(this.mAdUnitId);
        this.checkAndGetCallback(adCache).isReady(adCache);
        CustomLogUtils customLogUtils = CustomLogUtils.getInstance();
        CustomLogUtils.TradPlusLog tradPlusLog = CustomLogUtils.TradPlusLog.ISREADY_ACTION;
        StringBuilder stringBuilder = new StringBuilder().append(this.mAdUnitId).append(" ");
        boolean bl = adCache != null;
        customLogUtils.log(tradPlusLog, stringBuilder.append(bl).toString());
        boolean bl2 = adCache != null;
        this.lastReadyStatus = bl2;
        if (adCache != null && !adCache.isBottomWaterfall()) {
            return true;
        }
        AutoLoadManager.getInstance().isReadyFailed(this.mAdUnitId, 2);
        return false;
    }

    public void onDestroy() {
        InterActiveMgr interActiveMgr = this;
        interActiveMgr.mAdListener = null;
        interActiveMgr.mEveryLayerListener = null;
        LogUtil.ownShow((String)("onDestroy:" + this.mAdUnitId));
    }
}

