/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.mgr.mediavideo;

import android.content.Context;
import android.os.Handler;
import android.util.Log;
import android.view.ViewGroup;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.adapter.TPShowAdapterListener;
import com.tradplus.ads.base.adapter.mediavideo.TPMediaVideoAdapter;
import com.tradplus.ads.base.bean.TPAdError;
import com.tradplus.ads.base.bean.TPAdInfo;
import com.tradplus.ads.base.common.IntervalLock;
import com.tradplus.ads.base.common.TPAdInfoUtils;
import com.tradplus.ads.base.common.TPCallbackManager;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.config.ConfigLoadManager;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.common.util.CustomLogUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.core.AdCacheManager;
import com.tradplus.ads.core.AdCustomCacheManager;
import com.tradplus.ads.core.AdMediationManager;
import com.tradplus.ads.core.GlobalImpressionManager;
import com.tradplus.ads.core.cache.AdCache;
import com.tradplus.ads.core.track.LoadAdListener;
import com.tradplus.ads.core.track.LoadLifecycleCallback;
import com.tradplus.ads.core.track.ShowAdListener;
import com.tradplus.ads.mgr.autoload.AutoLoadManager;
import com.tradplus.ads.mgr.mediavideo.TPCustomMediaVideoAd;
import com.tradplus.ads.open.LoadAdEveryLayerListener;
import com.tradplus.ads.open.LoadFailedListener;
import com.tradplus.ads.open.mediavideo.MediaVideoAdListener;
import java.util.Map;

public class MediaVideoMgr {
    private MediaVideoAdListener mAdListener;
    private IntervalLock mIsReadyLock;
    private boolean lastReadyStatus;
    private long startInitUnitIdTime;
    private ViewGroup mAdContainerView;
    private Object mObjectVideo;
    private String mAdUnitId;
    private LoadAdEveryLayerListener mEveryLayerListener;
    private LoadFailedListener mLoadFailedListener;
    private boolean hasCallBackToDeveloper;
    private TPMediaVideoAdapter.OnIMAEventListener onIMAEventListener;
    private boolean needManualLoaded;
    private boolean isAutoLoadCallback;
    private LoadAdListener mLoadAdListener;
    private final MediaVideoAdListener mediaVideoAdListener;

    public MediaVideoMgr(Context context, String string) {
        MediaVideoMgr mediaVideoMgr = this;
        this.hasCallBackToDeveloper = false;
        this.isAutoLoadCallback = false;
        this.mLoadAdListener = new LoadAdListener(){

            protected void onLoadBefor(LoadLifecycleCallback loadLifecycleCallback, TPBaseAdapter tPBaseAdapter) {
                if (tPBaseAdapter instanceof TPMediaVideoAdapter) {
                    if (MediaVideoMgr.this.mAdContainerView != null) {
                        ((TPMediaVideoAdapter)tPBaseAdapter).setAdContainerView(MediaVideoMgr.this.mAdContainerView);
                    }
                    if (MediaVideoMgr.this.onIMAEventListener != null) {
                        ((TPMediaVideoAdapter)tPBaseAdapter).setOnIMAEventListener(MediaVideoMgr.this.onIMAEventListener);
                    }
                    TPMediaVideoAdapter tPMediaVideoAdapter = (TPMediaVideoAdapter)tPBaseAdapter;
                    tPMediaVideoAdapter.setAdVideoPlayer(MediaVideoMgr.this.mObjectVideo);
                    tPMediaVideoAdapter.setShowListener((TPShowAdapterListener)new ShowAdListener(loadLifecycleCallback, tPBaseAdapter, ""));
                }
            }

            public void onAdLoaded(AdCache adCache) {
                MediaVideoMgr.this.onLoaded(adCache);
            }

            public void onAdLoadFailed(final String string) {
                if (!MediaVideoMgr.this.hasCallBackToDeveloper) {
                    c c2 = this;
                    MediaVideoMgr.access$802(c2.MediaVideoMgr.this, true);
                    AdMediationManager adMediationManager = AdMediationManager.getInstance((String)c2.MediaVideoMgr.this.mAdUnitId);
                    adMediationManager.setLoading(false);
                    LogUtil.ownShow((String)"MediaVideoMgr onAdLoadFailed set loading false");
                    LogUtil.ownShow((String)"MediaVideoMgr onAdLoadFailed set allLoadFail false");
                    LogUtil.ownShow((String)"MediaVideoMgr onAdLoadFailed set hasCallBackToDeveloper true");
                    adMediationManager.setAllLoadFail();
                    TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            TPAdError tPAdError;
                            g g2 = this;
                            String string2 = g2.MediaVideoMgr.this.mAdUnitId;
                            AutoLoadManager.getInstance().loadAdNoConnect(string2, g2.string);
                            string2 = tPAdError;
                            tPAdError = new TPAdError(string);
                            if (MediaVideoMgr.this.mAdListener != null && MediaVideoMgr.this.canCallbackLoadedOrFailed()) {
                                MediaVideoMgr.this.mAdListener.onAdFailed((TPAdError)string2);
                            }
                            if (MediaVideoMgr.this.mLoadFailedListener != null) {
                                MediaVideoMgr.this.mLoadFailedListener.onAdLoadFailed((TPAdError)string2, MediaVideoMgr.this.mAdUnitId);
                            }
                        }
                    });
                }
            }

            public void onAdClicked(final TPBaseAdapter tPBaseAdapter) {
                if (MediaVideoMgr.this.mAdListener == null) {
                    return;
                }
                TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        h h2 = this;
                        TPAdInfo tPAdInfo = TPAdInfoUtils.getTPAdInfo((String)h2.MediaVideoMgr.this.mAdUnitId, (TPBaseAdapter)tPBaseAdapter);
                        if (h2.MediaVideoMgr.this.mAdListener != null) {
                            MediaVideoMgr.this.mAdListener.onAdClicked(tPAdInfo);
                        }
                    }
                });
            }

            protected void onAdVideoStart(TPBaseAdapter tPBaseAdapter) {
                c c2 = this;
                final TPAdInfo tPAdInfo = TPAdInfoUtils.getTPAdInfo((String)c2.MediaVideoMgr.this.mAdUnitId, (TPBaseAdapter)tPBaseAdapter);
                c2.MediaVideoMgr.this.startCallBack(tPBaseAdapter, tPAdInfo, 1);
                TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        GlobalImpressionManager.getInstance().onAdImpression(tPAdInfo);
                        if (MediaVideoMgr.this.mAdListener != null) {
                            MediaVideoMgr.this.mAdListener.onAdVideoStart(tPAdInfo);
                        }
                    }
                });
            }

            protected void onAdVideoEnd(TPBaseAdapter tPBaseAdapter) {
                tPBaseAdapter = TPAdInfoUtils.getTPAdInfo((String)MediaVideoMgr.this.mAdUnitId, (TPBaseAdapter)tPBaseAdapter);
                TPTaskManager.getInstance().runOnMainThread(new Runnable(){
                    final /* synthetic */ TPAdInfo a;
                    {
                        this.a = tPAdInfo;
                    }

                    @Override
                    public void run() {
                        if (MediaVideoMgr.this.mAdListener != null) {
                            MediaVideoMgr.this.mAdListener.onAdVideoEnd(this.a);
                        }
                    }
                });
            }

            protected void onAdStartLoad() {
                if (MediaVideoMgr.this.mEveryLayerListener == null) {
                    return;
                }
                TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (MediaVideoMgr.this.mEveryLayerListener != null) {
                            MediaVideoMgr.this.mEveryLayerListener.onAdStartLoad(MediaVideoMgr.this.mAdUnitId);
                        }
                    }
                });
            }

            protected void onAdAllLoaded(final boolean bl, boolean bl2) {
                if (!bl && !bl2) {
                    AutoLoadManager.getInstance().loadAdFailed(MediaVideoMgr.this.mAdUnitId);
                }
                if (MediaVideoMgr.this.mEveryLayerListener == null) {
                    return;
                }
                TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (MediaVideoMgr.this.mEveryLayerListener != null) {
                            MediaVideoMgr.this.mEveryLayerListener.onAdAllLoaded(bl);
                        }
                    }
                });
            }

            protected void oneLayerLoadFailed(final String string, final TPBaseAdapter tPBaseAdapter, final String string2) {
                if (MediaVideoMgr.this.mEveryLayerListener == null) {
                    return;
                }
                TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        m m2 = string3;
                        TPAdInfo tPAdInfo = TPAdInfoUtils.getTPAdInfo((String)m2.MediaVideoMgr.this.mAdUnitId, (TPBaseAdapter)string3.tPBaseAdapter);
                        if (m2.MediaVideoMgr.this.mEveryLayerListener != null) {
                            m m3 = string3;
                            String string3 = m3.string;
                            string3.MediaVideoMgr.this.mEveryLayerListener.oneLayerLoadFailed(new TPAdError(string3, m3.string2), tPAdInfo);
                        }
                    }
                });
            }

            protected void oneLayerLoaded(final AdCache adCache) {
                if (MediaVideoMgr.this.mEveryLayerListener == null) {
                    return;
                }
                TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        Object object = adCache;
                        object = object == null ? null : object.getAdapter();
                        n n2 = this;
                        object = TPAdInfoUtils.getTPAdInfo((String)n2.MediaVideoMgr.this.mAdUnitId, (TPBaseAdapter)object);
                        if (n2.MediaVideoMgr.this.mEveryLayerListener != null) {
                            MediaVideoMgr.this.mEveryLayerListener.oneLayerLoaded((TPAdInfo)object);
                        }
                    }
                });
            }

            protected void onAdSkiped(final TPBaseAdapter tPBaseAdapter) {
                TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        o o2 = this;
                        TPAdInfo tPAdInfo = TPAdInfoUtils.getTPAdInfo((String)o2.MediaVideoMgr.this.mAdUnitId, (TPBaseAdapter)tPBaseAdapter);
                        if (o2.MediaVideoMgr.this.mAdListener != null) {
                            MediaVideoMgr.this.mAdListener.onAdSkiped(tPAdInfo);
                        }
                    }
                });
            }

            protected void onAdTapped(final TPBaseAdapter tPBaseAdapter) {
                TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        a a2 = this;
                        TPAdInfo tPAdInfo = TPAdInfoUtils.getTPAdInfo((String)a2.MediaVideoMgr.this.mAdUnitId, (TPBaseAdapter)tPBaseAdapter);
                        if (a2.MediaVideoMgr.this.mAdListener != null) {
                            MediaVideoMgr.this.mAdListener.onAdTapped(tPAdInfo);
                        }
                    }
                });
            }

            protected void oneLayerLoadStart(final TPBaseAdapter tPBaseAdapter) {
                if (MediaVideoMgr.this.mEveryLayerListener == null) {
                    return;
                }
                TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        b b2 = this;
                        TPAdInfo tPAdInfo = TPAdInfoUtils.getTPAdInfo((String)b2.MediaVideoMgr.this.mAdUnitId, (TPBaseAdapter)tPBaseAdapter);
                        if (b2.MediaVideoMgr.this.mEveryLayerListener != null) {
                            MediaVideoMgr.this.mEveryLayerListener.oneLayerLoadStart(tPAdInfo);
                        }
                    }
                });
            }

            protected void onAdVideoError(final String string, final TPBaseAdapter tPBaseAdapter, final String string2) {
                if (MediaVideoMgr.this.mAdListener == null) {
                    return;
                }
                TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        c c2 = string3;
                        TPAdInfo tPAdInfo = TPAdInfoUtils.getTPAdInfo((String)c2.MediaVideoMgr.this.mAdUnitId, (TPBaseAdapter)string3.tPBaseAdapter);
                        if (c2.MediaVideoMgr.this.mAdListener != null) {
                            TPAdError tPAdError;
                            TPAdInfo tPAdInfo2 = tPAdInfo;
                            tPAdInfo = tPAdError;
                            c c3 = string3;
                            String string3 = c3.string;
                            tPAdError = new TPAdError(string3, c3.string2);
                            string3.MediaVideoMgr.this.mAdListener.onAdVideoError(tPAdInfo2, (TPAdError)tPAdInfo);
                        }
                    }
                });
            }

            protected void onAdResume(final TPBaseAdapter tPBaseAdapter) {
                if (MediaVideoMgr.this.mAdListener == null) {
                    return;
                }
                TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        d d2 = this;
                        TPAdInfo tPAdInfo = TPAdInfoUtils.getTPAdInfo((String)d2.MediaVideoMgr.this.mAdUnitId, (TPBaseAdapter)tPBaseAdapter);
                        if (d2.MediaVideoMgr.this.mAdListener != null) {
                            MediaVideoMgr.this.mAdListener.onAdResume(tPAdInfo);
                        }
                    }
                });
            }

            protected void onAdPause(final TPBaseAdapter tPBaseAdapter) {
                if (MediaVideoMgr.this.mAdListener == null) {
                    return;
                }
                TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        e e2 = this;
                        TPAdInfo tPAdInfo = TPAdInfoUtils.getTPAdInfo((String)e2.MediaVideoMgr.this.mAdUnitId, (TPBaseAdapter)tPBaseAdapter);
                        if (e2.MediaVideoMgr.this.mAdListener != null) {
                            MediaVideoMgr.this.mAdListener.onAdPause(tPAdInfo);
                        }
                    }
                });
            }

            protected void onAdProgress(final TPBaseAdapter tPBaseAdapter, final float f2, final double d2) {
                if (MediaVideoMgr.this.mAdListener == null) {
                    return;
                }
                TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        f f22 = this;
                        TPAdInfo tPAdInfo = TPAdInfoUtils.getTPAdInfo((String)f22.MediaVideoMgr.this.mAdUnitId, (TPBaseAdapter)tPBaseAdapter);
                        if (f22.MediaVideoMgr.this.mAdListener != null) {
                            f f3 = this;
                            float f4 = f3.f2;
                            double d22 = f3.d2;
                            MediaVideoMgr.this.mAdListener.onAdProgress(tPAdInfo, f4, d22);
                        }
                    }
                });
            }
        };
        this.mediaVideoAdListener = new MediaVideoAdListener(){

            @Override
            public void onAdLoaded(TPAdInfo tPAdInfo) {
            }

            @Override
            public void onAdClicked(TPAdInfo tPAdInfo) {
            }

            @Override
            public void onAdResume(TPAdInfo tPAdInfo) {
            }

            @Override
            public void onAdPause(TPAdInfo tPAdInfo) {
            }

            @Override
            public void onAdFailed(TPAdError tPAdError) {
            }

            @Override
            public void onAdVideoStart(TPAdInfo tPAdInfo) {
            }

            @Override
            public void onAdVideoEnd(TPAdInfo tPAdInfo) {
            }

            @Override
            public void onAdVideoError(TPAdInfo tPAdInfo, TPAdError tPAdError) {
            }

            @Override
            public void onAdSkiped(TPAdInfo tPAdInfo) {
            }

            @Override
            public void onAdTapped(TPAdInfo tPAdInfo) {
            }

            @Override
            public void onAdProgress(TPAdInfo tPAdInfo, float f2, double d2) {
            }
        };
        GlobalTradPlus.getInstance().refreshContext(context);
        mediaVideoMgr.mAdUnitId = string;
        mediaVideoMgr.mIsReadyLock = new IntervalLock(1000L);
        mediaVideoMgr.startInitUnitIdTime = System.currentTimeMillis();
    }

    private void checkAutoLoadCallback(int n2) {
        this.needManualLoaded = !this.isAutoLoadCallback && 6 == n2;
    }

    private boolean canCallbackLoadedOrFailed() {
        return this.isAutoLoadCallback || this.needManualLoaded;
    }

    private void startMaxLoadTimeThread(float f2) {
        if (!this.needManualLoaded) {
            return;
        }
        TPTaskManager.getInstance().getRefreshThreadHandler().post(() -> {
            Runnable runnable;
            ConfigResponse configResponse;
            long l2;
            long l3 = 0L;
            if (f2 > 0.1f) {
                f2 -= 0.1f;
            }
            if ((l2 = new Float(f2 * 1000.0f).longValue()) <= 0L && (configResponse = ConfigLoadManager.getInstance().getMemoryConfigResponse(this.mAdUnitId)) != null) {
                float f3 = configResponse.getLoadMaxWaitTime() > 0.1f ? configResponse.getLoadMaxWaitTime() - 0.1f : configResponse.getLoadMaxWaitTime();
                l3 = new Float(f3 * 1000.0f).longValue();
            }
            if (l2 <= 0L && l3 <= 0L) {
                return;
            }
            Handler handler = TPTaskManager.getInstance().getRefreshThreadHandler();
            Runnable runnable2 = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    a a2 = a3;
                    a a3 = AdCacheManager.getInstance().getReadyAd(a3.MediaVideoMgr.this.mAdUnitId);
                    a2.MediaVideoMgr.this.onLoaded((AdCache)a3);
                }
            };
            if (l2 <= 0L) {
                l2 = l3;
            }
            handler.postDelayed(runnable2, l2);
        });
    }

    private LoadLifecycleCallback checkAndGetCallback(AdCache adCache) {
        if (adCache != null && adCache.getCallback() != null) {
            AdCache adCache2 = adCache;
            adCache2.getCallback().refreshListener(((MediaVideoMgr)((Object)string)).mLoadAdListener);
            return adCache2.getCallback();
        }
        MediaVideoMgr mediaVideoMgr = string;
        String string = mediaVideoMgr.mAdUnitId;
        return new LoadLifecycleCallback(string, mediaVideoMgr.mLoadAdListener);
    }

    private void startCallBack(TPBaseAdapter tPBaseAdapter, TPAdInfo tPAdInfo, int n2) {
        new TPCallbackManager(this.mAdUnitId, n2, tPBaseAdapter, tPAdInfo).startCallbackRequest(tPBaseAdapter);
    }

    private void onLoaded(final AdCache adCache) {
        if (adCache == null) {
            return;
        }
        if (!this.hasCallBackToDeveloper) {
            this.hasCallBackToDeveloper = true;
            AdCustomCacheManager.getInstance().addCustomCacheLoadedTs(this.mAdUnitId);
            AdMediationManager adMediationManager = AdMediationManager.getInstance((String)this.mAdUnitId);
            LogUtil.ownShow((String)"MediaVideoMgr onAdLoaded set loading false");
            LogUtil.ownShow((String)"MediaVideoMgr onAdLoaded set loadSuccessButNotShow true");
            adMediationManager.setLoading(false);
            adMediationManager.setLoadSuccess(true);
            TPTaskManager.getInstance().runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    AutoLoadManager.getInstance().loadAdLoaded(MediaVideoMgr.this.mAdUnitId);
                    Object object = adCache;
                    object = object == null ? null : object.getAdapter();
                    b b2 = this;
                    object = TPAdInfoUtils.getTPAdInfo((String)b2.MediaVideoMgr.this.mAdUnitId, (TPBaseAdapter)object);
                    if (b2.MediaVideoMgr.this.mAdListener != null && MediaVideoMgr.this.canCallbackLoadedOrFailed()) {
                        MediaVideoMgr.this.mAdListener.onAdLoaded((TPAdInfo)object);
                    }
                    LogUtil.ownShow((String)"MediaVideoMgr onAdLoaded set 1s expired");
                    MediaVideoMgr.this.mIsReadyLock.setExpireSecond(0L);
                }
            });
        }
    }

    static /* synthetic */ boolean access$802(MediaVideoMgr mediaVideoMgr, boolean bl) {
        mediaVideoMgr.hasCallBackToDeveloper = bl;
        return bl;
    }

    public void setAllAdLoadListener(LoadAdEveryLayerListener loadAdEveryLayerListener) {
        this.mEveryLayerListener = loadAdEveryLayerListener;
    }

    public void setAdListener(MediaVideoAdListener mediaVideoAdListener) {
        this.mAdListener = mediaVideoAdListener;
    }

    public void setLoadFailedListener(LoadFailedListener loadFailedListener) {
        this.mLoadFailedListener = loadFailedListener;
    }

    public void loadAd(ViewGroup viewGroup, Object object, MediaVideoAdListener mediaVideoAdListener, int n2, float f2) {
        String string = this.mAdUnitId;
        if (string != null && string.length() > 0) {
            this.mAdUnitId = this.mAdUnitId.trim();
            if (mediaVideoAdListener == null) {
                mediaVideoAdListener = this.mediaVideoAdListener;
            }
            MediaVideoMgr mediaVideoMgr = this;
            mediaVideoMgr.mAdListener = mediaVideoAdListener;
            mediaVideoMgr.mAdContainerView = viewGroup;
            mediaVideoMgr.mObjectVideo = object;
            mediaVideoMgr.checkAutoLoadCallback(n2);
            mediaVideoMgr.startMaxLoadTimeThread(f2);
            mediaVideoMgr.loadAd(n2);
            return;
        }
        CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.LOAD_FAILED_NULL_UNITID);
    }

    public void loadAd(int n2) {
        Object object;
        MediaVideoMgr mediaVideoMgr = object;
        mediaVideoMgr.checkAutoLoadCallback(n2);
        AdMediationManager adMediationManager = AdMediationManager.getInstance((String)mediaVideoMgr.mAdUnitId);
        if (adMediationManager.checkIsLoading()) {
            LoadAdEveryLayerListener loadAdEveryLayerListener = ((MediaVideoMgr)object).mEveryLayerListener;
            if (loadAdEveryLayerListener != null) {
                loadAdEveryLayerListener.onAdIsLoading(((MediaVideoMgr)object).mAdUnitId);
            }
            if ((loadAdEveryLayerListener = adMediationManager.getLoadCallback()) != null) {
                loadAdEveryLayerListener.refreshListener(((MediaVideoMgr)object).mLoadAdListener);
            }
            MediaVideoMgr mediaVideoMgr2 = object;
            object = CustomLogUtils.TradPlusLog.LOAD_LOADING_ADS;
            CustomLogUtils.getInstance().log((CustomLogUtils.TradPlusLog)object, mediaVideoMgr2.mAdUnitId);
            return;
        }
        adMediationManager.setLoading(true);
        LogUtil.ownShow((String)"MediaVideoMgr loadAd setLoading true");
        LogUtil.ownShow((String)"MediaVideoMgr loadAd set hasCallBackToDeveloper false");
        ((MediaVideoMgr)object).hasCallBackToDeveloper = false;
        AutoLoadManager.getInstance().loadAdStart(((MediaVideoMgr)object).mAdUnitId);
        MediaVideoMgr mediaVideoMgr3 = object;
        object = mediaVideoMgr3.mAdUnitId;
        adMediationManager.loadAd(new LoadLifecycleCallback((String)object, mediaVideoMgr3.mLoadAdListener), n2);
    }

    public void setDefaultConfig(String string) {
        this.setDefaultConfig(string, "");
    }

    public void setDefaultConfig(String string, String string2) {
        if (string != null && string.length() > 0) {
            ConfigLoadManager.getInstance().setDefaultConfig(this.mAdUnitId, string, string2);
            return;
        }
        Log.i((String)"tradplus", (String)"MediaVideoMgr setDefaultConfig config is null!");
    }

    public void setAutoLoadCallback(boolean bl) {
        this.isAutoLoadCallback = bl;
    }

    public boolean entryAdScenario(String string) {
        AdCache adCache = AdCacheManager.getInstance().getReadyAd(this.mAdUnitId);
        long l2 = this.startInitUnitIdTime;
        this.checkAndGetCallback(adCache).entryScenario(string, adCache, l2);
        AutoLoadManager.getInstance().checkReloadAdExpired(this.mAdUnitId, 9);
        return adCache != null;
    }

    public Object getAdDisplayContainer() {
        MediaVideoMgr mediaVideoMgr = AdCacheManager.getInstance().getReadyAd(mediaVideoMgr.mAdUnitId);
        if (mediaVideoMgr == null) {
            return null;
        }
        if ((mediaVideoMgr = mediaVideoMgr.getAdapter()) == null) {
            return null;
        }
        return mediaVideoMgr.getNetworkObjectAd();
    }

    public boolean isReady() {
        if (this.mIsReadyLock.isLocked()) {
            return this.lastReadyStatus;
        }
        MediaVideoMgr mediaVideoMgr = this;
        mediaVideoMgr.mIsReadyLock.setExpireSecond(1L);
        mediaVideoMgr.mIsReadyLock.tryLock();
        AdCache adCache = AdCacheManager.getInstance().getReadyAd(this.mAdUnitId);
        this.checkAndGetCallback(adCache).isReady(adCache);
        CustomLogUtils customLogUtils = CustomLogUtils.getInstance();
        CustomLogUtils.TradPlusLog tradPlusLog = CustomLogUtils.TradPlusLog.ISREADY_ACTION;
        StringBuilder stringBuilder = new StringBuilder().append(this.mAdUnitId).append(" ");
        boolean bl = adCache != null;
        customLogUtils.log(tradPlusLog, stringBuilder.append(bl).toString());
        boolean bl2 = adCache != null;
        this.lastReadyStatus = bl2;
        if (adCache != null && !adCache.isBottomWaterfall()) {
            return true;
        }
        AutoLoadManager.getInstance().isReadyFailed(this.mAdUnitId, 2);
        return false;
    }

    public TPCustomMediaVideoAd getVideoAd() {
        AdMediationManager.getInstance((String)((MediaVideoMgr)((Object)string)).mAdUnitId).setLoadSuccess(false);
        AdCache adCache = AdCacheManager.getInstance().getAdCacheToShow(((MediaVideoMgr)((Object)string)).mAdUnitId);
        if (adCache == null) {
            return null;
        }
        MediaVideoMgr mediaVideoMgr = string;
        String string = mediaVideoMgr.mAdUnitId;
        LoadAdListener loadAdListener = mediaVideoMgr.mLoadAdListener;
        return new TPCustomMediaVideoAd(string, adCache, loadAdListener);
    }

    public void setCustomParams(Map<String, Object> map) {
        if (map != null && map.size() > 0) {
            GlobalTradPlus.getInstance().setUserLoadParam(this.mAdUnitId, map);
        }
    }

    public void setIMAEventListener(TPMediaVideoAdapter.OnIMAEventListener onIMAEventListener) {
        this.onIMAEventListener = onIMAEventListener;
    }

    public void onDestroy() {
        MediaVideoMgr mediaVideoMgr = this;
        mediaVideoMgr.mAdListener = null;
        mediaVideoMgr.mEveryLayerListener = null;
        mediaVideoMgr.mAdContainerView = null;
        mediaVideoMgr.mObjectVideo = null;
        mediaVideoMgr.onIMAEventListener = null;
        LogUtil.ownShow((String)("onDestroy:" + this.mAdUnitId));
    }

    public void clearCacheAd() {
        int n2 = AdCacheManager.getInstance().getReadyAdNum(this.mAdUnitId);
        AdCacheManager.getInstance().removeEndCache(this.mAdUnitId, n2);
    }
}

