/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.mgr.mediavideo;

import android.view.View;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.adapter.TPShowAdapterListener;
import com.tradplus.ads.base.adapter.mediavideo.TPMediaVideoAdapter;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.TPVideoAdPlayer;
import com.tradplus.ads.base.filter.FrequencyUtils;
import com.tradplus.ads.common.util.CustomLogUtils;
import com.tradplus.ads.core.cache.AdCache;
import com.tradplus.ads.core.track.LoadAdListener;
import com.tradplus.ads.core.track.LoadLifecycleCallback;
import com.tradplus.ads.core.track.ShowAdListener;
import com.tradplus.ads.mgr.autoload.AutoLoadManager;
import java.util.Map;

public class TPCustomMediaVideoAd {
    private AdCache mAdCache;
    private String mAdUnitId;
    private LoadAdListener mLoadAdListener;
    private Object customNetworkObj = null;
    private Map<String, Object> customShowData;
    private TPVideoAdPlayer mVideoAdPlayer;

    public TPCustomMediaVideoAd(String string, AdCache adCache, LoadAdListener loadAdListener) {
        this.mAdCache = adCache;
        this.mAdUnitId = string;
        this.mLoadAdListener = loadAdListener;
    }

    private LoadLifecycleCallback checkAndGetCallback(AdCache adCache) {
        if (adCache != null && adCache.getCallback() != null) {
            AdCache adCache2 = adCache;
            adCache2.getCallback().refreshListener(((TPCustomMediaVideoAd)((Object)string)).mLoadAdListener);
            return adCache2.getCallback();
        }
        TPCustomMediaVideoAd tPCustomMediaVideoAd = string;
        String string = tPCustomMediaVideoAd.mAdUnitId;
        return new LoadLifecycleCallback(string, tPCustomMediaVideoAd.mLoadAdListener);
    }

    public Object getAdDisplayContainer() {
        TPCustomMediaVideoAd tPCustomMediaVideoAd = tPCustomMediaVideoAd.mAdCache;
        if (tPCustomMediaVideoAd == null) {
            return null;
        }
        if ((tPCustomMediaVideoAd = tPCustomMediaVideoAd.getAdapter()) == null) {
            return null;
        }
        return tPCustomMediaVideoAd.getNetworkObjectAd();
    }

    public Object getCustomNetworkObj() {
        TPCustomMediaVideoAd tPCustomMediaVideoAd = tPCustomMediaVideoAd.mAdCache;
        if (tPCustomMediaVideoAd == null) {
            return null;
        }
        if ((tPCustomMediaVideoAd = tPCustomMediaVideoAd.getAdObj()) == null) {
            return null;
        }
        return tPCustomMediaVideoAd.getNetworkObj();
    }

    public void setNetworkExtObj(Object object) {
        this.customNetworkObj = object;
    }

    public void start(String string) {
        AdCache adCache = this.mAdCache;
        LoadLifecycleCallback loadLifecycleCallback = this.checkAndGetCallback(adCache);
        loadLifecycleCallback.showAdStart(adCache, string);
        if (adCache == null) {
            loadLifecycleCallback.showAdEnd(null, string, "5");
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.SHOW_ACTION, this.mAdUnitId + " , No Ad Ready \u6ca1\u6709\u53ef\u7528\u5e7f\u544a");
            return;
        }
        if (!FrequencyUtils.getInstance().needShowAd(this.mAdUnitId)) {
            LoadLifecycleCallback loadLifecycleCallback2 = new LoadLifecycleCallback(this.mAdUnitId, null);
            loadLifecycleCallback2.showAdStart(null, null);
            loadLifecycleCallback2.showAdEnd(null, string, "4");
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.SHOW_ACTION, this.mAdUnitId + " frequency limited");
            return;
        }
        TPBaseAdapter tPBaseAdapter = adCache.getAdapter();
        if (!(tPBaseAdapter instanceof TPMediaVideoAdapter)) {
            loadLifecycleCallback.showAdEnd(adCache, string, "104", "cache is not mediavideo");
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.SHOW_ACTION, this.mAdUnitId + " cache is not mediavideo");
            return;
        }
        TPBaseAd tPBaseAd = adCache.getAdObj();
        TPMediaVideoAdapter tPMediaVideoAdapter = (TPMediaVideoAdapter)tPBaseAdapter;
        Object object = this.customNetworkObj;
        if (object != null) {
            tPMediaVideoAdapter.setNetworkExtObj(object);
        }
        if (!tPMediaVideoAdapter.isReady()) {
            loadLifecycleCallback.showAdEnd(adCache, string, "5");
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.SHOW_ACTION, this.mAdUnitId + " not ready");
            AutoLoadManager.getInstance().isReadyFailed(this.mAdUnitId, 3);
            return;
        }
        tPBaseAd.setAdShown();
        tPBaseAdapter.setCustomShowData(this.customShowData);
        tPMediaVideoAdapter.setShowListener((TPShowAdapterListener)new ShowAdListener(loadLifecycleCallback, tPBaseAdapter, string));
        tPBaseAd.start();
        loadLifecycleCallback.showAdEnd(adCache, string, "1");
        FrequencyUtils.getInstance().addFrequencyShowCount(this.mAdUnitId);
    }

    public Object getTPAdVideoPlayer() {
        TPCustomMediaVideoAd tPCustomMediaVideoAd = tPCustomMediaVideoAd.mAdCache;
        if (tPCustomMediaVideoAd == null) {
            return null;
        }
        if ((tPCustomMediaVideoAd = tPCustomMediaVideoAd.getAdObj()) != null) {
            return tPCustomMediaVideoAd.getTPAdVideoPlayer();
        }
        return null;
    }

    public void pause() {
        TPCustomMediaVideoAd tPCustomMediaVideoAd = tPCustomMediaVideoAd.mAdCache;
        if (tPCustomMediaVideoAd == null) {
            return;
        }
        if ((tPCustomMediaVideoAd = tPCustomMediaVideoAd.getAdObj()) != null) {
            tPCustomMediaVideoAd.pause();
        }
    }

    public void resume() {
        TPCustomMediaVideoAd tPCustomMediaVideoAd = tPCustomMediaVideoAd.mAdCache;
        if (tPCustomMediaVideoAd == null) {
            return;
        }
        if ((tPCustomMediaVideoAd = tPCustomMediaVideoAd.getAdObj()) != null) {
            tPCustomMediaVideoAd.resume();
        }
    }

    public void registerFriendlyObstruction(View view, int n2, String string) {
        TPCustomMediaVideoAd tPCustomMediaVideoAd = tPCustomMediaVideoAd.mAdCache;
        if (tPCustomMediaVideoAd == null) {
            return;
        }
        if ((tPCustomMediaVideoAd = tPCustomMediaVideoAd.getAdObj()) != null) {
            tPCustomMediaVideoAd.registerFriendlyObstruction(view, n2, string);
        }
    }

    public void unregisterAllFriendlyObstructions() {
        TPCustomMediaVideoAd tPCustomMediaVideoAd = tPCustomMediaVideoAd.mAdCache;
        if (tPCustomMediaVideoAd == null) {
            return;
        }
        if ((tPCustomMediaVideoAd = tPCustomMediaVideoAd.getAdObj()) != null) {
            tPCustomMediaVideoAd.unregisterAllFriendlyObstructions();
        }
    }

    public void setIMAEventListener(TPMediaVideoAdapter.OnIMAEventListener onIMAEventListener) {
        TPCustomMediaVideoAd tPCustomMediaVideoAd = tPCustomMediaVideoAd.mAdCache;
        if (tPCustomMediaVideoAd == null) {
            return;
        }
        if ((tPCustomMediaVideoAd = tPCustomMediaVideoAd.getAdapter()) != null && tPCustomMediaVideoAd instanceof TPMediaVideoAdapter) {
            ((TPMediaVideoAdapter)tPCustomMediaVideoAd).setOnIMAEventListener(onIMAEventListener);
        }
    }

    public void onDestroy() {
        AdCache adCache = this.mAdCache;
        if (adCache != null) {
            try {
                adCache.getAdObj().clean();
            }
            catch (Exception exception) {}
        }
        TPCustomMediaVideoAd tPCustomMediaVideoAd = this;
        tPCustomMediaVideoAd.mAdUnitId = null;
        tPCustomMediaVideoAd.mAdCache = null;
    }

    public Map<String, Object> getCustomShowData() {
        return this.customShowData;
    }

    public void setCustomShowData(Map<String, Object> map) {
        this.customShowData = map;
    }
}

