/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.mgr.retry;

import com.tradplus.ads.base.common.TPDataManager;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.config.ConfigLoadManager;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.common.util.CustomLogUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.open.splash.TPSplash;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class RetryLoadSplash {
    private final ArrayList<Integer> refreshTimeRelease;
    private final long minLoadIntervalTime;
    private String adUnitId;
    private long lastLoadTime;
    private long lastLoadedTime;
    private int loadErrorNum;
    private TPSplash tpSplash;
    private Runnable loadFailedDelay;

    public RetryLoadSplash(String string, TPSplash tPSplash) {
        Runnable runnable;
        ArrayList arrayList;
        Object object = arrayList;
        arrayList = new ArrayList();
        this.refreshTimeRelease = object;
        this.minLoadIntervalTime = 5000L;
        this.loadErrorNum = 1;
        object = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                RetryLoadSplash retryLoadSplash = RetryLoadSplash.this;
                retryLoadSplash.timeToLoadAd(retryLoadSplash.loadErrorNum + 500);
            }
        };
        this.loadFailedDelay = object;
        this.adUnitId = string;
        this.tpSplash = tPSplash;
    }

    public void initSplashRetryLoad() {
        LogUtil.ownShow((String)("--RetryLoadSplash initSplashRetryLoad = " + this.lastLoadedTime));
        ConfigLoadManager.getInstance().loadConfig(this.adUnitId, new ConfigLoadManager.ConfigLoadListener(){

            public void onSuccess(ConfigResponse configResponse) {
                if (configResponse == null) {
                    return;
                }
                RetryLoadSplash.this.saveServerConfigResponse(configResponse);
            }

            public void onFailed(int n2, String string) {
            }
        });
    }

    public void loadAdStart() {
        this.lastLoadTime = System.currentTimeMillis();
    }

    public void loadAdLoaded() {
        RetryLoadSplash retryLoadSplash = this;
        retryLoadSplash.lastLoadedTime = System.currentTimeMillis();
        retryLoadSplash.loadErrorNum = 1;
    }

    public void loadAdFailed() {
        block4: {
            int n2;
            ArrayList<Integer> arrayList;
            this.lastLoadedTime = System.currentTimeMillis();
            LogUtil.ownShow((String)("--RetryLoadSplash loadAdFailed adUnitId = " + this.adUnitId + ",lastLoadedTime = " + this.lastLoadedTime));
            if (this.refreshTimeRelease.isEmpty() || this.loadErrorNum >= this.refreshTimeRelease.size() + 1) break block4;
            try {
                arrayList = this.refreshTimeRelease;
                n2 = this.loadErrorNum;
            }
            catch (Exception exception) {}
            long l2 = arrayList.get(n2 - 1) * 1000;
            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.AUTOLOAD_ALLFAILED, " " + this.adUnitId + " failed num:" + this.loadErrorNum + " delay time:" + l2);
            TPTaskManager.getInstance().getAutoThreadHandler().removeCallbacks(this.loadFailedDelay);
            TPTaskManager.getInstance().getAutoThreadHandler().postDelayed(this.loadFailedDelay, l2);
            return;
        }
        LogUtil.ownShow((String)("--RetryLoadSplash loadAdFailed : " + this.adUnitId + " don't load, but reset num to 0, max num:" + this.loadErrorNum));
        CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.AUTOLOAD_ALLFAILED, " " + this.adUnitId + " don't load, but reset num to 0, max num:" + this.loadErrorNum);
        this.loadErrorNum = 1;
        TPTaskManager.getInstance().getAutoThreadHandler().removeCallbacks(this.loadFailedDelay);
    }

    public void timeToLoadAd(int n2) {
        block3: {
            LogUtil.ownShow((String)("--RetryLoadSplash timeToLoadAd adUnitId = " + this.adUnitId + ",status = " + n2));
            if (Math.abs(System.currentTimeMillis() - this.lastLoadTime) < 5000L) {
                return;
            }
            ++this.loadErrorNum;
            try {
                this.loadAd(n2);
            }
            catch (Exception exception) {
                if (!TPDataManager.getInstance().isDebugMode()) break block3;
                exception.printStackTrace();
            }
        }
    }

    public synchronized void saveServerConfigResponse(ConfigResponse object) {
        if ((object = object.getIntergroup_autoload_retry_config()) != null && !object.isEmpty()) {
            ArrayList arrayList;
            TreeMap treeMap;
            Object object2 = object;
            object = treeMap;
            treeMap = new TreeMap();
            Iterator<Object> iterator = object2.iterator();
            while (iterator.hasNext()) {
                ConfigResponse.AdunitAutoloadRetryInfoBean adunitAutoloadRetryInfoBean = (ConfigResponse.AdunitAutoloadRetryInfoBean)iterator.next();
                if (adunitAutoloadRetryInfoBean.getTimes() <= 0) continue;
                ((TreeMap)object).put(adunitAutoloadRetryInfoBean.getTimes(), adunitAutoloadRetryInfoBean);
            }
            Object object3 = object;
            object = arrayList;
            arrayList = new ArrayList();
            iterator = ((TreeMap)object3).entrySet().iterator();
            while (iterator.hasNext()) {
                ((ArrayList)object).add(((ConfigResponse.AdunitAutoloadRetryInfoBean)((Map.Entry)iterator.next()).getValue()).getSecond());
            }
            if (!((ArrayList)object).isEmpty()) {
                RetryLoadSplash retryLoadSplash = this;
                retryLoadSplash.refreshTimeRelease.clear();
                retryLoadSplash.refreshTimeRelease.addAll((Collection<Integer>)object);
            }
        }
    }

    public void loadAd(int n2) {
        TPSplash tPSplash = this.tpSplash;
        if (tPSplash != null && tPSplash.getMgr() != null) {
            this.tpSplash.getMgr().loadAd(n2);
        }
    }

    public int getErrorCode() {
        return this.loadErrorNum + 500;
    }
}

