/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.topup_sdk.Common.widget.autotextview;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Build;
import android.text.Editable;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextWatcher;
import android.text.method.SingleLineTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.TextView;
import com.alipaypal.cash.moneyapps.pay.recharge.electricitybill.bank.card.MyMTN.Myairtel.earnonline.Toloka.MobileRechare.Opera.opay.myid.MTN.wallet.R;
import java.util.ArrayList;

public class AutoHelper {
    private static final String TAG = "AutoFitTextHelper";
    private static final boolean SPEW = false;
    private static final int DEFAULT_MIN_TEXT_SIZE = 8;
    private static final float DEFAULT_PRECISION = 0.5f;
    private TextView mTextView;
    private TextPaint mPaint;
    private float mTextSize;
    private int mMaxLines;
    private float mMinTextSize;
    private float mMaxTextSize;
    private float mPrecision;
    private boolean mEnabled;
    private boolean mIsAutofitting;
    private ArrayList<OnTextSizeChangeListener> mListeners;
    private TextWatcher mTextWatcher = new AutofitTextWatcher();
    private View.OnLayoutChangeListener mOnLayoutChangeListener = new AutofitOnLayoutChangeListener();

    public static AutoHelper create(TextView textView) {
        return AutoHelper.create(textView, null, 0);
    }

    public static AutoHelper create(TextView textView, AttributeSet attributeSet) {
        return AutoHelper.create(textView, attributeSet, 0);
    }

    public static AutoHelper create(TextView textView, AttributeSet attributeSet, int n2) {
        AutoHelper autoHelper;
        AutoHelper autoHelper2 = autoHelper;
        autoHelper = new AutoHelper(textView);
        boolean bl = true;
        if (attributeSet != null) {
            AutoHelper autoHelper3 = autoHelper2;
            int n3 = (int)autoHelper3.getMinTextSize();
            float f2 = autoHelper3.getPrecision();
            TypedArray typedArray = textView.getContext().obtainStyledAttributes(attributeSet, R.styleable.AutoTextView, n2, 0);
            bl = typedArray.getBoolean(R.styleable.AutoTextView_sizeToFit, bl);
            int n4 = typedArray.getDimensionPixelSize(R.styleable.AutoTextView_minTextSize, n3);
            TypedArray typedArray2 = typedArray;
            float f3 = typedArray2.getFloat(R.styleable.AutoTextView_precision, f2);
            typedArray2.recycle();
            autoHelper2.setMinTextSize(0, n4).setPrecision(f3);
        }
        AutoHelper autoHelper4 = autoHelper2;
        autoHelper4.setEnabled(bl);
        return autoHelper4;
    }

    private static void autofit(TextView textView, TextPaint textPaint, float f2, float f3, int n2, float f4) {
        block7: {
            block10: {
                float f5;
                TransformationMethod transformationMethod;
                CharSequence charSequence;
                int n3;
                block9: {
                    block8: {
                        if (n2 <= 0 || n2 == Integer.MAX_VALUE) break block7;
                        n3 = textView.getWidth() - textView.getPaddingLeft() - textView.getPaddingRight();
                        if (n3 <= 0) {
                            return;
                        }
                        TextView textView2 = textView;
                        charSequence = textView2.getText();
                        transformationMethod = textView2.getTransformationMethod();
                        if (transformationMethod != null) {
                            charSequence = transformationMethod.getTransformation(charSequence, (View)textView);
                        }
                        transformationMethod = textView.getContext();
                        Resources resources = Resources.getSystem();
                        f5 = 0.0f;
                        if (transformationMethod != null) {
                            resources = transformationMethod.getResources();
                        }
                        transformationMethod = resources.getDisplayMetrics();
                        textPaint.set(textView.getPaint());
                        textPaint.setTextSize(f3);
                        if (n2 != 1) break block8;
                        CharSequence charSequence2 = charSequence;
                        if (textPaint.measureText(charSequence2, 0, charSequence2.length()) > (float)n3) break block9;
                    }
                    if (AutoHelper.getLineCount(charSequence, textPaint, f3, n3, (DisplayMetrics)transformationMethod) <= n2) break block10;
                }
                f3 = AutoHelper.getAutofitTextSize(charSequence, textPaint, n3, n2, f5, f3, f4, (DisplayMetrics)transformationMethod);
            }
            if (f3 < f2) {
                f3 = f2;
            }
            textView.setTextSize(0, f3);
            return;
        }
    }

    private static float getAutofitTextSize(CharSequence charSequence, TextPaint textPaint, float f2, int n2, float f3, float f4, float f5, DisplayMetrics displayMetrics) {
        float f6 = (f3 + f4) / 2.0f;
        int n3 = 1;
        StaticLayout staticLayout = null;
        textPaint.setTextSize(TypedValue.applyDimension((int)0, (float)f6, (DisplayMetrics)displayMetrics));
        if (n2 != 1) {
            StaticLayout staticLayout2;
            staticLayout = staticLayout2;
            n3 = (int)f2;
            Layout.Alignment alignment = Layout.Alignment.ALIGN_NORMAL;
            n3 = new StaticLayout(charSequence, textPaint, n3, alignment, 1.0f, 0.0f, true).getLineCount();
        }
        if (n3 > n2) {
            if (f4 - f3 < f5) {
                return f3;
            }
            return AutoHelper.getAutofitTextSize(charSequence, textPaint, f2, n2, f3, f6, f5, displayMetrics);
        }
        if (n3 < n2) {
            return AutoHelper.getAutofitTextSize(charSequence, textPaint, f2, n2, f6, f4, f5, displayMetrics);
        }
        float f7 = 0.0f;
        if (n2 == 1) {
            float f8;
            n3 = charSequence.length();
            f7 = f8 = textPaint.measureText(charSequence, 0, n3);
        } else {
            for (int i2 = 0; i2 < n3; ++i2) {
                if (!(staticLayout.getLineWidth(i2) > f7)) continue;
                f7 = staticLayout.getLineWidth(i2);
            }
        }
        if (f4 - f3 < f5) {
            return f3;
        }
        if (f7 > f2) {
            return AutoHelper.getAutofitTextSize(charSequence, textPaint, f2, n2, f3, f6, f5, displayMetrics);
        }
        if (f7 < f2) {
            return AutoHelper.getAutofitTextSize(charSequence, textPaint, f2, n2, f6, f4, f5, displayMetrics);
        }
        return f6;
    }

    private static int getLineCount(CharSequence charSequence, TextPaint textPaint, float f2, float f3, DisplayMetrics displayMetrics) {
        textPaint.setTextSize(TypedValue.applyDimension((int)0, (float)f2, (DisplayMetrics)displayMetrics));
        CharSequence charSequence2 = charSequence;
        charSequence = Layout.Alignment.ALIGN_NORMAL;
        return new StaticLayout(charSequence2, textPaint, (int)f3, (Layout.Alignment)charSequence, 1.0f, 0.0f, true).getLineCount();
    }

    private static int getMaxLines(TextView textView) {
        int n2 = -1;
        TransformationMethod transformationMethod = textView.getTransformationMethod();
        if (transformationMethod != null && transformationMethod instanceof SingleLineTransformationMethod) {
            n2 = 1;
        } else if (Build.VERSION.SDK_INT >= 16) {
            n2 = textView.getMaxLines();
        }
        return n2;
    }

    private AutoHelper(TextView textView) {
        float f2 = textView.getContext().getResources().getDisplayMetrics().scaledDensity;
        AutoHelper autoHelper = this;
        autoHelper.mTextView = textView;
        autoHelper.mPaint = new TextPaint();
        this.setRawTextSize(textView.getTextSize());
        this.mMaxLines = AutoHelper.getMaxLines(textView);
        this.mMinTextSize = f2 * 8.0f;
        this.mMaxTextSize = this.mTextSize;
        this.mPrecision = 0.5f;
    }

    private void setRawMinTextSize(float f2) {
        if (f2 != this.mMinTextSize) {
            this.mMinTextSize = f2;
            this.autofit();
        }
    }

    private void setRawMaxTextSize(float f2) {
        if (f2 != this.mMaxTextSize) {
            this.mMaxTextSize = f2;
            this.autofit();
        }
    }

    private void setRawTextSize(float f2) {
        if (this.mTextSize != f2) {
            this.mTextSize = f2;
        }
    }

    private void autofit() {
        AutoHelper autoHelper = this;
        float f2 = autoHelper.mTextView.getTextSize();
        autoHelper.mIsAutofitting = true;
        AutoHelper autoHelper2 = this;
        TextPaint textPaint = autoHelper2.mPaint;
        float f3 = autoHelper2.mMinTextSize;
        float f4 = autoHelper2.mMaxTextSize;
        int n2 = autoHelper2.mMaxLines;
        float f5 = autoHelper2.mPrecision;
        AutoHelper.autofit(autoHelper.mTextView, textPaint, f3, f4, n2, f5);
        autoHelper.mIsAutofitting = false;
        float f6 = autoHelper.mTextView.getTextSize();
        if (f6 != f2) {
            this.sendTextSizeChange(f6, f2);
        }
    }

    private void sendTextSizeChange(float f2, float f3) {
        Object object = ((AutoHelper)object).mListeners;
        if (object == null) {
            return;
        }
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            ((OnTextSizeChangeListener)object.next()).onTextSizeChange(f2, f3);
        }
    }

    public AutoHelper addOnTextSizeChangeListener(OnTextSizeChangeListener onTextSizeChangeListener) {
        if (this.mListeners == null) {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            this.mListeners = arrayList2;
        }
        AutoHelper autoHelper = this;
        autoHelper.mListeners.add(onTextSizeChangeListener);
        return autoHelper;
    }

    public AutoHelper removeOnTextSizeChangeListener(OnTextSizeChangeListener onTextSizeChangeListener) {
        ArrayList<OnTextSizeChangeListener> arrayList = this.mListeners;
        if (arrayList != null) {
            arrayList.remove(onTextSizeChangeListener);
        }
        return this;
    }

    public float getPrecision() {
        return this.mPrecision;
    }

    public AutoHelper setPrecision(float f2) {
        if (this.mPrecision != f2) {
            this.mPrecision = f2;
            this.autofit();
        }
        return this;
    }

    public float getMinTextSize() {
        return this.mMinTextSize;
    }

    public AutoHelper setMinTextSize(float f2) {
        return this.setMinTextSize(2, f2);
    }

    public AutoHelper setMinTextSize(int n2, float f2) {
        Context context = this.mTextView.getContext();
        Resources resources = Resources.getSystem();
        if (context != null) {
            resources = context.getResources();
        }
        AutoHelper autoHelper = this;
        autoHelper.setRawMinTextSize(TypedValue.applyDimension((int)n2, (float)f2, (DisplayMetrics)resources.getDisplayMetrics()));
        return autoHelper;
    }

    public float getMaxTextSize() {
        return this.mMaxTextSize;
    }

    public AutoHelper setMaxTextSize(float f2) {
        return this.setMaxTextSize(2, f2);
    }

    public AutoHelper setMaxTextSize(int n2, float f2) {
        Context context = this.mTextView.getContext();
        Resources resources = Resources.getSystem();
        if (context != null) {
            resources = context.getResources();
        }
        AutoHelper autoHelper = this;
        autoHelper.setRawMaxTextSize(TypedValue.applyDimension((int)n2, (float)f2, (DisplayMetrics)resources.getDisplayMetrics()));
        return autoHelper;
    }

    public int getMaxLines() {
        return this.mMaxLines;
    }

    public AutoHelper setMaxLines(int n2) {
        if (this.mMaxLines != n2) {
            this.mMaxLines = n2;
            this.autofit();
        }
        return this;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public AutoHelper setEnabled(boolean bl) {
        if (this.mEnabled != bl) {
            this.mEnabled = bl;
            if (bl) {
                AutoHelper autoHelper = this;
                autoHelper.mTextView.addTextChangedListener(this.mTextWatcher);
                autoHelper.mTextView.addOnLayoutChangeListener(this.mOnLayoutChangeListener);
                autoHelper.autofit();
            } else {
                AutoHelper autoHelper = this;
                autoHelper.mTextView.removeTextChangedListener(this.mTextWatcher);
                autoHelper.mTextView.removeOnLayoutChangeListener(this.mOnLayoutChangeListener);
                autoHelper.mTextView.setTextSize(0, this.mTextSize);
            }
        }
        return this;
    }

    public float getTextSize() {
        return this.mTextSize;
    }

    public void setTextSize(float f2) {
        this.setTextSize(2, f2);
    }

    public void setTextSize(int n2, float f2) {
        if (this.mIsAutofitting) {
            return;
        }
        Context context = this.mTextView.getContext();
        Resources resources = Resources.getSystem();
        if (context != null) {
            resources = context.getResources();
        }
        this.setRawTextSize(TypedValue.applyDimension((int)n2, (float)f2, (DisplayMetrics)resources.getDisplayMetrics()));
    }

    public static interface OnTextSizeChangeListener {
        public void onTextSizeChange(float var1, float var2);
    }

    private class AutofitOnLayoutChangeListener
    implements View.OnLayoutChangeListener {
        private AutofitOnLayoutChangeListener() {
        }

        public void onLayoutChange(View view, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
            AutoHelper.this.autofit();
        }
    }

    private class AutofitTextWatcher
    implements TextWatcher {
        private AutofitTextWatcher() {
        }

        public void beforeTextChanged(CharSequence charSequence, int n2, int n3, int n4) {
        }

        public void onTextChanged(CharSequence charSequence, int n2, int n3, int n4) {
            AutoHelper.this.autofit();
        }

        public void afterTextChanged(Editable editable) {
        }
    }
}

