package com.transsion.ad;

import android.os.HandlerThread;
import android.os.Message;

import androidx.annotation.Nullable;

import com.transsion.ad.interstitialad.InterstitialAdListener;
import com.transsion.ad.interstitialad.InterstitialAdLoader;
import com.transsion.ad.nativead.NativeAdListener;
import com.transsion.ad.nativead.NativeAdLoader;
import com.transsion.ad.sdk.DispatcherLoaderTaskHandler;
import com.transsion.ad.util.AdLog;

public class AdLoaderManger {
    private static final String TAG = AdLog.COMMON_TAG + "AdLoaderManger";
    private final DispatcherLoaderTaskHandler mTaskHandler;

    private AdLoaderManger() {
        HandlerThread handlerThread = new HandlerThread("load_task_thread");
        handlerThread.start();
        mTaskHandler = new DispatcherLoaderTaskHandler(handlerThread.getLooper());
    }

    private static class AdLoaderMangerHolder{
        private static final AdLoaderManger instance = new AdLoaderManger();
    }

    public static AdLoaderManger getInstance(){
        return AdLoaderMangerHolder.instance;
    }

    /**
     * 请求原生广告，如果需要提前预加载，给下个页面缓存数据，listener传空即可
     *
     * @param scenesId 场景id
     * @param force    是否强制请求网络数据，忽略缓存数据
     * @param listener 原生广告请求监听器
     */
    public void addNativeAdLoaderRequest(int scenesId, boolean force, @Nullable NativeAdListener listener) {
        Message msg = mTaskHandler.obtainMessage();
        msg.what = DispatcherLoaderTaskHandler.NATIVE_AD_TASK;
        msg.arg1 = scenesId;
        msg.arg2 = force ? 1 : 0;
        msg.obj = listener;
        msg.sendToTarget();
    }

    /**
     * 请求插屏广告，如果需要提前预加载，给下个页面缓存数据，listener传空即可
     *
     * @param scenesId 场景id
     * @param force    是否强制请求网络数据，忽略缓存数据
     * @param listener 插屏广告请求监听器
     */
    public void addInterstitialAdLoaderRequest(int scenesId, boolean force, @Nullable InterstitialAdListener listener) {
        Message msg = mTaskHandler.obtainMessage();
        msg.what = DispatcherLoaderTaskHandler.INTERSTITIAL_AD_TASK;
        msg.arg1 = scenesId;
        msg.arg2 = force ? 1 : 0;
        msg.obj = listener;
        msg.sendToTarget();
    }

    /**
     * 请求备选原生广告，如果需要提前预加载，给下个页面缓存数据，listener传空即可
     * @param force 是否强制请求网络数据，忽略缓存数据
     * @param listener 插屏广告请求监听器
     */
    public void addBackupNativeAdLoaderRequest(boolean force, @Nullable NativeAdListener listener) {
        Message msg = mTaskHandler.obtainMessage();
        msg.what = DispatcherLoaderTaskHandler.BACKUP_NATIVE_AD_TASK;
        msg.arg2 = force ? 1 : 0;
        msg.obj = listener;
        msg.sendToTarget();
    }

    /**
     * 请求备选插屏广告，如果需要提前预加载，给下个页面缓存数据，listener传空即可
     * @param force 是否强制请求网络数据，忽略缓存数据
     * @param listener 插屏广告请求监听器
     */
    public void addBackupInterstitialAdLoaderRequest(boolean force, @Nullable InterstitialAdListener listener) {
        Message msg = mTaskHandler.obtainMessage();
        msg.what = DispatcherLoaderTaskHandler.BACKUP_INTERSTITIAL_AD_TASK;
        msg.arg2 = force ? 1 : 0;
        msg.obj = listener;
        msg.sendToTarget();
    }

    public void destroy(NativeAdListener listener, @Nullable NativeAdLoader... loaders) {
        //移除Listener
        Message msg = mTaskHandler.obtainMessage();
        msg.what = DispatcherLoaderTaskHandler.REMOVE_NATIVE_LISTENER;
        msg.obj = listener;
        msg.sendToTarget();
        if (loaders == null) {
            return;
        }
        for (NativeAdLoader loader : loaders) {
            if (loader == null) {
                break;
            }
            loader.destroy();
        }
    }

    public void destroy(InterstitialAdListener listener, @Nullable InterstitialAdLoader... loaders) {
        //移除Listener
        Message msg = mTaskHandler.obtainMessage();
        msg.what = DispatcherLoaderTaskHandler.REMOVE_INTERSTITIAL_LISTENER;
        msg.obj = listener;
        msg.sendToTarget();
        if (loaders == null) {
            return;
        }
        for (InterstitialAdLoader loader : loaders) {
            if (loader == null) {
                break;
            }
            loader.destroy();
        }
    }
}
