package com.transsion.ad.interstitialad;

import androidx.annotation.NonNull;

import com.transsion.ad.sdk.AbstractAdListener;
import com.transsion.ad.sdk.wrap.AdErrorWrapper;
import com.transsion.ad.util.AdLog;

public class InterstitialAdListener extends AbstractAdListener<InterstitialAdLoader> {
    /**
     * Called when the ad failed to show full screen content.
     *
     * @param adError Error information about why an ad operation failed.
     */
    public void onAdFailedToShowFullScreenContent(@NonNull InterstitialAdLoader loader, @NonNull AdErrorWrapper adError) {
        AdLog.e(TAG, "onAdFailedToShowFullScreenContent loader = " + loader + " adError = " + adError);
    }

    /**
     * Called when the ad showed the full screen content.
     */
    public void onAdShowedFullScreenContent(@NonNull InterstitialAdLoader loader) {
        AdLog.i(TAG, "onAdShowedFullScreenContent loader = " + loader);
    }

    @Override
    protected String getClassName() {
        return "InterstitialAdListener";
    }
}
