package com.transsion.ad.interstitialad;


import android.app.Activity;
import android.content.Context;
import android.os.Bundle;

import androidx.annotation.NonNull;

import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdapterResponseInfo;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.transsion.ad.data.Scenes;
import com.transsion.ad.nativead.NativeAdLoader;
import com.transsion.ad.sdk.AbstractAdLoader;
import com.transsion.ad.sdk.LoaderCache;
import com.transsion.ad.sdk.wrap.AdErrorWrapper;
import com.transsion.ad.sdk.wrap.AdValueWrapper;
import com.transsion.ad.util.AdEvent;
import com.transsion.ad.util.AdLog;

public class InterstitialAdLoader extends AbstractAdLoader<InterstitialAdListener> {
    private InterstitialAd interstitialAd;

    public InterstitialAdLoader(Scenes scenes) {
        super(scenes);
    }

    @Override
    public void loadAd(InterstitialAdListener listener) {
        this.listener = listener;
        load(false, false);
    }

    @Override
    public void preloadAd(boolean force, InterstitialAdListener listener) {
        this.listener = listener;
        load(force, true);
    }

    @Override
    public boolean isExpired(boolean show) {
        return interstitialAd == null || super.isExpired(show);
    }

    @Override
    protected void cacheLoaded() {
        if (listener != null) {
            listener.onLoaded(InterstitialAdLoader.this);
        }
    }

    @Override
    protected void loadRequest() {
        Context context = getContext();
        if (context == null) {
            AdLog.e(TAG, "end load, context is null");
            return;
        }
        AdRequest adRequest = new AdRequest.Builder()/*.setHttpTimeoutMillis(5000)*/.build();
        InterstitialAd.load(context.getApplicationContext(), scenes.getAdId(), adRequest, new InterstitialAdLoadCallback() {
            @Override
            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                if (listener != null) {
                    listener.onError(InterstitialAdLoader.this, new AdErrorWrapper(loadAdError));
                }
            }

            @Override
            public void onAdLoaded(@NonNull InterstitialAd adManagerInterstitialAd) {
                AdapterResponseInfo loadedResponseInfo = adManagerInterstitialAd.getResponseInfo().getLoadedAdapterResponseInfo();
                InterstitialAdLoader.this.responseInfo = loadedResponseInfo != null ? loadedResponseInfo.toString() : null;
                InterstitialAdLoader.this.interstitialAd = adManagerInterstitialAd;
                InterstitialAdLoader.this.time = System.currentTimeMillis();

                Bundle extras = adManagerInterstitialAd.getResponseInfo().getResponseExtras();
                final String mediationGroupName = extras.getString("mediation_group_name");
                final String sourceName = loadedResponseInfo != null ? loadedResponseInfo.getAdSourceName() : null;

                adManagerInterstitialAd.setOnPaidEventListener(adValue -> {
                    AdLog.d(TAG, "paid event valueMicros:" + adValue.getValueMicros() + "; currencyCode:" + adValue.getCurrencyCode() + "; precisionType:" + adValue.getPrecisionType() + "; loader:" + InterstitialAdLoader.this);
                    AdValueWrapper adValueWrapper = new AdValueWrapper(adValue);
                    adValueWrapper.setAdRevenueUnit(getScenes().getAdId());
                    adValueWrapper.setAdRevenueNetwork(sourceName);
                    adValueWrapper.setAdRevenuePlacement(mediationGroupName);
                    AdEvent.getInstance().sendAdRevenueInfoToAdjust(adValueWrapper);
                });

                LoaderCache.getInstance().putInterstitialAdLoaderInCache(InterstitialAdLoader.this, scenes.getAdId());
                if (listener != null) {
                    listener.onLoaded(InterstitialAdLoader.this);
                }
            }
        });
    }

    @Override
    protected boolean noCacheHandled() {
        if (listener != null) {
            return listener.onCacheInvalid(InterstitialAdLoader.this);
        }
        return super.noCacheHandled();
    }

    private final FullScreenContentCallback fullScreenContentCallback = new FullScreenContentCallback() {
        @Override
        public void onAdClicked() {
            if (listener != null) {
                listener.onClicked(InterstitialAdLoader.this);
            }
        }

        @Override
        public void onAdDismissedFullScreenContent() {
            super.onAdDismissedFullScreenContent();
            if (listener != null) {
                listener.onClosed(InterstitialAdLoader.this);
            }
        }

        @Override
        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
            super.onAdFailedToShowFullScreenContent(adError);
            if (listener != null) {
                listener.onAdFailedToShowFullScreenContent(InterstitialAdLoader.this, new AdErrorWrapper(adError));
            }
        }

        @Override
        public void onAdImpression() {
            super.onAdImpression();
            if (listener != null) {
                listener.onShow(InterstitialAdLoader.this);
            }
        }

        @Override
        public void onAdShowedFullScreenContent() {
            super.onAdShowedFullScreenContent();
            if (listener != null) {
                listener.onAdShowedFullScreenContent(InterstitialAdLoader.this);
            }
        }
    };

    @Override
    public String getSubResponseInfo() {
        if (responseInfo != null && responseInfo.length() > 100) {
            return responseInfo.substring(0, 100);
        }
        return responseInfo;
    }

    public boolean show(Activity activity) {
        LoaderCache.getInstance().removeInterstitialAdLoaderCache(this, scenes.getAdId());
        if (isShowed) {
            return false;
        }
        interstitialAd.setFullScreenContentCallback(fullScreenContentCallback);
        interstitialAd.show(activity);
        isShowed = true;
        return true;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (isShowed) {
            if (interstitialAd != null) {
                interstitialAd = null;
            }
        } else {
            if (!isExpired(false)) {
                //退出时如果当前数据没有被使用，重新放回cache中
                LoaderCache.getInstance().putInterstitialAdLoaderInCache(this, scenes.getAdId());
            }
        }
    }

    @Override
    protected String getClassName() {
        return "InterstitialAdLoader";
    }
}
