package com.transsion.ad.nativead;


import androidx.annotation.NonNull;

import com.transsion.ad.sdk.AbstractAdListener;
import com.transsion.ad.sdk.wrap.NativeAdWrapper;
import com.transsion.ad.sdk.wrap.NativeCustomFormatAdWrapper;
import com.transsion.ad.util.AdLog;

public class NativeAdListener extends AbstractAdListener<NativeAdLoader> {

    /**
     * Called when a native ad has successfully loaded.
     *
     * @param nativeAd An object containing the native ad assets.
     */
    public void onNativeAdLoaded(@NonNull NativeAdLoader loader, @NonNull NativeAdWrapper nativeAd) {
        AdLog.i(TAG, "onNativeAdLoaded loader = " + loader);
    }

    /**
     * Called when a custom native ad format has successfully loaded.
     *
     * @param nativeCustomFormatAd An object containing the native ad assets.
     */
    public void onCustomFormatAdLoaded(@NonNull NativeAdLoader loader, @NonNull NativeCustomFormatAdWrapper nativeCustomFormatAd) {
        AdLog.i(TAG, "onCustomFormatAdLoaded loader = " + loader + "  customId = " + nativeCustomFormatAd.getCustomFormatId());
    }

    /**
     * Called when a custom native ad format is clicked.
     *
     * @param nativeCustomFormatAd The custom native ad format that was clicked.
     * @param assetName            The name of the asset that was clicked.
     */
    public void onCustomClick(@NonNull NativeAdLoader loader, @NonNull NativeCustomFormatAdWrapper nativeCustomFormatAd, @NonNull String assetName) {
        AdLog.i(TAG, "onCustomClick loader = " + loader + "  customId = " + nativeCustomFormatAd.getCustomFormatId() + " assetName = " + assetName);
    }

    @Override
    protected String getClassName() {
        return "NativeAdListener";
    }
}
