package com.transsion.ad.sdk;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.transsion.ad.sdk.wrap.AdErrorWrapper;
import com.transsion.ad.util.AdLog;

public abstract class AbstractAdListener<T> implements IAdListener<T> {
    protected final String TAG = getClassName();

    @Override
    public void onLoaded(@NonNull T loader) {
        AdLog.i(TAG, "onLoad info loader = " + loader);
    }

    @Override
    public void onError(@NonNull T loader, @NonNull AdErrorWrapper loadAdError) {
        AdLog.e(TAG, "onError" + "loader = " +  loader + " errorCode = " + loadAdError);
    }

    @Override
    public boolean onCacheInvalid(@Nullable T loader) {
        AdLog.i(TAG, "onCacheInvalid loader = " +  loader );
        return false;
    }

    @Override
    public void onClicked(@NonNull T loader) {
        AdLog.i(TAG, "onClicked" + "loader = " + loader);
    }

    @Override
    public void onClosed(@NonNull T loader) {
        AdLog.i(TAG, "onClosed loader = " + loader);
    }

    @Override
    public void onOpened(@NonNull T loader) {
        AdLog.i(TAG, "onOpened loader = " + loader);
    }

    @Override
    public void onShow(@NonNull T loader) {
        AdLog.i(TAG, "onShow loader = " + loader);
    }

    protected abstract String getClassName();
}
