package com.transsion.ad.sdk;

import android.content.Context;

import com.transsion.ad.data.Scenes;

public interface ILoader<T> {
    void loadAd(T listener);

    void preloadAd(boolean force, T listener);

    /**
     * Check if ad exists and can be shown.
     */
    boolean isExpired(boolean show);

    Context getContext();

    void destroy();

    boolean isPreload();

    boolean isCache();

    boolean isForceLoad();

    void setScenes(Scenes scenes);

    Scenes getScenes();

    String getResponseInfo();

    String getSubResponseInfo();
}
