package com.transsion.ad.sdk.wrap;

import androidx.annotation.NonNull;

import com.google.android.gms.ads.AdError;

public class AdErrorWrapper {
    private final AdError error;

    public AdErrorWrapper(@NonNull AdError adError) {
        this.error = adError;
    }

    public int getCode() {
        return error.getCode();
    }

    public String getMessage() {
        return error.getMessage();
    }

    public String getSubMessage() {
        String message = error.getCode() + ";" + getMessage();
        if (message.length() > 100) {
            return message.substring(0, 100);
        }
        return message;
    }

    @NonNull
    @Override
    public String toString() {
        return "AdErrorWrapper{" +
                "error=" + error +
                '}';
    }
}
