package com.transsion.ad.sdk.wrap;

import com.google.android.gms.ads.AdValue;

public class AdValueWrapper {
    private final AdValue adValue;
    private String adRevenueUnit;
    private String adRevenueNetwork;
    private String adRevenuePlacement;

    public AdValueWrapper(AdValue adValue) {
        this.adValue = adValue;
    }

    /**
     * The ad's value in micro-units, where 1,000,000 micro-units equal one unit of the currency.
     *
     * @return returns the value of the ad in micro units.For example, a getValueMicros() returned value of 5,000 means the ad is estimated to be worth $0.005.
     */
    public Double getValueMicros() {
        return adValue.getValueMicros() / 1000000D;
    }

    /**
     * @return The value's ISO 4217 currency code.
     */
    public String getCurrencyCode() {
        return adValue.getCurrencyCode();
    }

    /**
     * The precision type of the reported ad value.
     *
     * @return UNKNOWN:An ad value that's unknown. This gets returned when LTV pingback is enabled but there isn't enough data available.
     * ESTIMATED:An ad value estimated from aggregated data.
     * PUBLISHER_PROVIDED:A publisher provided ad value, such as manual CPMs in a mediation group.
     * PRECISE:The precise value paid for this ad.
     */
    public int getPrecisionType() {
        return adValue.getPrecisionType();
    }


    public String getAdRevenueUnit() {
        return adRevenueUnit;
    }

    /**
     * You can record the type of ad (ad unit) that the user interacted with.
     *
     * @param adRevenueUnit ad unit id
     */
    public void setAdRevenueUnit(String adRevenueUnit) {
        this.adRevenueUnit = adRevenueUnit;
    }

    public String getAdRevenueNetwork() {
        return adRevenueNetwork;
    }

    /**
     * You can record the name of the network an ad belongs to.
     *
     * @param adRevenueNetwork the name of the network an ad belongs to.
     */
    public void setAdRevenueNetwork(String adRevenueNetwork) {
        this.adRevenueNetwork = adRevenueNetwork;
    }

    public String getAdRevenuePlacement() {
        return adRevenuePlacement;
    }

    /**
     * You can record the placement of the ad unit the user interacted with.
     *
     * @param adRevenuePlacement placement of the ad uni
     */
    public void setAdRevenuePlacement(String adRevenuePlacement) {
        this.adRevenuePlacement = adRevenuePlacement;
    }
}
