/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.ad;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.ads.mediationtestsuite.MediationTestSuite;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.RequestConfiguration;
import com.google.android.gms.ads.initialization.AdapterStatus;
import com.transsion.ad.data.Scenes;
import com.transsion.ad.data.ScenesConfig;
import com.transsion.ad.util.AdEvent;
import com.transsion.ad.util.AdLog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class AdConfigManager {
    private static final String TAG = "ad_sd_log_AdConfigManager";
    public static final int AD_TYPE_NATIVE = 1;
    public static final int AD_TYPE_INTERSTITIAL = 2;
    public static final int AD_TYPE_BANNER = 3;
    public static final int AD_TYPE_OPEN = 4;
    public static final int AD_TYPE_REWARDED = 5;
    public static final int AD_TYPE_REWARDED_INTERSTITIAL = 6;
    private static boolean AD_SDK_INIT = false;
    private final ScenesConfig mAdScenesConfig = new ScenesConfig();
    private final ScenesConfig mBackupAdConfig = new ScenesConfig();
    private final Map<Integer, Scenes> mDefaultScenes = new HashMap<Integer, Scenes>();
    private final List<ActivityStartedInterface> mActivityStartedInterface = new ArrayList<ActivityStartedInterface>();
    private final List<ActivityStoppedInterface> mActivityStoppedInterface = new ArrayList<ActivityStoppedInterface>();
    private final AtomicInteger foreground = new AtomicInteger();
    private final LinkedList<Activity> activityList = new LinkedList();
    private final LinkedList<Activity> adActivityList = new LinkedList();

    private AdConfigManager() {
    }

    public static void init(Application application, @NonNull Builder builder) {
        AdLog.setLogPrint(builder.isLogDebug());
        AdEvent.getInstance().setAdEventCallBack(builder.getAdEventCallBack());
        AdEvent.getInstance().setAdjustEventCallBack(builder.getAdjustEventCallBack());
        Set<Map.Entry<Integer, Scenes>> sceneSet = builder.getDefaultAd().entrySet();
        for (Map.Entry<Integer, Scenes> scenesEntry : sceneSet) {
            AdConfigManager.getInstance().mDefaultScenes.put(scenesEntry.getKey(), scenesEntry.getValue());
        }
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new ActivityLifecycleCallbacks(builder));
        if (builder.isInitSdk()) {
            AdConfigManager.initSdk((Context)application);
        }
        if (!TextUtils.isEmpty((CharSequence)builder.getTestDeviceIds())) {
            AdConfigManager.getInstance().setTestDeviceIds(builder.getTestDeviceIds());
        }
    }

    public static AdConfigManager getInstance() {
        return AdAdConfigManagerHolder.sInstance;
    }

    public ScenesConfig getAdConfig(boolean backup) {
        return backup ? this.mAdScenesConfig : this.mBackupAdConfig;
    }

    public boolean sdkInitialized() {
        return AD_SDK_INIT;
    }

    @NonNull
    public Scenes getBackupScenes(int adType) {
        if (this.mBackupAdConfig.getScenes() == null) {
            return this.defaultBackupScenes(adType);
        }
        for (Scenes scenes : this.mBackupAdConfig.getScenes()) {
            if (scenes.getAdType() != adType) continue;
            scenes.setBackup(true);
            return scenes;
        }
        return this.defaultBackupScenes(adType);
    }

    private Scenes defaultBackupScenes(int adType) {
        Scenes scenes = this.mDefaultScenes.get(adType);
        AdLog.i(TAG, "default backup scenes:" + scenes);
        if (scenes == null) {
            throw new NullPointerException("adId can not be null, must be set default adId by type");
        }
        return scenes;
    }

    @NonNull
    public Scenes getScenesById(int scenesId, int adType) {
        if (this.mAdScenesConfig.getScenes() == null) {
            Scenes scenes = new Scenes();
            scenes.setScenesId(-1);
            return scenes;
        }
        for (Scenes scenes : this.mAdScenesConfig.getScenes()) {
            if (scenes.getScenesId() != scenesId || scenes.getAdType() != adType || TextUtils.isEmpty((CharSequence)scenes.getAdId())) continue;
            return scenes;
        }
        Scenes scenes = new Scenes();
        scenes.setScenesId(-2);
        return scenes;
    }

    public void launchTestSuite(Context context) {
        MediationTestSuite.launch((Context)context);
    }

    public void updateData(ScenesConfig newData, boolean backup) {
        if (backup) {
            this.mBackupAdConfig.setScenes(newData.getScenes());
        } else {
            this.mAdScenesConfig.setScenes(newData.getScenes());
        }
    }

    public static void initSdk(Context context) {
        if (AD_SDK_INIT) {
            return;
        }
        AdLog.i(TAG, "MobileAds init:" + MobileAds.getVersion());
        AD_SDK_INIT = true;
        long time = System.currentTimeMillis();
        MobileAds.initialize((Context)context, initializationStatus -> {
            Map adapterStatus = initializationStatus.getAdapterStatusMap();
            Set adapterStatusSet = adapterStatus.entrySet();
            StringBuilder sb = new StringBuilder();
            for (Map.Entry statusEntry : adapterStatusSet) {
                String description = ((AdapterStatus)statusEntry.getValue()).getDescription();
                String key = (String)statusEntry.getKey();
                AdLog.i(TAG, "key:" + key + "; description:" + description);
                if (TextUtils.isEmpty((CharSequence)description) || TextUtils.isEmpty((CharSequence)key)) continue;
                int lastIndex = key.lastIndexOf(".");
                sb.append(key.substring(lastIndex + 1)).append(":").append(description);
            }
            if (sb.length() <= 0) {
                return;
            }
            String reason = sb.length() > 100 ? sb.substring(0, 100) : sb.toString();
            AdLog.e(TAG, "ad init error:" + sb);
            Bundle bundle = new Bundle();
            bundle.putString("reason", reason);
            bundle.putLong("duration", System.currentTimeMillis() - time);
            AdEvent.Event event = new AdEvent.Event();
            event.bundle = bundle;
            event.name = "ad_init";
            AdEvent.getInstance().addEventInfo(event);
        });
    }

    public static void registerWebView(@NonNull WebView webView) {
        MobileAds.registerWebView((WebView)webView);
    }

    private void setTestDeviceIds(String deviceId) {
        List<String> testDeviceIds = Collections.singletonList(deviceId);
        RequestConfiguration configuration = new RequestConfiguration.Builder().setTestDeviceIds(testDeviceIds).build();
        MobileAds.setRequestConfiguration((RequestConfiguration)configuration);
    }

    public void addActivityStartedObserver(ActivityStartedInterface activityStartedInterface) {
        this.mActivityStartedInterface.add(activityStartedInterface);
    }

    public void noticeActivityStartedObserver(@NonNull Activity activity) {
        for (ActivityStartedInterface startedInterface : this.mActivityStartedInterface) {
            startedInterface.onActivityStarted(activity);
        }
    }

    public void addActivityStoppedObserver(ActivityStoppedInterface activityStoppedInterface) {
        this.mActivityStoppedInterface.add(activityStoppedInterface);
    }

    public void noticeActivityStoppedObserver(@NonNull Activity activity) {
        for (ActivityStoppedInterface startedInterface : this.mActivityStoppedInterface) {
            startedInterface.onActivityStopped(activity);
        }
    }

    public boolean isAppForeground() {
        return this.foreground.get() > 0;
    }

    private void incrementAppPage() {
        this.foreground.incrementAndGet();
    }

    private void decrementAppPage() {
        this.foreground.decrementAndGet();
    }

    private void resetForeground() {
        this.foreground.set(0);
    }

    public int getForegroundCount() {
        return this.foreground.get();
    }

    public Activity getValidActivity() {
        return this.activityList.peekLast();
    }

    public Activity getAdActivity() {
        return this.adActivityList.peek();
    }

    public List<Activity> getAdActivities() {
        return this.adActivityList;
    }

    private boolean isAdActivity(@NonNull Activity activity) {
        String localClassName = activity.getLocalClassName();
        if (TextUtils.isEmpty((CharSequence)localClassName)) {
            return false;
        }
        return localClassName.startsWith("com.google.android.gms.ads.AdActivity") || localClassName.startsWith("com.bytedance.sdk.openadsdk.activity") || localClassName.startsWith("com.applovin.adview") || localClassName.startsWith("com.facebook.ads");
    }

    public static class Builder {
        private boolean logDebug;
        private boolean initSdk;
        private AdEvent.AdEventCallBack adEventCallBack;
        private AdEvent.AdjustEventCallBack adjustEventCallBack;
        private final Map<Integer, Scenes> defaultAd = new HashMap<Integer, Scenes>();
        private String deviceId;

        public boolean isLogDebug() {
            return this.logDebug;
        }

        public void setLogDebug(boolean logDebug) {
            this.logDebug = logDebug;
        }

        public boolean isInitSdk() {
            return this.initSdk;
        }

        public void setInitSdk(boolean initSdk) {
            this.initSdk = initSdk;
        }

        public void addDefaultScenes(String adId, int adType) {
            Scenes scenes = new Scenes();
            scenes.setScenesId(0);
            scenes.setAdType(adType);
            scenes.setBackup(true);
            scenes.setAdId(adId);
            this.defaultAd.put(adType, scenes);
        }

        public Map<Integer, Scenes> getDefaultAd() {
            return this.defaultAd;
        }

        public AdEvent.AdEventCallBack getAdEventCallBack() {
            return this.adEventCallBack;
        }

        public void setAdEventCallBack(AdEvent.AdEventCallBack adEventCallBack) {
            this.adEventCallBack = adEventCallBack;
        }

        public AdEvent.AdjustEventCallBack getAdjustEventCallBack() {
            return this.adjustEventCallBack;
        }

        public void setAdjustEventCallBack(AdEvent.AdjustEventCallBack adjustEventCallBack) {
            this.adjustEventCallBack = adjustEventCallBack;
        }

        public void setTestDeviceIds(String deviceId) {
            this.deviceId = deviceId;
        }

        public String getTestDeviceIds() {
            return this.deviceId;
        }
    }

    private static class ActivityLifecycleCallbacks
    implements Application.ActivityLifecycleCallbacks {
        private final Builder builder;

        public ActivityLifecycleCallbacks(Builder builder) {
            this.builder = builder;
        }

        public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
            AdConfigManager.getInstance().activityList.add(activity);
            if (AdConfigManager.getInstance().isAdActivity(activity)) {
                AdConfigManager.getInstance().adActivityList.add(activity);
            }
        }

        public void onActivityStarted(@NonNull Activity activity) {
            AdConfigManager.getInstance().incrementAppPage();
            AdConfigManager.getInstance().noticeActivityStartedObserver(activity);
        }

        public void onActivityResumed(@NonNull Activity activity) {
        }

        public void onActivityPaused(@NonNull Activity activity) {
        }

        public void onActivityStopped(@NonNull Activity activity) {
            AdConfigManager.getInstance().decrementAppPage();
            AdConfigManager.getInstance().noticeActivityStoppedObserver(activity);
        }

        public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
        }

        public void onActivityDestroyed(@NonNull Activity activity) {
            AdConfigManager.getInstance().activityList.remove(activity);
            if (AdConfigManager.getInstance().isAdActivity(activity)) {
                AdConfigManager.getInstance().adActivityList.remove(activity);
            }
            if (!AdConfigManager.getInstance().isAppForeground()) {
                AdConfigManager.getInstance().resetForeground();
            }
        }
    }

    private static final class AdAdConfigManagerHolder {
        private static final AdConfigManager sInstance = new AdConfigManager();

        private AdAdConfigManagerHolder() {
        }
    }

    public static interface ActivityStartedInterface {
        public void onActivityStarted(@NonNull Activity var1);
    }

    public static interface ActivityStoppedInterface {
        public void onActivityStopped(@NonNull Activity var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NativeAdViewType {
        public static final int TYPE_NATIVE_AD_DEFAULT = 0;
        public static final int TYPE_NATIVE_AD_BIG = 1;
        public static final int TYPE_NATIVE_AD_SMALL = 2;
    }
}

