/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.ad;

import android.os.HandlerThread;
import android.os.Message;
import androidx.annotation.Nullable;
import com.transsion.ad.interstitialad.InterstitialAdListener;
import com.transsion.ad.interstitialad.InterstitialAdLoader;
import com.transsion.ad.nativead.NativeAdListener;
import com.transsion.ad.nativead.NativeAdLoader;
import com.transsion.ad.sdk.DispatcherLoaderTaskHandler;

public class AdLoaderManger {
    private static final String TAG = "ad_sd_log_AdLoaderManger";
    private final DispatcherLoaderTaskHandler mTaskHandler;

    private AdLoaderManger() {
        HandlerThread handlerThread = new HandlerThread("load_task_thread");
        handlerThread.start();
        this.mTaskHandler = new DispatcherLoaderTaskHandler(handlerThread.getLooper());
    }

    public static AdLoaderManger getInstance() {
        return AdLoaderMangerHolder.instance;
    }

    public void addNativeAdLoaderRequest(int scenesId, boolean force, @Nullable NativeAdListener listener) {
        Message msg = this.mTaskHandler.obtainMessage();
        msg.what = 0;
        msg.arg1 = scenesId;
        msg.arg2 = force ? 1 : 0;
        msg.obj = listener;
        msg.sendToTarget();
    }

    public void addInterstitialAdLoaderRequest(int scenesId, boolean force, @Nullable InterstitialAdListener listener) {
        Message msg = this.mTaskHandler.obtainMessage();
        msg.what = 1;
        msg.arg1 = scenesId;
        msg.arg2 = force ? 1 : 0;
        msg.obj = listener;
        msg.sendToTarget();
    }

    public void addBackupNativeAdLoaderRequest(boolean force, @Nullable NativeAdListener listener) {
        Message msg = this.mTaskHandler.obtainMessage();
        msg.what = 2;
        msg.arg2 = force ? 1 : 0;
        msg.obj = listener;
        msg.sendToTarget();
    }

    public void addBackupInterstitialAdLoaderRequest(boolean force, @Nullable InterstitialAdListener listener) {
        Message msg = this.mTaskHandler.obtainMessage();
        msg.what = 3;
        msg.arg2 = force ? 1 : 0;
        msg.obj = listener;
        msg.sendToTarget();
    }

    public void destroy(NativeAdListener listener, NativeAdLoader ... loaders) {
        Message msg = this.mTaskHandler.obtainMessage();
        msg.what = 4;
        msg.obj = listener;
        msg.sendToTarget();
        if (loaders == null) {
            return;
        }
        for (NativeAdLoader loader : loaders) {
            if (loader == null) break;
            loader.destroy();
        }
    }

    public void destroy(InterstitialAdListener listener, InterstitialAdLoader ... loaders) {
        Message msg = this.mTaskHandler.obtainMessage();
        msg.what = 5;
        msg.obj = listener;
        msg.sendToTarget();
        if (loaders == null) {
            return;
        }
        for (InterstitialAdLoader loader : loaders) {
            if (loader == null) break;
            loader.destroy();
        }
    }

    private static class AdLoaderMangerHolder {
        private static final AdLoaderManger instance = new AdLoaderManger();

        private AdLoaderMangerHolder() {
        }
    }
}

