/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.ad.interstitialad;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdapterResponseInfo;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.transsion.ad.data.Scenes;
import com.transsion.ad.interstitialad.InterstitialAdListener;
import com.transsion.ad.sdk.AbstractAdLoader;
import com.transsion.ad.sdk.LoaderCache;
import com.transsion.ad.sdk.wrap.AdErrorWrapper;
import com.transsion.ad.sdk.wrap.AdValueWrapper;
import com.transsion.ad.util.AdEvent;
import com.transsion.ad.util.AdLog;

public class InterstitialAdLoader
extends AbstractAdLoader<InterstitialAdListener> {
    private InterstitialAd interstitialAd;
    private final FullScreenContentCallback fullScreenContentCallback = new FullScreenContentCallback(){

        public void onAdClicked() {
            if (InterstitialAdLoader.this.listener != null) {
                ((InterstitialAdListener)InterstitialAdLoader.this.listener).onClicked(InterstitialAdLoader.this);
            }
        }

        public void onAdDismissedFullScreenContent() {
            super.onAdDismissedFullScreenContent();
            if (InterstitialAdLoader.this.listener != null) {
                ((InterstitialAdListener)InterstitialAdLoader.this.listener).onClosed(InterstitialAdLoader.this);
            }
        }

        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
            super.onAdFailedToShowFullScreenContent(adError);
            if (InterstitialAdLoader.this.listener != null) {
                ((InterstitialAdListener)InterstitialAdLoader.this.listener).onAdFailedToShowFullScreenContent(InterstitialAdLoader.this, new AdErrorWrapper(adError));
            }
        }

        public void onAdImpression() {
            super.onAdImpression();
            if (InterstitialAdLoader.this.listener != null) {
                ((InterstitialAdListener)InterstitialAdLoader.this.listener).onShow(InterstitialAdLoader.this);
            }
        }

        public void onAdShowedFullScreenContent() {
            super.onAdShowedFullScreenContent();
            if (InterstitialAdLoader.this.listener != null) {
                ((InterstitialAdListener)InterstitialAdLoader.this.listener).onAdShowedFullScreenContent(InterstitialAdLoader.this);
            }
        }
    };

    public InterstitialAdLoader(Scenes scenes) {
        super(scenes);
    }

    @Override
    public void loadAd(InterstitialAdListener listener) {
        this.listener = listener;
        this.load(false, false);
    }

    @Override
    public void preloadAd(boolean force, InterstitialAdListener listener) {
        this.listener = listener;
        this.load(force, true);
    }

    @Override
    public boolean isExpired(boolean show) {
        return this.interstitialAd == null || super.isExpired(show);
    }

    @Override
    protected void cacheLoaded() {
        if (this.listener != null) {
            ((InterstitialAdListener)this.listener).onLoaded(this);
        }
    }

    @Override
    protected void loadRequest() {
        Context context = this.getContext();
        if (context == null) {
            AdLog.e(this.TAG, "end load, context is null");
            return;
        }
        AdRequest adRequest = new AdRequest.Builder().build();
        InterstitialAd.load((Context)context.getApplicationContext(), (String)this.scenes.getAdId(), (AdRequest)adRequest, (InterstitialAdLoadCallback)new InterstitialAdLoadCallback(){

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                if (InterstitialAdLoader.this.listener != null) {
                    ((InterstitialAdListener)InterstitialAdLoader.this.listener).onError(InterstitialAdLoader.this, new AdErrorWrapper((AdError)loadAdError));
                }
            }

            public void onAdLoaded(@NonNull InterstitialAd adManagerInterstitialAd) {
                AdapterResponseInfo loadedResponseInfo = adManagerInterstitialAd.getResponseInfo().getLoadedAdapterResponseInfo();
                InterstitialAdLoader.this.responseInfo = loadedResponseInfo != null ? loadedResponseInfo.toString() : null;
                InterstitialAdLoader.this.interstitialAd = adManagerInterstitialAd;
                InterstitialAdLoader.this.time = System.currentTimeMillis();
                Bundle extras = adManagerInterstitialAd.getResponseInfo().getResponseExtras();
                String mediationGroupName = extras.getString("mediation_group_name");
                String sourceName = loadedResponseInfo != null ? loadedResponseInfo.getAdSourceName() : null;
                adManagerInterstitialAd.setOnPaidEventListener(adValue -> {
                    AdLog.d(InterstitialAdLoader.this.TAG, "paid event valueMicros:" + adValue.getValueMicros() + "; currencyCode:" + adValue.getCurrencyCode() + "; precisionType:" + adValue.getPrecisionType() + "; loader:" + InterstitialAdLoader.this);
                    AdValueWrapper adValueWrapper = new AdValueWrapper(adValue);
                    adValueWrapper.setAdRevenueUnit(InterstitialAdLoader.this.getScenes().getAdId());
                    adValueWrapper.setAdRevenueNetwork(sourceName);
                    adValueWrapper.setAdRevenuePlacement(mediationGroupName);
                    AdEvent.getInstance().sendAdRevenueInfoToAdjust(adValueWrapper);
                });
                LoaderCache.getInstance().putInterstitialAdLoaderInCache(InterstitialAdLoader.this, InterstitialAdLoader.this.scenes.getAdId());
                if (InterstitialAdLoader.this.listener != null) {
                    ((InterstitialAdListener)InterstitialAdLoader.this.listener).onLoaded(InterstitialAdLoader.this);
                }
            }
        });
    }

    @Override
    protected boolean noCacheHandled() {
        if (this.listener != null) {
            return ((InterstitialAdListener)this.listener).onCacheInvalid(this);
        }
        return super.noCacheHandled();
    }

    @Override
    public String getSubResponseInfo() {
        if (this.responseInfo != null && this.responseInfo.length() > 100) {
            return this.responseInfo.substring(0, 100);
        }
        return this.responseInfo;
    }

    public boolean show(Activity activity) {
        LoaderCache.getInstance().removeInterstitialAdLoaderCache(this, this.scenes.getAdId());
        if (this.isShowed) {
            return false;
        }
        this.interstitialAd.setFullScreenContentCallback(this.fullScreenContentCallback);
        this.interstitialAd.show(activity);
        this.isShowed = true;
        return true;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.isShowed) {
            if (this.interstitialAd != null) {
                this.interstitialAd = null;
            }
        } else if (!this.isExpired(false)) {
            LoaderCache.getInstance().putInterstitialAdLoaderInCache(this, this.scenes.getAdId());
        }
    }

    @Override
    protected String getClassName() {
        return "InterstitialAdLoader";
    }
}

