/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.ad.nativead;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.bumptech.glide.Glide;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdapterResponseInfo;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.formats.AdManagerAdViewOptions;
import com.google.android.gms.ads.nativead.MediaView;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdOptions;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.google.android.gms.ads.nativead.NativeCustomFormatAd;
import com.transsion.ad.R;
import com.transsion.ad.data.Scenes;
import com.transsion.ad.nativead.NativeAdListener;
import com.transsion.ad.sdk.AbstractAdLoader;
import com.transsion.ad.sdk.LoaderCache;
import com.transsion.ad.sdk.wrap.AdErrorWrapper;
import com.transsion.ad.sdk.wrap.AdValueWrapper;
import com.transsion.ad.sdk.wrap.NativeAdWrapper;
import com.transsion.ad.sdk.wrap.NativeCustomFormatAdWrapper;
import com.transsion.ad.util.AdEvent;
import com.transsion.ad.util.AdLog;

public class NativeAdLoader
extends AbstractAdLoader<NativeAdListener> {
    private static final String SIMPLE_TEMPLATE_ID = "10104090";
    private NativeAdOptions adOptions;
    private AdManagerAdViewOptions adViewOptions;
    private NativeCustomFormatAd nativeCustomFormatAd;
    private boolean requestNativeAd;
    private boolean requestCustomFormatAd;
    private int maxNumberOfAds;
    private NativeAd nativeAd;

    public NativeAdLoader(Scenes scenes) {
        super(scenes);
    }

    @Override
    public void loadAd(NativeAdListener listener) {
        this.listener = listener;
        this.load(false, true, false, false, 0);
    }

    @Override
    public void preloadAd(boolean force, NativeAdListener listener) {
        this.listener = listener;
        this.load(force, true, false, true, 0);
    }

    public void loadAds(NativeAdListener listener, int maxNumberOfAds) {
        this.listener = listener;
        this.load(false, true, false, false, maxNumberOfAds);
    }

    public void loadCustomAd(NativeAdListener listener) {
        this.listener = listener;
        this.load(false, false, true, false, 0);
    }

    private void load(boolean force, boolean requestNativeAd, boolean requestCustomFormatAd, boolean preload, int maxNumberOfAds) {
        AdLog.i(this.TAG, "native ad; requestNativeAd = " + requestNativeAd + " preload = " + preload + " maxNumberOfAds = " + maxNumberOfAds);
        this.requestNativeAd = requestNativeAd;
        this.requestCustomFormatAd = requestCustomFormatAd;
        this.maxNumberOfAds = maxNumberOfAds;
        this.load(force, preload);
    }

    @Override
    public boolean isExpired(boolean show) {
        return this.nativeAd == null && this.nativeCustomFormatAd == null || super.isExpired(show);
    }

    @Override
    protected void cacheLoaded() {
        if (this.listener != null) {
            ((NativeAdListener)this.listener).onLoaded(this);
        }
    }

    @Override
    protected boolean noCacheHandled() {
        if (this.listener != null) {
            return ((NativeAdListener)this.listener).onCacheInvalid(this);
        }
        return super.noCacheHandled();
    }

    @Override
    protected void loadRequest() {
        Context context = this.getContext();
        if (context == null) {
            AdLog.e(this.TAG, "end load, context is null");
            return;
        }
        AdLoader.Builder builder = new AdLoader.Builder(context.getApplicationContext(), this.scenes.getAdId());
        if (this.requestNativeAd) {
            this.nativeAdLoad(builder);
        }
        if (this.requestCustomFormatAd) {
            this.customFormatAdLoad(builder);
        }
        this.withAdListener(builder);
        if (this.adOptions != null) {
            builder.withNativeAdOptions(this.adOptions);
        }
        if (this.adViewOptions != null) {
            builder.withAdManagerAdViewOptions(this.adViewOptions);
        }
        AdLoader adLoader = builder.build();
        AdRequest adRequest = new AdRequest.Builder().build();
        if (this.maxNumberOfAds > 0) {
            adLoader.loadAds(adRequest, this.maxNumberOfAds);
        } else {
            adLoader.loadAd(adRequest);
        }
    }

    private void nativeAdLoad(@NonNull AdLoader.Builder builder) {
        builder.forNativeAd(nativeAd -> {
            AdapterResponseInfo loadedResponseInfo = nativeAd.getResponseInfo() != null ? nativeAd.getResponseInfo().getLoadedAdapterResponseInfo() : null;
            this.responseInfo = loadedResponseInfo != null ? loadedResponseInfo.toString() : null;
            String responseInfoStr = loadedResponseInfo != null ? loadedResponseInfo.getAdSourceName() : "loadedResponseInfo is null";
            this.nativeAd = nativeAd;
            this.time = System.currentTimeMillis();
            Bundle extras = nativeAd.getResponseInfo().getResponseExtras();
            String mediationGroupName = extras.getString("mediation_group_name");
            String sourceName = responseInfoStr;
            nativeAd.setOnPaidEventListener(adValue -> {
                AdLog.d(this.TAG, "paid event valueMicros:" + adValue.getValueMicros() + "; currencyCode:" + adValue.getCurrencyCode() + "; precisionType:" + adValue.getPrecisionType() + "; loader:" + this);
                AdValueWrapper adValueWrapper = new AdValueWrapper(adValue);
                adValueWrapper.setAdRevenueUnit(this.getScenes().getAdId());
                adValueWrapper.setAdRevenueNetwork(sourceName);
                adValueWrapper.setAdRevenuePlacement(mediationGroupName);
                AdEvent.getInstance().sendAdRevenueInfoToAdjust(adValueWrapper);
            });
            LoaderCache.getInstance().putNativeAdLoaderInCache(this, this.scenes.getAdId());
            if (this.listener != null) {
                ((NativeAdListener)this.listener).onNativeAdLoaded(this, new NativeAdWrapper(nativeAd));
            }
        });
    }

    private void customFormatAdLoad(@NonNull AdLoader.Builder builder) {
        builder.forCustomFormatAd(SIMPLE_TEMPLATE_ID, nativeCustomFormatAd -> {
            this.nativeCustomFormatAd = nativeCustomFormatAd;
            if (this.listener != null) {
                ((NativeAdListener)this.listener).onCustomFormatAdLoaded(this, new NativeCustomFormatAdWrapper(nativeCustomFormatAd));
            }
        }, (nativeCustomFormatAd, s) -> {
            if (this.listener != null) {
                ((NativeAdListener)this.listener).onCustomClick(this, new NativeCustomFormatAdWrapper(nativeCustomFormatAd), s);
            }
        });
    }

    private void withAdListener(@NonNull AdLoader.Builder builder) {
        builder.withAdListener(new AdListener(){

            public void onAdClicked() {
                if (NativeAdLoader.this.listener != null) {
                    ((NativeAdListener)NativeAdLoader.this.listener).onClicked(NativeAdLoader.this);
                }
            }

            public void onAdClosed() {
                if (NativeAdLoader.this.listener != null) {
                    ((NativeAdListener)NativeAdLoader.this.listener).onClosed(NativeAdLoader.this);
                }
            }

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                if (NativeAdLoader.this.listener != null) {
                    ((NativeAdListener)NativeAdLoader.this.listener).onError(NativeAdLoader.this, new AdErrorWrapper((AdError)loadAdError));
                }
            }

            public void onAdImpression() {
                if (NativeAdLoader.this.listener != null) {
                    ((NativeAdListener)NativeAdLoader.this.listener).onShow(NativeAdLoader.this);
                }
            }

            public void onAdLoaded() {
                if (NativeAdLoader.this.listener != null) {
                    ((NativeAdListener)NativeAdLoader.this.listener).onLoaded(NativeAdLoader.this);
                }
            }

            public void onAdOpened() {
                if (NativeAdLoader.this.listener != null) {
                    ((NativeAdListener)NativeAdLoader.this.listener).onOpened(NativeAdLoader.this);
                }
            }
        });
    }

    @Override
    public String getSubResponseInfo() {
        if (this.responseInfo != null && this.responseInfo.length() > 100) {
            return this.responseInfo.substring(0, 100);
        }
        return this.responseInfo;
    }

    public boolean bindAdView(@NonNull ViewGroup root) {
        return this.bindAdView(root, 0);
    }

    public boolean bindAdView(@NonNull ViewGroup root, int type) {
        root.removeAllViews();
        LoaderCache.getInstance().removeNativeAdLoaderCache(this, this.scenes.getAdId());
        if (this.nativeAd != null) {
            NativeAdView adView;
            switch (type) {
                case 1: {
                    adView = (NativeAdView)LayoutInflater.from((Context)root.getContext()).inflate(R.layout.native_ad_layout_big, root).findViewById(R.id.native_ad_view_container);
                    break;
                }
                case 2: {
                    adView = (NativeAdView)LayoutInflater.from((Context)root.getContext()).inflate(R.layout.native_ad_layout_small, root).findViewById(R.id.native_ad_view_container);
                    break;
                }
                default: {
                    adView = (NativeAdView)LayoutInflater.from((Context)root.getContext()).inflate(R.layout.native_ad_layout, root).findViewById(R.id.native_ad_view_container);
                }
            }
            this.populateNativeAdView(this.nativeAd, adView, type);
            this.isShowed = true;
            return true;
        }
        if (this.nativeCustomFormatAd != null) {
            View adView = LayoutInflater.from((Context)root.getContext()).inflate(R.layout.ad_simple_custom_template, root, false);
            this.populateSimpleTemplateAdView(this.nativeCustomFormatAd, adView);
            root.addView(adView);
            this.isShowed = true;
            return true;
        }
        return false;
    }

    private void populateNativeAdView(NativeAd nativeAd, NativeAdView adView, int type) {
        ImageView iconView = (ImageView)adView.findViewById(R.id.ad_app_icon);
        TextView headline = (TextView)adView.findViewById(R.id.ad_headline);
        TextView adBody = (TextView)adView.findViewById(R.id.ad_body);
        MediaView mediaView = (MediaView)adView.findViewById(R.id.ad_media);
        TextView action = (TextView)adView.findViewById(R.id.ad_call_to_action);
        adView.setMediaView(mediaView);
        adView.setHeadlineView((View)headline);
        adView.setBodyView((View)adBody);
        adView.setCallToActionView((View)action);
        adView.setIconView((View)iconView);
        if (headline != null) {
            headline.setText((CharSequence)nativeAd.getHeadline());
        }
        if (mediaView != null) {
            mediaView.setMediaContent(nativeAd.getMediaContent());
        }
        if (nativeAd.getBody() == null) {
            adBody.setVisibility(4);
        } else {
            adBody.setVisibility(0);
            adBody.setText((CharSequence)nativeAd.getBody());
        }
        if (nativeAd.getCallToAction() == null) {
            action.setVisibility(4);
        } else {
            action.setVisibility(0);
            action.setText((CharSequence)nativeAd.getCallToAction());
        }
        NativeAd.Image icon = nativeAd.getIcon();
        if (icon != null) {
            if (icon.getDrawable() != null) {
                iconView.setVisibility(0);
                Glide.with((View)iconView).load(icon.getDrawable()).into(iconView);
            } else if (icon.getUri() != null) {
                iconView.setVisibility(0);
                Glide.with((View)iconView).load(icon.getUri()).into(iconView);
            } else {
                iconView.setVisibility(8);
            }
        } else if (type == 2) {
            iconView.setVisibility(0);
            iconView.setImageResource(R.drawable.icon_default);
        } else {
            iconView.setVisibility(8);
        }
        adView.setNativeAd(nativeAd);
        VideoController vc = nativeAd.getMediaContent().getVideoController();
        if (vc.hasVideoContent()) {
            vc.setVideoLifecycleCallbacks(new VideoController.VideoLifecycleCallbacks(){

                public void onVideoEnd() {
                    super.onVideoEnd();
                }
            });
        }
    }

    private void populateSimpleTemplateAdView(final NativeCustomFormatAd nativeCustomFormatAd, View adView) {
        TextView headline = (TextView)adView.findViewById(R.id.simplecustom_headline);
        TextView caption = (TextView)adView.findViewById(R.id.simplecustom_caption);
        headline.setText(nativeCustomFormatAd.getText("Headline"));
        caption.setText(nativeCustomFormatAd.getText("Caption"));
        FrameLayout mediaPlaceholder = (FrameLayout)adView.findViewById(R.id.simplecustom_media_placeholder);
        VideoController vc = nativeCustomFormatAd.getVideoController();
        if (vc.hasVideoContent()) {
            mediaPlaceholder.addView((View)nativeCustomFormatAd.getVideoMediaView());
            vc.setVideoLifecycleCallbacks(new VideoController.VideoLifecycleCallbacks(){

                public void onVideoEnd() {
                    super.onVideoEnd();
                }
            });
        } else {
            ImageView mainImage = new ImageView(adView.getContext());
            mainImage.setAdjustViewBounds(true);
            mainImage.setImageDrawable(nativeCustomFormatAd.getImage("MainImage").getDrawable());
            mainImage.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    nativeCustomFormatAd.performClick("MainImage");
                }
            });
            mediaPlaceholder.addView((View)mainImage);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.isShowed) {
            if (this.nativeAd != null) {
                this.nativeAd.destroy();
                this.nativeAd = null;
            }
        } else if (!this.isExpired(false)) {
            LoaderCache.getInstance().putNativeAdLoaderInCache(this, this.scenes.getAdId());
        }
        if (this.nativeCustomFormatAd != null) {
            this.nativeCustomFormatAd.destroy();
            this.nativeCustomFormatAd = null;
        }
    }

    @Override
    protected String getClassName() {
        return "NativeAdLoader";
    }
}

