/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.ad.sdk;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import com.transsion.ad.AdConfigManager;
import com.transsion.ad.data.Scenes;
import com.transsion.ad.sdk.ILoader;
import com.transsion.ad.util.AdLog;

public abstract class AbstractAdLoader<T>
implements ILoader<T> {
    protected final String TAG = "ad_sd_log_" + this.getClassName();
    protected Scenes scenes;
    protected boolean isPreload;
    protected boolean isCache;
    protected boolean isForceLoad;
    protected boolean isShowed;
    protected String responseInfo;
    protected T listener;
    protected long time;

    public AbstractAdLoader(Scenes scenes) {
        this.scenes = scenes;
    }

    protected void load(boolean force, boolean preload) {
        AdLog.i(this.TAG, "start load ad; scenes = " + this.scenes + "; preload = " + preload + "; force: " + force);
        this.isPreload = preload;
        this.isForceLoad = force;
        if (this.isCacheValid()) {
            this.isCache = true;
            AdRequestHandler.getInstance().addCacheTask(this);
            return;
        }
        AdRequestHandler.getInstance().addRequestTask(this);
    }

    @Override
    public Context getContext() {
        return AdConfigManager.getInstance().getValidActivity();
    }

    @Override
    public boolean isPreload() {
        return this.isPreload;
    }

    @Override
    public boolean isCache() {
        return this.isCache;
    }

    @Override
    public boolean isForceLoad() {
        return this.isForceLoad;
    }

    @Override
    public void setScenes(Scenes scenes) {
        this.scenes = scenes;
    }

    @Override
    public Scenes getScenes() {
        return this.scenes;
    }

    @Override
    public String getResponseInfo() {
        return this.getSubResponseInfo();
    }

    @Override
    public boolean isExpired(boolean show) {
        long duration = System.currentTimeMillis() - this.time;
        AdLog.i(this.TAG, "isExpired time:" + duration + "; show:" + show + "; adId:" + this.scenes.getAdId());
        return this.time > 0L && duration >= (long)(show ? 3300000 : 2700000);
    }

    @NonNull
    public String toString() {
        return "{preload:" + this.isPreload + "; cache:" + this.isCache + "; force:" + this.isForceLoad + "; ad showed:" + this.isShowed + "; scenes:" + this.scenes + "}";
    }

    @Override
    public void destroy() {
        AdLog.i(this.TAG, "loader destroyed:" + this);
    }

    protected boolean noCacheHandled() {
        AdLog.i(this.TAG, "no cache, no handle; preload = " + this.isCache + "; scenes = " + this.scenes);
        return false;
    }

    protected boolean isCacheValid() {
        return !this.isForceLoad && !this.isExpired(false);
    }

    protected abstract String getClassName();

    protected abstract void cacheLoaded();

    protected abstract void loadRequest();

    private static class AdRequestHandler
    extends Handler {
        private static final int WHAT_LOAD_REQUEST = 1;
        private static final int WHAT_LOAD_CACHE = 2;

        private AdRequestHandler() {
            super(Looper.getMainLooper());
        }

        public static AdRequestHandler getInstance() {
            return AdRequestHolder.instance;
        }

        public <T> void addRequestTask(AbstractAdLoader<T> loader) {
            Message msg = this.obtainMessage();
            msg.what = 1;
            msg.obj = loader;
            msg.sendToTarget();
        }

        public <T> void addCacheTask(AbstractAdLoader<T> loader) {
            Message msg = this.obtainMessage();
            msg.what = 2;
            msg.obj = loader;
            msg.sendToTarget();
        }

        public void handleMessage(@NonNull Message msg) {
            super.handleMessage(msg);
            AbstractAdLoader loader = (AbstractAdLoader)msg.obj;
            switch (msg.what) {
                case 1: {
                    if (loader.noCacheHandled()) {
                        AdLog.i(loader.TAG, "no cache; preload = " + loader.isPreload + "; scenes = " + loader.scenes);
                        return;
                    }
                    loader.isCache = false;
                    loader.loadRequest();
                    AdLog.i(loader.TAG, "end request; preload = " + loader.isPreload + "; scenes = " + loader.getScenes());
                    break;
                }
                case 2: {
                    loader.cacheLoaded();
                    AdLog.i(loader.TAG, "end cache; preload = " + loader.isPreload + "; scenes = " + loader.getScenes());
                }
            }
        }

        private static class AdRequestHolder {
            private static final AdRequestHandler instance = new AdRequestHandler();

            private AdRequestHolder() {
            }
        }
    }
}

