/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.ad.sdk;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.transsion.ad.AdConfigManager;
import com.transsion.ad.data.Scenes;
import com.transsion.ad.interstitialad.InterstitialAdListener;
import com.transsion.ad.interstitialad.InterstitialAdLoader;
import com.transsion.ad.nativead.NativeAdListener;
import com.transsion.ad.nativead.NativeAdLoader;
import com.transsion.ad.sdk.LoaderCache;
import com.transsion.ad.sdk.wrap.AdErrorWrapper;
import com.transsion.ad.sdk.wrap.NativeAdWrapper;
import com.transsion.ad.sdk.wrap.NativeCustomFormatAdWrapper;
import com.transsion.ad.util.AdEvent;
import com.transsion.ad.util.AdLog;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DispatcherLoaderTaskHandler
extends Handler {
    private static final String TAG = "ad_sd_log_DispatcherLoaderTaskHandler";
    public static final int NATIVE_AD_TASK = 0;
    public static final int INTERSTITIAL_AD_TASK = 1;
    public static final int BACKUP_NATIVE_AD_TASK = 2;
    public static final int BACKUP_INTERSTITIAL_AD_TASK = 3;
    public static final int REMOVE_NATIVE_LISTENER = 4;
    public static final int REMOVE_INTERSTITIAL_LISTENER = 5;
    private final Map<String, LinkedList<NativeAdListener>> mNativeListMap = new ConcurrentHashMap<String, LinkedList<NativeAdListener>>();
    private final Map<String, LinkedList<InterstitialAdListener>> mInterstitialListMap = new ConcurrentHashMap<String, LinkedList<InterstitialAdListener>>();
    private final Map<InterstitialAdListener, InterstitialAdListener> mInterstitialAdListenerMap = new ConcurrentHashMap<InterstitialAdListener, InterstitialAdListener>();
    private final Map<NativeAdListener, NativeAdListener> mNativeAdListenerMap = new ConcurrentHashMap<NativeAdListener, NativeAdListener>();
    private final Handler mainHandler = new TaskMainHandler();

    public DispatcherLoaderTaskHandler(@NonNull Looper looper) {
        super(looper);
    }

    public void handleMessage(@NonNull Message msg) {
        int scenesId = msg.arg1;
        boolean force = msg.arg2 == 1;
        switch (msg.what) {
            case 0: {
                this.loadNativeAd(scenesId, force, (NativeAdListener)msg.obj);
                break;
            }
            case 1: {
                this.loadInterstitialAd(scenesId, force, (InterstitialAdListener)msg.obj);
                break;
            }
            case 2: {
                this.loadBackupNativeAd(force, (NativeAdListener)msg.obj);
                break;
            }
            case 3: {
                this.loadBackupInterstitialAd(force, (InterstitialAdListener)msg.obj);
                break;
            }
            case 4: {
                if (msg.obj == null) break;
                NativeAdListener nativeAdListener = (NativeAdListener)msg.obj;
                Iterator<Map.Entry<NativeAdListener, NativeAdListener>> it = this.mNativeAdListenerMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<NativeAdListener, NativeAdListener> item = it.next();
                    if (!nativeAdListener.equals(item.getValue())) continue;
                    it.remove();
                }
                break;
            }
            case 5: {
                if (msg.obj == null) break;
                InterstitialAdListener interstitialAdListener = (InterstitialAdListener)msg.obj;
                Iterator<Map.Entry<InterstitialAdListener, InterstitialAdListener>> it = this.mInterstitialAdListenerMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<InterstitialAdListener, InterstitialAdListener> item = it.next();
                    if (!interstitialAdListener.equals(item.getValue())) continue;
                    it.remove();
                }
                break;
            }
        }
    }

    private void sendNativeCacheInvalidListener(@NonNull NativeAdListener listener) {
        Message msg = this.mainHandler.obtainMessage();
        msg.what = 0;
        msg.obj = listener;
        msg.sendToTarget();
    }

    private void sendInterstitialCacheInvalidListener(@NonNull InterstitialAdListener listener) {
        Message msg = this.mainHandler.obtainMessage();
        msg.what = 1;
        msg.obj = listener;
        msg.sendToTarget();
    }

    private void loadBackupNativeAd(boolean force, NativeAdListener listener) {
        Scenes scenes = AdConfigManager.getInstance().getBackupScenes(1);
        if (listener != null) {
            this.loadNativeAd(scenes, listener);
        } else {
            this.preloadBackupAd(1, force);
        }
    }

    private void loadNativeAd(int scenesId, boolean force, NativeAdListener listener) {
        Scenes scenes = AdConfigManager.getInstance().getScenesById(scenesId, 1);
        if (scenes.getScenesId() < 0) {
            if (scenes.getScenesId() == -1) {
                AdLog.e(TAG, "native ad id no cache" + scenesId);
            } else {
                AdLog.e(TAG, "native ad id and scenesId do not match:" + scenesId);
                this.adMatchEvent(scenesId, 1);
            }
            if (listener == null) {
                return;
            }
            this.sendNativeCacheInvalidListener(listener);
            return;
        }
        if (listener != null) {
            this.loadNativeAd(scenes, listener);
        } else {
            this.preloadNativeAd(scenes, force);
        }
    }

    private void loadNativeAd(Scenes scenes, NativeAdListener listener) {
        this.adRequestEvent(scenes.getAdId(), 1, "load");
        this.addNativeAdListenerObserver(scenes.getAdId(), listener);
        NativeAdLoader loader = LoaderCache.getInstance().getNativeAdLoaderFromCache(scenes.getAdId(), false);
        if (loader != null) {
            loader.setScenes(scenes);
        } else {
            loader = new NativeAdLoader(scenes);
        }
        loader.loadAd(new NativeRequestListener(this, scenes.getAdId()));
    }

    private void preloadNativeAd(@NonNull Scenes scenes, boolean force) {
        NativeAdLoader loader;
        this.adRequestEvent(scenes.getAdId(), 1, "preload");
        NativeAdLoader nativeAdLoader = loader = force ? null : LoaderCache.getInstance().getNativeAdLoaderFromCache(scenes.getAdId(), true);
        if (loader != null) {
            loader.setScenes(scenes);
        } else {
            loader = new NativeAdLoader(scenes);
        }
        loader.preloadAd(force, new NativeRequestListener(this, scenes.getAdId()));
    }

    private void loadBackupInterstitialAd(boolean force, InterstitialAdListener listener) {
        Scenes scenes = AdConfigManager.getInstance().getBackupScenes(2);
        if (listener != null) {
            this.loadInterstitialAd(scenes, listener);
        } else {
            this.preloadBackupAd(2, force);
        }
    }

    private void loadInterstitialAd(int scenesId, boolean force, InterstitialAdListener listener) {
        Scenes scenes = AdConfigManager.getInstance().getScenesById(scenesId, 2);
        if (scenes.getScenesId() < 0) {
            if (scenes.getScenesId() == -1) {
                AdLog.e(TAG, "interstitial ad id no cache" + scenesId);
            } else {
                AdLog.e(TAG, "interstitial ad id and scenesId do not match:" + scenesId);
                this.adMatchEvent(scenesId, 2);
            }
            if (listener == null) {
                return;
            }
            this.sendInterstitialCacheInvalidListener(listener);
            return;
        }
        if (listener != null) {
            this.loadInterstitialAd(scenes, listener);
        } else {
            this.preloadInterstitialAd(scenes, force);
        }
    }

    private void loadInterstitialAd(Scenes scenes, InterstitialAdListener listener) {
        this.adRequestEvent(scenes.getAdId(), 2, "load");
        this.addInterstitialAdListenerObserver(scenes.getAdId(), listener);
        InterstitialAdLoader loader = LoaderCache.getInstance().getInterstitialAdLoaderFromCache(scenes.getAdId(), false);
        if (loader != null) {
            loader.setScenes(scenes);
        } else {
            loader = new InterstitialAdLoader(scenes);
        }
        loader.loadAd(new InterstitialRequestListener(this, scenes.getAdId()));
    }

    private void preloadInterstitialAd(Scenes scenes, boolean force) {
        InterstitialAdLoader loader;
        this.adRequestEvent(scenes.getAdId(), 2, "preload");
        InterstitialAdLoader interstitialAdLoader = loader = force ? null : LoaderCache.getInstance().getInterstitialAdLoaderFromCache(scenes.getAdId(), true);
        if (loader != null) {
            loader.setScenes(scenes);
        } else {
            loader = new InterstitialAdLoader(scenes);
        }
        loader.preloadAd(force, new InterstitialRequestListener(this, scenes.getAdId()));
    }

    private void preloadBackupAd(int adType, boolean force) {
        Scenes scenes = AdConfigManager.getInstance().getBackupScenes(adType);
        switch (adType) {
            case 2: {
                this.preloadInterstitialAd(scenes, force);
                break;
            }
            case 1: {
                this.preloadNativeAd(scenes, force);
            }
        }
    }

    private void addNativeAdListenerObserver(String adId, NativeAdListener listener) {
        LinkedList<NativeAdListener> listenerList = this.mNativeListMap.get(adId);
        if (listenerList == null) {
            listenerList = new LinkedList();
            this.mNativeListMap.put(adId, listenerList);
        }
        if (!listenerList.contains(listener)) {
            listenerList.add(listener);
        }
    }

    private void addInterstitialAdListenerObserver(String adId, InterstitialAdListener listener) {
        LinkedList<InterstitialAdListener> listenerList = this.mInterstitialListMap.get(adId);
        if (listenerList == null) {
            listenerList = new LinkedList();
            this.mInterstitialListMap.put(adId, listenerList);
        }
        if (!listenerList.contains(listener)) {
            listenerList.add(listener);
        }
    }

    private void adRequestEvent(String adId, int adType, String requestType) {
        Bundle bundle = new Bundle();
        bundle.putString("ad_id", adId);
        bundle.putInt("ad_type", adType);
        bundle.putString("fc_type", requestType);
        AdEvent.Event event = new AdEvent.Event();
        event.name = "ad_request";
        event.bundle = bundle;
        AdEvent.getInstance().addEventInfo(event);
    }

    private void adMatchEvent(int scenesId, int adType) {
        Bundle bundle = new Bundle();
        bundle.putInt("ad_type", adType);
        bundle.putString("ad_id", String.valueOf(scenesId));
        AdEvent.Event event = new AdEvent.Event();
        event.bundle = bundle;
        event.name = "ad_match";
        AdEvent.getInstance().addEventInfo(event);
    }

    private static class TaskMainHandler
    extends Handler {
        private static final int NATIVE_CACHE_INVALID_TASK = 0;
        private static final int INTERSTITIAL_CACHE_INVALID_TASK = 1;

        public TaskMainHandler() {
            super(Looper.getMainLooper());
        }

        public void handleMessage(@NonNull Message msg) {
            switch (msg.what) {
                case 0: {
                    ((NativeAdListener)msg.obj).onCacheInvalid(null);
                    break;
                }
                case 1: {
                    ((InterstitialAdListener)msg.obj).onCacheInvalid(null);
                }
            }
        }
    }

    public static class NativeRequestListener
    extends NativeAdListener {
        private final DispatcherLoaderTaskHandler loaderTaskHandler;
        private final String adId;

        public NativeRequestListener(@NonNull DispatcherLoaderTaskHandler loaderTaskHandler, @NonNull String adId) {
            this.loaderTaskHandler = loaderTaskHandler;
            this.adId = adId;
        }

        @Override
        public void onLoaded(@NonNull NativeAdLoader loader) {
            AdLog.i(this.TAG, "onLoad info loader = " + loader);
            Bundle bundle = new Bundle();
            bundle.putString("ad_id", loader.getScenes().getAdId());
            bundle.putString("fc_type", loader.isPreload() ? "preload" : "load");
            bundle.putString("result", "true");
            bundle.putString("reason", "-1;success");
            bundle.putString("source", loader.isCache() ? "cache" : "realtime");
            bundle.putString("ad_source", loader.getSubResponseInfo());
            bundle.putInt("ad_type", 1);
            AdEvent.Event event = new AdEvent.Event();
            event.name = "ad_request_result";
            event.bundle = bundle;
            AdEvent.getInstance().addEventInfo(event);
            NativeAdListener listener = this.getAdListener(this);
            if (listener != null) {
                listener.onLoaded(loader);
            }
        }

        @Override
        public void onNativeAdLoaded(@NonNull NativeAdLoader loader, @NonNull NativeAdWrapper nativeAd) {
            AdLog.i(this.TAG, "onNativeAdLoaded loader = " + loader);
            NativeAdListener listener = this.getAdListener(this);
            if (listener != null) {
                listener.onNativeAdLoaded(loader, nativeAd);
            }
        }

        @Override
        public void onCustomFormatAdLoaded(@NonNull NativeAdLoader loader, @NonNull NativeCustomFormatAdWrapper nativeCustomFormatAd) {
            AdLog.i(this.TAG, "onCustomFormatAdLoaded loader = " + loader + "  customId = " + nativeCustomFormatAd.getCustomFormatId());
            NativeAdListener listener = this.getAdListener(this);
            if (listener != null) {
                listener.onCustomFormatAdLoaded(loader, nativeCustomFormatAd);
            }
        }

        @Override
        public void onCustomClick(@NonNull NativeAdLoader loader, @NonNull NativeCustomFormatAdWrapper nativeCustomFormatAd, @NonNull String assetName) {
            AdLog.i(this.TAG, "onCustomClick loader = " + loader + "  customId = " + nativeCustomFormatAd.getCustomFormatId() + " assetName = " + assetName);
            NativeAdListener listener = this.getAdListener(this);
            if (listener != null) {
                listener.onCustomClick(loader, nativeCustomFormatAd, assetName);
            }
        }

        @Override
        public void onError(@NonNull NativeAdLoader loader, @NonNull AdErrorWrapper loadAdError) {
            AdLog.e(this.TAG, "onErrorloader = " + loader + " errorCode = " + loadAdError);
            Bundle bundle = new Bundle();
            bundle.putString("ad_id", loader.getScenes().getAdId());
            bundle.putString("fc_type", loader.isPreload() ? "preload" : "load");
            bundle.putString("result", "false");
            bundle.putString("reason", loadAdError.getSubMessage());
            bundle.putString("source", loader.isCache() ? "cache" : "realtime");
            bundle.putString("ad_source", loader.getSubResponseInfo());
            bundle.putInt("ad_type", 1);
            AdEvent.Event event = new AdEvent.Event();
            event.name = "ad_request_result";
            event.bundle = bundle;
            AdEvent.getInstance().addEventInfo(event);
            NativeAdListener listener = this.getAdListener(this);
            if (listener != null) {
                listener.onError(loader, loadAdError);
            }
        }

        @Override
        public boolean onCacheInvalid(@Nullable NativeAdLoader loader) {
            AdLog.i(this.TAG, "onCacheInvalid loader = " + loader);
            NativeAdListener listener = this.getAdListener(this);
            if (listener != null) {
                return listener.onCacheInvalid(loader);
            }
            return false;
        }

        @Override
        public void onClicked(@NonNull NativeAdLoader loader) {
            AdLog.i(this.TAG, "onClicked info loader = " + loader);
            Bundle bundle = new Bundle();
            bundle.putString("ad_id", loader.getScenes().getAdId());
            bundle.putString("ad_source", loader.getSubResponseInfo());
            bundle.putInt("ad_type", 1);
            AdEvent.Event event = new AdEvent.Event();
            event.name = "ad_click_page";
            event.bundle = bundle;
            AdEvent.getInstance().addEventInfo(event);
            AdEvent.getInstance().addAdjustEvent("em3g3z");
            NativeAdListener listener = this.getAdListener(this);
            if (listener != null) {
                listener.onClicked(loader);
            }
        }

        @Override
        public void onClosed(@NonNull NativeAdLoader loader) {
            AdLog.i(this.TAG, "onClosed info loader = " + loader);
            Bundle bundle = new Bundle();
            bundle.putString("ad_id", loader.getScenes().getAdId());
            bundle.putString("ad_source", loader.getSubResponseInfo());
            bundle.putInt("ad_type", 1);
            AdEvent.Event event = new AdEvent.Event();
            event.name = "ad_close";
            event.bundle = bundle;
            AdEvent.getInstance().addEventInfo(event);
            NativeAdListener listener = this.getAdListener(this);
            if (listener != null) {
                listener.onClosed(loader);
            }
        }

        @Override
        public void onOpened(@NonNull NativeAdLoader loader) {
            AdLog.i(this.TAG, "onOpened info loader = " + loader);
            NativeAdListener listener = this.getAdListener(this);
            if (listener != null) {
                listener.onOpened(loader);
            }
        }

        @Override
        public void onShow(@NonNull NativeAdLoader loader) {
            AdLog.i(this.TAG, "onShow info loader = " + loader);
            AdEvent.getInstance().addAdjustEvent("6sbhqa");
            NativeAdListener listener = this.getAdListener(this);
            if (listener != null) {
                listener.onShow(loader);
            }
        }

        @Override
        protected String getClassName() {
            return "ad_sd_log_NativeRequestListener";
        }

        private NativeAdListener getAdListener(NativeAdListener innerListener) {
            NativeAdListener outListener = (NativeAdListener)this.loaderTaskHandler.mNativeAdListenerMap.get(innerListener);
            if (outListener != null) {
                return outListener;
            }
            LinkedList listenerLinkedList = (LinkedList)this.loaderTaskHandler.mNativeListMap.get(this.adId);
            NativeAdListener nativeAdListener = outListener = listenerLinkedList != null ? (NativeAdListener)listenerLinkedList.pollLast() : null;
            if (outListener != null) {
                this.loaderTaskHandler.mNativeAdListenerMap.put(innerListener, outListener);
            }
            return outListener;
        }
    }

    public static class InterstitialRequestListener
    extends InterstitialAdListener {
        private final DispatcherLoaderTaskHandler loaderTaskHandler;
        private final String adId;

        public InterstitialRequestListener(@NonNull DispatcherLoaderTaskHandler loaderTaskHandler, @NonNull String adId) {
            this.loaderTaskHandler = loaderTaskHandler;
            this.adId = adId;
        }

        @Override
        public void onAdFailedToShowFullScreenContent(@NonNull InterstitialAdLoader loader, @NonNull AdErrorWrapper adError) {
            AdLog.e(this.TAG, "onAdFailedToShowFullScreenContent loader = " + loader + " adError = " + adError);
            InterstitialAdListener listener = this.getAdListener(this);
            if (listener != null) {
                listener.onAdFailedToShowFullScreenContent(loader, adError);
            }
        }

        @Override
        public void onAdShowedFullScreenContent(@NonNull InterstitialAdLoader loader) {
            AdLog.i(this.TAG, "onAdShowedFullScreenContent loader = " + loader);
            InterstitialAdListener listener = this.getAdListener(this);
            if (listener != null) {
                listener.onAdShowedFullScreenContent(loader);
            }
        }

        @Override
        public void onLoaded(@NonNull InterstitialAdLoader loader) {
            AdLog.i(this.TAG, "onLoad info loader = " + loader);
            Bundle bundle = new Bundle();
            bundle.putString("ad_id", loader.getScenes().getAdId());
            bundle.putString("fc_type", loader.isPreload ? "preload" : "load");
            bundle.putString("result", "true");
            bundle.putString("reason", "-1;success");
            bundle.putString("source", loader.isCache() ? "cache" : "realtime");
            bundle.putString("ad_source", loader.getSubResponseInfo());
            bundle.putInt("ad_type", 2);
            AdEvent.Event event = new AdEvent.Event();
            event.name = "ad_request_result";
            event.bundle = bundle;
            AdEvent.getInstance().addEventInfo(event);
            InterstitialAdListener listener = this.getAdListener(this);
            if (listener != null) {
                listener.onLoaded(loader);
            }
        }

        @Override
        public void onError(@NonNull InterstitialAdLoader loader, @NonNull AdErrorWrapper loadAdError) {
            AdLog.e(this.TAG, "onErrorloader = " + loader + " errorCode = " + loadAdError);
            Bundle bundle = new Bundle();
            bundle.putString("ad_id", loader.getScenes().getAdId());
            bundle.putString("fc_type", loader.isPreload() ? "preload" : "load");
            bundle.putString("result", "false");
            bundle.putString("reason", loadAdError.getSubMessage());
            bundle.putString("source", loader.isCache() ? "cache" : "realtime");
            bundle.putString("ad_source", loader.getSubResponseInfo());
            bundle.putInt("ad_type", 2);
            AdEvent.Event event = new AdEvent.Event();
            event.name = "ad_request_result";
            event.bundle = bundle;
            AdEvent.getInstance().addEventInfo(event);
            InterstitialAdListener listener = this.getAdListener(this);
            if (listener != null) {
                listener.onError(loader, loadAdError);
            }
        }

        @Override
        public boolean onCacheInvalid(@Nullable InterstitialAdLoader loader) {
            AdLog.i(this.TAG, "onCacheInvalid loader = " + loader);
            InterstitialAdListener listener = this.getAdListener(this);
            if (listener != null) {
                return listener.onCacheInvalid(loader);
            }
            return false;
        }

        @Override
        public void onClicked(@NonNull InterstitialAdLoader loader) {
            AdLog.i(this.TAG, "onClickedloader = " + loader);
            Bundle bundle = new Bundle();
            bundle.putString("ad_id", loader.getScenes().getAdId());
            bundle.putString("ad_source", loader.getSubResponseInfo());
            bundle.putInt("ad_type", 2);
            AdEvent.Event event = new AdEvent.Event();
            event.name = "ad_click_page";
            event.bundle = bundle;
            AdEvent.getInstance().addEventInfo(event);
            AdEvent.getInstance().addAdjustEvent("em3g3z");
            InterstitialAdListener listener = this.getAdListener(this);
            if (listener != null) {
                listener.onClicked(loader);
            }
        }

        @Override
        public void onClosed(@NonNull InterstitialAdLoader loader) {
            AdLog.i(this.TAG, "onClosed loader = " + loader);
            Bundle bundle = new Bundle();
            bundle.putString("ad_id", loader.getScenes().getAdId());
            bundle.putString("ad_source", loader.getSubResponseInfo());
            bundle.putInt("ad_type", 2);
            AdEvent.Event event = new AdEvent.Event();
            event.name = "ad_close";
            event.bundle = bundle;
            AdEvent.getInstance().addEventInfo(event);
            InterstitialAdListener listener = this.getAdListener(this);
            if (listener != null) {
                listener.onClosed(loader);
            }
        }

        @Override
        public void onOpened(@NonNull InterstitialAdLoader loader) {
            AdLog.i(this.TAG, "onOpened loader = " + loader);
            InterstitialAdListener listener = this.getAdListener(this);
            if (listener != null) {
                listener.onOpened(loader);
            }
        }

        @Override
        public void onShow(@NonNull InterstitialAdLoader loader) {
            AdLog.i(this.TAG, "onShow loader = " + loader);
            AdEvent.getInstance().addAdjustEvent("6sbhqa");
            InterstitialAdListener listener = this.getAdListener(this);
            if (listener != null) {
                listener.onShow(loader);
            }
        }

        @Override
        protected String getClassName() {
            return "ad_sd_log_InterstitialRequestListener";
        }

        private InterstitialAdListener getAdListener(InterstitialAdListener innerListener) {
            InterstitialAdListener outListener = (InterstitialAdListener)this.loaderTaskHandler.mInterstitialAdListenerMap.get(innerListener);
            if (outListener != null) {
                return outListener;
            }
            LinkedList listenerLinkedList = (LinkedList)this.loaderTaskHandler.mInterstitialListMap.get(this.adId);
            InterstitialAdListener interstitialAdListener = outListener = listenerLinkedList != null ? (InterstitialAdListener)listenerLinkedList.pollLast() : null;
            if (outListener != null) {
                this.loaderTaskHandler.mInterstitialAdListenerMap.put(innerListener, outListener);
            }
            return outListener;
        }
    }
}

