/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.ad.sdk;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.transsion.ad.interstitialad.InterstitialAdLoader;
import com.transsion.ad.nativead.NativeAdLoader;
import com.transsion.ad.util.LimitQueue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LoaderCache {
    private final Map<String, LimitQueue<NativeAdLoader>> mNativeAdLoaderCache = new ConcurrentHashMap<String, LimitQueue<NativeAdLoader>>();
    private final Map<String, LimitQueue<InterstitialAdLoader>> mInterstitialAdLoaderCache = new ConcurrentHashMap<String, LimitQueue<InterstitialAdLoader>>();

    private LoaderCache() {
    }

    public static LoaderCache getInstance() {
        return LoaderCacheHolder.sInstance;
    }

    @Nullable
    public NativeAdLoader getNativeAdLoaderFromCache(String adId, boolean preload) {
        NativeAdLoader loader;
        LimitQueue<NativeAdLoader> loaderLimitQueue = this.mNativeAdLoaderCache.get(adId);
        if (loaderLimitQueue == null) {
            return null;
        }
        NativeAdLoader nativeAdLoader = loader = preload ? (NativeAdLoader)loaderLimitQueue.peek() : (NativeAdLoader)loaderLimitQueue.poll();
        if (loader == null) {
            return null;
        }
        if (loader.isExpired(false)) {
            if (preload) {
                loaderLimitQueue.remove(loader);
            }
            loader = this.getNativeAdLoaderFromCache(adId, preload);
        }
        return loader;
    }

    public void putNativeAdLoaderInCache(@NonNull NativeAdLoader loader, @NonNull String adId) {
        LimitQueue<NativeAdLoader> loaderLimitQueue = this.mNativeAdLoaderCache.get(adId);
        if (loaderLimitQueue == null) {
            loaderLimitQueue = new LimitQueue(3);
            this.mNativeAdLoaderCache.put(adId, loaderLimitQueue);
        }
        if (loaderLimitQueue.contains(loader)) {
            return;
        }
        loaderLimitQueue.offer(loader);
    }

    public void removeNativeAdLoaderCache(@NonNull NativeAdLoader loader, @NonNull String adId) {
        LimitQueue<NativeAdLoader> loaderLimitQueue = this.mNativeAdLoaderCache.get(adId);
        if (loaderLimitQueue == null) {
            return;
        }
        loaderLimitQueue.remove(loader);
    }

    @Nullable
    public InterstitialAdLoader getInterstitialAdLoaderFromCache(String adId, boolean preload) {
        InterstitialAdLoader loader;
        LimitQueue<InterstitialAdLoader> loaderLimitQueue = this.mInterstitialAdLoaderCache.get(adId);
        if (loaderLimitQueue == null) {
            return null;
        }
        InterstitialAdLoader interstitialAdLoader = loader = preload ? (InterstitialAdLoader)loaderLimitQueue.peek() : (InterstitialAdLoader)loaderLimitQueue.poll();
        if (loader == null) {
            return null;
        }
        if (loader.isExpired(false)) {
            if (preload) {
                loaderLimitQueue.remove(loader);
            }
            loader = this.getInterstitialAdLoaderFromCache(adId, preload);
        }
        return loader;
    }

    public void putInterstitialAdLoaderInCache(@NonNull InterstitialAdLoader loader, @NonNull String adId) {
        LimitQueue<InterstitialAdLoader> loaderLimitQueue = this.mInterstitialAdLoaderCache.get(adId);
        if (loaderLimitQueue == null) {
            loaderLimitQueue = new LimitQueue(3);
            this.mInterstitialAdLoaderCache.put(adId, loaderLimitQueue);
        }
        if (loaderLimitQueue.contains(loader)) {
            return;
        }
        loaderLimitQueue.offer(loader);
    }

    public void removeInterstitialAdLoaderCache(@NonNull InterstitialAdLoader loader, @NonNull String adId) {
        LimitQueue<InterstitialAdLoader> loaderLimitQueue = this.mInterstitialAdLoaderCache.get(adId);
        if (loaderLimitQueue == null) {
            return;
        }
        loaderLimitQueue.remove(loader);
    }

    private static final class LoaderCacheHolder {
        private static final LoaderCache sInstance = new LoaderCache();

        private LoaderCacheHolder() {
        }
    }
}

