/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.ad.util;

import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import com.transsion.ad.sdk.wrap.AdValueWrapper;

public class AdEvent {
    public static final String AD_ID = "ad_id";
    public static final String TYPE = "fc_type";
    public static final String RESULT = "result";
    public static final String REASON = "reason";
    public static final String AREA = "area";
    public static final String AD_SOURCE = "ad_source";
    public static final String DURATION = "duration";
    public static final String POSITION = "position";
    public static final String SOURCE = "source";
    public static final String AD_TYPE = "ad_type";
    public static final String AD_REQUEST = "ad_request";
    public static final String AD_REQUEST_RESULT = "ad_request_result";
    public static final String AD_SHOW = "ad_show";
    public static final String AD_CLICK = "ad_click_page";
    public static final String AD_CLOSE = "ad_close";
    public static final String AD_INIT = "ad_init";
    public static final String AD_MATCH = "ad_match";
    private final EventHandler handler;

    public AdEvent() {
        HandlerThread handlerThread = new HandlerThread("ad_event_thread");
        handlerThread.start();
        this.handler = new EventHandler(handlerThread.getLooper());
    }

    public static AdEvent getInstance() {
        return EventHolder.instance;
    }

    public void addEventInfo(@NonNull Event event) {
        Message message = this.handler.obtainMessage();
        message.obj = event;
        message.what = 0;
        message.sendToTarget();
    }

    public void addAdjustEvent(String eventName) {
        Message message = this.handler.obtainMessage();
        message.what = 1;
        message.obj = eventName;
        message.sendToTarget();
    }

    public void sendAdRevenueInfoToAdjust(AdValueWrapper adValue) {
        Message message = this.handler.obtainMessage();
        message.what = 2;
        message.obj = adValue;
        message.sendToTarget();
    }

    public void setAdEventCallBack(AdEventCallBack callback) {
        this.handler.setAdEventCallBack(callback);
    }

    public void setAdjustEventCallBack(AdjustEventCallBack adjustEventCallBack) {
        this.handler.setAdjustEventCallBack(adjustEventCallBack);
    }

    private static class EventHandler
    extends Handler {
        private static final int AD_EVENT = 0;
        private static final int ADJUST_EVENT = 1;
        private static final int AD_VALUE_EVENT = 2;
        private AdEventCallBack adEventCallBack;
        private AdjustEventCallBack adjustEventCallBack;

        public EventHandler(@NonNull Looper looper) {
            super(looper);
        }

        public void setAdEventCallBack(AdEventCallBack callback) {
            this.adEventCallBack = callback;
        }

        public void setAdjustEventCallBack(AdjustEventCallBack adjustEventCallBack) {
            this.adjustEventCallBack = adjustEventCallBack;
        }

        public void handleMessage(@NonNull Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0: {
                    Event event = (Event)msg.obj;
                    if (this.adEventCallBack == null) break;
                    this.adEventCallBack.onAdEvent(event.name, event.bundle);
                    break;
                }
                case 1: {
                    String eventName = (String)msg.obj;
                    if (this.adjustEventCallBack == null) break;
                    this.adjustEventCallBack.onAdjustEvent(eventName);
                    break;
                }
                case 2: {
                    AdValueWrapper adValue = (AdValueWrapper)msg.obj;
                    if (this.adjustEventCallBack == null) break;
                    this.adjustEventCallBack.onAdRevenueInfo(adValue);
                }
            }
        }
    }

    private static class EventHolder {
        public static AdEvent instance = new AdEvent();

        private EventHolder() {
        }
    }

    public static interface AdEventCallBack {
        public void onAdEvent(String var1, Bundle var2);
    }

    public static interface AdjustEventCallBack {
        public void onAdjustEvent(String var1);

        public void onAdRevenueInfo(AdValueWrapper var1);
    }

    public static class Event {
        public String name;
        public Bundle bundle;
    }
}

