/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.ad.util;

import android.content.Context;
import com.transsion.ad.util.AdLog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class FileUtils {
    public static String TAG = FileUtils.class.getSimpleName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(Context context, String name) {
        FileInputStream in = null;
        BufferedReader reader = null;
        StringBuilder content = new StringBuilder();
        try {
            in = context.getApplicationContext().openFileInput(name);
            reader = new BufferedReader(new InputStreamReader(in));
            String line = "";
            while ((line = reader.readLine()) != null) {
                content.append(line);
            }
        }
        catch (IOException e) {
            AdLog.e(TAG, e.getMessage());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                AdLog.e(TAG, e.getMessage());
            }
        }
        return content.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(Context context, String name, String content) {
        BufferedWriter writer = null;
        try {
            FileOutputStream out = context.getApplicationContext().openFileOutput(name, 0);
            writer = new BufferedWriter(new OutputStreamWriter(out));
            writer.write(content);
        }
        catch (IOException e) {
            AdLog.e(TAG, e.getMessage());
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                AdLog.e(TAG, e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAssetFile(Context context, String name) {
        InputStream in = null;
        BufferedReader reader = null;
        StringBuilder content = new StringBuilder();
        try {
            in = context.getApplicationContext().getAssets().open(name);
            reader = new BufferedReader(new InputStreamReader(in));
            String line = "";
            while ((line = reader.readLine()) != null) {
                content.append(line);
            }
        }
        catch (IOException e) {
            AdLog.e(TAG, e.getMessage());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                AdLog.e(TAG, e.getMessage());
            }
        }
        return content.toString();
    }
}

