package com.transsion.ad

import android.util.Log
import com.tn.lib.logger.Logger

/**
 * @author: zhangxinbing
 * @date : 2025/4/17 19:25
 * @description:
 *
 * Verbose（冗长）：Log.v(TAG, "Your message"); - 用于记录最详细的信息，通常用于调试。
 * Debug（调试）：Log.d(TAG, "Your message"); - 用于调试信息，记录应用的运行状态。
 * Info（信息）：Log.i(TAG, "Your message"); - 用于记录一般信息，表示应用的正常运行状态。
 * Warn（警告）：Log.w(TAG, "Your message"); - 用于记录潜在问题的警告信息。
 * Error（错误）：Log.e(TAG, "Your message"); - 用于记录错误信息，表示发生了错误。
 * Assert（断言）：Log.wtf(TAG, "Your message"); - 用于记录程序中的严重问题，通常是不可恢复的错误。
 */
object AdLogger {

    /**
     * SDK 内部日志、业务日志、SDK初始化日志
     */
    private const val TAG_BASE = "t_ad_" // base
    private const val TAG_INIT = TAG_BASE + "init" // 初始化相关
    private const val TAG_REPORT = TAG_BASE + "r" // 埋点上报相关
    private const val TAG_CATCHING = TAG_BASE + "catching"

    /**
     *  Banner、Splash、插屏、激励视频、icon、原生
     */
    private const val TAG_SDK = TAG_BASE + "sdk__"
    const val TAG_SDK_B = TAG_BASE + "sdk_b"
    const val TAG_SDK_S = TAG_BASE + "sdk_s"
    const val TAG_SDK_I = TAG_BASE + "sdk_i"
    private const val TAG_SDK_IC = TAG_BASE + "sdk_ic"
    const val TAG_SDK_N = TAG_BASE + "sdk_n"
    const val TAG_SDK_IRREGULAR = TAG_BASE + "sdk_fb"

    private const val TAG_SDK_PS = TAG_BASE + "sdk_ps"

    private const val TAG_B = TAG_BASE + "b" // 业务相关


    // =============================================================================================


    /**
     * 日志输出
     */
    fun logD(tag: String, msg: String, writeToFile: Boolean = true) {
        Logger.d(tag, msg, writeToFile)
    }

    fun logW(tag: String, msg: String, writeToFile: Boolean = true) {
        Logger.w(tag, msg, writeToFile)
    }

    fun logE(tag: String, msg: String, writeToFile: Boolean = true) {
        Logger.e(tag, msg, writeToFile)
    }


    /**
     * 异常输出
     */
    fun logCatching(throwable: Throwable, writeToFile: Boolean = true) {
        Logger.e(TAG_CATCHING, Log.getStackTraceString(throwable), writeToFile = writeToFile)
        //Log.e("zxb_log", Log.getStackTraceString(throwable))
    }

    /**
     * 广告初始化
     */
    fun logAdInit(msg: String, writeToFile: Boolean = true) {
        Logger.i(TAG_INIT, msg, writeToFile = writeToFile)
    }

    fun logAdInitE(msg: String, writeToFile: Boolean = true) {
        Logger.e(TAG_INIT, msg, writeToFile = writeToFile)
    }


    /**
     * 埋点上报
     */
    fun logAdReport(msg: String, writeToFile: Boolean = true) {
        Logger.w(TAG_REPORT, msg, writeToFile = writeToFile)
    }


    /**
     * SDK -- 通用 -- ad_sdk_
     */
    fun logSdk(msg: String, writeToFile: Boolean = true) {
        Logger.d(TAG_SDK, msg, writeToFile = writeToFile)
    }

    fun logSdkE(msg: String, writeToFile: Boolean = true) {
        Logger.e(TAG_SDK, msg, writeToFile = writeToFile)
    }


    /**
     * SDK -- Banner -- ad_sdk_b
     */
    fun logSdkBanner(msg: String, writeToFile: Boolean = true) {
        Logger.d(TAG_SDK_B, msg, writeToFile = writeToFile)
    }

    fun logSdkBannerE(msg: String, writeToFile: Boolean = true) {
        Logger.e(TAG_SDK_B, msg, writeToFile = writeToFile)
    }


    /**
     * SDK -- Splash -- ad_sdk_s
     */
    fun logSdkSplash(msg: String, writeToFile: Boolean = true) {
        Logger.d(TAG_SDK_S, msg, writeToFile = writeToFile)
    }

    fun logSdkSplashE(msg: String, writeToFile: Boolean = true) {
        Logger.e(TAG_SDK_S, msg, writeToFile = writeToFile)
    }


    /**
     * SDK -- Interstitial(插屏)、Video(激励视频) -- ad_sdk_i
     */
    fun logSdkIntercept(msg: String, writeToFile: Boolean = true) {
        Logger.d(TAG_SDK_I, msg, writeToFile = writeToFile)
    }

    fun logSdkInterceptE(msg: String, writeToFile: Boolean = true) {
        Logger.e(TAG_SDK_I, msg, writeToFile = writeToFile)
    }


    /**
     * SDK -- Icon -- ad_sdk_ic
     */
    fun logSdkIcon(msg: String, writeToFile: Boolean = true) {
        Logger.d(TAG_SDK_IC, msg, writeToFile = writeToFile)
    }

    fun logSdkIconE(msg: String, writeToFile: Boolean = true) {
        Logger.e(TAG_SDK_IC, msg, writeToFile = writeToFile)
    }


    /***
     * SDK -- Native(原生) -- ad_sdk_n
     */
    fun logSdkNative(msg: String, writeToFile: Boolean = true) {
        Logger.d(TAG_SDK_N, msg, writeToFile = writeToFile)
    }

    fun logSdkNativeE(msg: String, writeToFile: Boolean = true) {
        Logger.e(TAG_SDK_N, msg, writeToFile = writeToFile)
    }

    /***
     * SDK -- Irregular(非标) -- ad_sdk_fb
     */
    fun logSdkIrregular(msg: String, writeToFile: Boolean = true) {
        Logger.d(TAG_SDK_IRREGULAR, msg, writeToFile = writeToFile)
    }

    fun logSdkIrregularE(msg: String, writeToFile: Boolean = true) {
        Logger.e(TAG_SDK_IRREGULAR, msg, writeToFile = writeToFile)
    }

    /**
     * 业务侧调用广告日志输出
     */
    fun logB(msg: String, writeToFile: Boolean = true) {
        Logger.d(TAG_B, msg, writeToFile = writeToFile)
    }

    fun logBE(msg: String, writeToFile: Boolean = true) {
        Logger.e(TAG_B, msg, writeToFile = writeToFile)
    }


    /**
     * PS 相关业务
     */
    fun logPS(msg: String, writeToFile: Boolean = true) {
        Logger.d(TAG_SDK_PS, msg, writeToFile = writeToFile)
    }

    fun logPSW(msg: String, writeToFile: Boolean = true) {
        Logger.w(TAG_SDK_PS, msg, writeToFile = writeToFile)
    }

    fun logPSE(msg: String, writeToFile: Boolean = true) {
        Logger.e(TAG_SDK_PS, msg, writeToFile = writeToFile)
    }
}