package com.transsion.ad.bidding

import com.hisavana.common.bean.TAdErrorCode
import com.hisavana.common.interfacz.TAdditionalListener
import com.transsion.ad.bidding.base.BiddingIntermediateMaterialBean
import com.transsion.ad.monopoly.model.AdPlans
import com.transsion.ad.monopoly.model.MbAdSource

/**
 * @author shmizhangxinbing
 * @date : 2025/5/28 15:44
 * @description: 新版本回调
 */
abstract class BiddingTAdditionalListener : TAdditionalListener() {

    /**
     * 竞价结果回调
     */
    open fun onBiddingError(p0: TAdErrorCode?) {}
    open fun onBiddingLoad(maxEcpmObject: BiddingIntermediateMaterialBean?) {}

    /**
     * Wrapper 广告事件回调
     *
     * Hi程序化广告回调和包断广告回调整合回调给场景
     */
    open fun onBiddingWrapperAdDisplay(@MbAdSource adSource: Int) {}
    open fun onBiddingWrapperAdClick(@MbAdSource adSource: Int) {}
    open fun onBiddingWrapperAdClose(@MbAdSource adSource: Int) {}
    open fun onBiddingWrapperAdRewarded(@MbAdSource adSource: Int) {}
    open fun onBiddingWrapperAdShowError(@MbAdSource adSource: Int) {}

    /**
     * 包断广告回调
     */
    open fun onBiddingBuyOutDisplay(plans: AdPlans?) {} // 曝光
    open fun onBiddingBuyOutDisplayTimestamp(plans: AdPlans?, displayTimestamp: Long) {} // 展示时间上报
    open fun onBiddingBuyOutClick(plans: AdPlans?) {} // 点击
    open fun onBiddingBuyOutError(p0: TAdErrorCode?, plans: AdPlans?) {} // 加载展示错误
    open fun onBiddingBuyOutShowError(p0: TAdErrorCode?, plans: AdPlans?) {} // 加载展示错误
    open fun onBiddingBuyOutClose(plans: AdPlans?) {} // 广告页面关闭
    open fun onBiddingBuyOutRewarded(plans: AdPlans?) {}  // 获取激励

}