package com.transsion.ad.bidding.banner

import android.content.Context
import android.text.TextUtils
import android.view.View
import android.view.ViewGroup
import com.hisavana.common.bean.AdditionalInfo
import com.hisavana.common.bean.TAdErrorCode
import com.hisavana.common.bean.TAdNativeInfo
import com.hisavana.common.bean.TAdRequestBody
import com.hisavana.common.constant.BannerSize
import com.hisavana.common.interfacz.TAdditionalListener
import com.hisavana.mediation.ad.TBannerView
import com.transsion.ad.bidding.BiddingTAdditionalListener
import com.transsion.ad.hi.HiSavanaAdManager
import com.transsion.ad.monopoly.model.MbAdSource
import com.transsion.ad.scene.SceneCommonConfig
import com.transsion.ad.scene.SceneOnOff
import com.transsion.ad.strategy.AdContextManager

/**
 * @author shmizhangxinbing
 * @date : 2025/5/28 15:14
 * @description: 程序化Banner竞价
 */
class BiddingHiSavanaBannerProvider : TAdditionalListener() {

    private var mSceneId: String? = null // 场景调用的时候传进来的场景ID
    private var mCtxMap: Map<String, Any>? = null// 上下文信息
    private var mListener: BiddingTAdditionalListener? = null // 这里的状态回调给 BiddingBannerManager 进行处理
    private var mContext: Context? = null
    private var tBannerView: TBannerView? = null


    // ================================ Hi 程序化广告SDK回调 ==========================================


    override fun onLoadSuccess(p0: AdditionalInfo) {
        super.onLoadSuccess(p0)
        getListener()?.onLoadSuccess(p0)
    }

    override fun onLoadFailure(p0: TAdErrorCode?, p1: AdditionalInfo) {
        super.onLoadFailure(p0, p1)
        getListener()?.onLoadFailure(p0, p1)
    }

    override fun onShow(p0: TAdNativeInfo?, p1: AdditionalInfo) {
        super.onShow(p0, p1)
        getListener()?.onShow(p0, p1)
    }

    override fun onShowError(p0: TAdErrorCode?, p1: AdditionalInfo) {
        super.onShowError(p0, p1)
        getListener()?.onShowError(p0, p1)
    }

    override fun onClick(p0: TAdNativeInfo?, p1: AdditionalInfo) {
        super.onClick(p0, p1)
        getListener()?.onClick(p0, p1)
    }


    // =============================================================================================


    /**
     * 场景ID
     */
    fun setSceneId(sceneId: String?) {
        mSceneId = sceneId
    }

    fun getSceneId(): String = mSceneId ?: ""

    /**
     * 场景下文
     */
    fun setCtxMap(ctxMap: Map<String, Any>?) {
        mCtxMap = ctxMap
    }

    private fun getCtxMap(): Map<String, Any> = mCtxMap ?: emptyMap()

    /**
     * 广告加载回调
     */
    fun setListener(listener: BiddingTAdditionalListener?) {
        mListener = listener
    }

    private fun getListener(): BiddingTAdditionalListener? = mListener

    /**
     * 上下文
     */
    fun setContext(context: Context?) {
        mContext = context
    }

    private fun getContext(): Context? = mContext

    /**
     * 获取广告View
     */
    fun getBannerView(): View? = tBannerView


    // =============================================================================================


    fun destroy() {
        (tBannerView?.parent as? ViewGroup)?.removeView(tBannerView)
        tBannerView?.destroy()
        tBannerView = null
    }

    /**
     * 加载广告
     */
    fun loadAd() {
        if (HiSavanaAdManager.isInitialized().not()) {
            onLoadFailure("HiSavana 广告SDK未初始化")
            return
        }

        if (SceneOnOff.isSceneHiOff(getSceneId())) {
            onLoadFailure("广告位已关闭")
            return
        }

        if (TextUtils.isEmpty(getSceneId())) {
            onLoadFailure("sceneId is empty")
            return
        }

        if (getContext() == null) {
            onLoadFailure("context is null")
            return
        }

        // 首次创建对象
        if (null == tBannerView) {
            tBannerView = TBannerView(getContext())
            // 通知HiSavana当前是限制级的上线文
            if (AdContextManager.isDangerGenre(getCtxMap())) {
                tBannerView?.setContainVulgarContent(true)
            }
            tBannerView?.setAdSize(BannerSize.SIZE_320x250)
            tBannerView?.setAdUnitId(SceneCommonConfig.getHiSavanaPlacementId(mSceneId))
            tBannerView?.setHideAdCloseView(true)
            val tAdRequest = TAdRequestBody.AdRequestBodyBuild().setAdditionalListener(this).build()
            tBannerView?.setRequestBody(tAdRequest)
        }
        tBannerView?.loadAd()
    }

    /**
     * 加载失败
     */
    private fun onLoadFailure(errorMsg: String) {
        getListener()?.onLoadFailure(
            TAdErrorCode(MbAdSource.MB_AD_SOURCE_HISAVANA, errorMsg), AdditionalInfo()
        )
    }

}