package com.transsion.ad.bidding.base

import android.util.Log
import com.transsion.ad.AdLogger

/**
 * @author shmizhangxinbing
 * @date : 2025/6/4 15:56
 * @description: 日志输出
 */
interface ILog {

    fun getLogTag(): String

    fun getSceneId(): String?

    fun getClassTag(): String = javaClass.simpleName

    fun onLog(level: Int, msg: String) {
        when (level) {
            Log.ERROR -> {
                AdLogger.logE(tag = getLogTag(), "${getClassTag()} --> ${getSceneId()} --> $msg")
            }

            Log.WARN -> {
                AdLogger.logW(tag = getLogTag(), "${getClassTag()} --> ${getSceneId()} --> $msg")
            }

            Log.DEBUG -> {
                AdLogger.logD(tag = getLogTag(), "${getClassTag()} --> ${getSceneId()} --> $msg")
            }
        }
    }

}