package com.transsion.ad.bidding.interstitial

import android.util.Log
import com.transsion.ad.AdLogger
import com.transsion.ad.bidding.base.AbsAdBidding
import com.transsion.ad.bidding.gemini.AbsBiddingBuyOutGemini
import com.transsion.ad.bidding.base.BiddingIntermediateMaterialBean
import com.transsion.ad.bidding.gemini.BiddingBuyOutInterstitialGemini
import com.transsion.ad.monopoly.model.AdPlans
import com.transsion.ad.monopoly.model.MbAdType

/**
 * @author shmizhangxinbing
 * @date : 2025/6/3 20:28
 * @description:
 */
class BiddingInterstitialManager : AbsAdBidding() {

    companion object {

        fun preLoadAd(sceneId: String) {
            BiddingHiSavanaInterstitialProvider.getManager(sceneId)?.loadAd()
        }
    }

    private val gemini = BiddingBuyOutInterstitialGemini()


    // =============================================================================================


    override fun getAdType(): Int = MbAdType.MB_AD_TYPE_INTERSTITIAL

    override fun getLogTag(): String = AdLogger.TAG_SDK_I

    override fun getGemini(): AbsBiddingBuyOutGemini = gemini

    override fun addHiSavanaProvider(
        biddingPlan: MutableList<BiddingIntermediateMaterialBean>, adPlans: AdPlans
    ) {

        // 加载插屏广告
        val interstitial = BiddingHiSavanaInterstitialProvider.getManager(getSceneId())
        val additionalInfo = interstitial?.getAdditionalInfo()

        // 同步获取到了就添加到竞价队列
        if (additionalInfo != null) {
            //
            if (isUseHiEcpm(adPlans)) {
                adPlans.bidEcpmCent = additionalInfo.ecpm
            }

            biddingPlan.add(
                BiddingIntermediateMaterialBean(
                    ecpm = adPlans.bidEcpmCent,
                    plans = adPlans,
                    nativeInfo = null,
                    isExpend = false,
                    hiSavanaInterceptProvider = interstitial
                )
            )

            interstitial.enterScene(getSceneId())
        } else {
            onLog(Log.ERROR, "插屏广告同步获取失败")
        }
    }

}