package com.transsion.ad.bidding.nativead

import android.text.TextUtils
import com.hisavana.mediation.ad.TAdNativeView
import com.transsion.ad.AdLogger
import com.transsion.ad.bidding.base.AbsAdBidding
import com.transsion.ad.bidding.gemini.AbsBiddingBuyOutGemini
import com.transsion.ad.bidding.base.BiddingIntermediateMaterialBean
import com.transsion.ad.monopoly.model.AdPlans
import com.transsion.ad.monopoly.model.MbAdType
import com.transsion.ad.monopoly.plan.AdPlanSourceManager
import com.transsion.ad.monopoly.plan.AdPlanUtil
import com.transsion.ad.view.native_ad.BiddingBuyOutNativeView

/**
 * @author shmizhangxinbing
 * @date : 2025/5/27 19:03
 * @description: 竞价的Native广告
 */
class BiddingNativeManager : AbsAdBidding() {


    // ==================================== 展示广告的View也需要释放 ===================================


    private var hiNativeView: TAdNativeView? = null
    private var buyoutNativeView: BiddingBuyOutNativeView? = null // 当前广告数据是哪个View展示的

    fun bindBuyOutNativeView(view: BiddingBuyOutNativeView?) {
        buyoutNativeView = view
    }

    fun bindHiNativeView(view: TAdNativeView?) {
        hiNativeView = view
    }

    fun isReady(): Boolean {
        return getMaxEcpmObject() != null
    }

    fun isHiAd(): Boolean = AdPlanSourceManager.isHiAdPlan(getMaxEcpmObject()?.plans)


    // =============================================================================================


    override fun getAdType(): Int = MbAdType.MB_AD_TYPE_NATIVE

    override fun getGemini(): AbsBiddingBuyOutGemini? = null

    override fun destroy() {
        buyoutNativeView?.destroy() // 处理上报滞后问题
        super.destroy()
        getMaxEcpmObject()?.nativeInfo?.release()
        BiddingHiSavanaNativeProvider.getNativeManager(getSceneId())?.removeListener(this)
        hiNativeView?.release()
    }

    override fun getLogTag(): String = AdLogger.TAG_SDK_N

    override fun addHiSavanaProvider(
        biddingPlan: MutableList<BiddingIntermediateMaterialBean>, adPlans: AdPlans
    ) {
        // Hi程序化广告需要同步请求,请求到了添加到结果队列
        val nativeInfo = BiddingHiSavanaNativeProvider.getNativeManager(getSceneId())?.getAdsSync()
        // 同步获取到了就添加到竞价队列
        if (nativeInfo != null) {
            if (isUseHiEcpm(adPlans)) {
                adPlans.bidEcpmCent = nativeInfo.ecpmPrice
            }

            biddingPlan.add(
                BiddingIntermediateMaterialBean(
                    ecpm = adPlans.bidEcpmCent,
                    plans = adPlans,
                    nativeInfo = nativeInfo,
                    isExpend = false
                )
            )

            // 添加一个回调
            BiddingHiSavanaNativeProvider.getNativeManager(getSceneId())?.addListener(this)
        }
    }

    override fun onBiddingLoad(maxEcpmObject: BiddingIntermediateMaterialBean?) {
        super.onBiddingLoad(maxEcpmObject)
        // 需要将其它未使用的NativeInfo重新添加到缓存池中
        // 将未使用NativeInfo释放
        // 直接释放，因为低价格在后面的竞价还是失败
        getBiddingPlanList()?.forEach {
            if (it.nativeInfo != null && TextUtils.equals(maxEcpmObject?.plans?.id, it.plans?.id)
                    .not()
            ) {
                it.nativeInfo.release()
            }
        }
    }

}