package com.transsion.ad.bidding.splash

import android.annotation.SuppressLint
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.widget.FrameLayout
import com.gyf.immersionbar.ImmersionBar
import com.transsion.ad.AdLogger
import com.transsion.ad.R
import com.transsion.ad.bidding.base.AbsBiddingActivity
import com.transsion.ad.databinding.ActivityBiddingBuyOutSplashBinding
import com.transsion.ad.monopoly.model.MbAdType
import com.transsion.ad.scene.SceneCommonConfig
import com.transsion.ad.strategy.MeasureManager
import com.transsion.ad.view.AdTagView

/**
 * @author shmizhangxinbing
 * @date : 2025/5/30 10:43
 * @description: 开屏广告
 * 1. 仅可通过点击SKIP按钮跳过
 * 2. 离开页面倒计时暂停
 * 3. 开屏广告关闭的时候自动触发资源回收
 */
@SuppressLint("CustomSplashScreen")
class BiddingBuyOutSplashActivity : AbsBiddingActivity(), MeasureManager.ViewVisibilityListener {

    private var binding: ActivityBiddingBuyOutSplashBinding? = null


    // =============================================================================================


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        binding?.clRoot?.let {
            it.post {
                it.setPadding(
                    it.paddingLeft,
                    ImmersionBar.getStatusBarHeight(this),
                    it.paddingRight,
                    it.paddingBottom
                )
            }
        }
    }

    override fun getLogTag(): String = AdLogger.TAG_SDK_S

    override fun getAdType(): Int = MbAdType.MB_AD_TYPE_SPLASH

    override fun getSubContentView(): View? {
        binding = ActivityBiddingBuyOutSplashBinding.inflate(layoutInflater)
        return binding?.root
    }

    override fun getMediaContain(): FrameLayout? = binding?.container

    override fun getVolumeContainer(): FrameLayout? = binding?.flVolumeContainer

    override fun getCountDownTimes(): Int {
        return SceneCommonConfig.getSplashCountDown(getSceneId())
    }

    @SuppressLint("StringFormatMatches")
    override fun refreshCountDownView(i: Int) {
        binding?.tvCountDown?.apply {
            visibility = View.VISIBLE
            text = String.format(getString(R.string.skip_ad, i))
        }
    }

    override fun onAdCompletion() {
        finishAdActivity()
    }

    override fun showCloseAdDialog() {
        //TODO("Not yet implemented")
    }

    override fun getAdIcon(): View? = findViewById<AdTagView>(R.id.adIcon)

    override fun showAdInformation() {

        // 展示App的信息
        kotlin.runCatching {
            findViewById<FrameLayout>(R.id.movieBoxLayout)?.apply {
                removeAllViews()
                val inflate = LayoutInflater.from(this@BiddingBuyOutSplashActivity)
                    .inflate(getAppLayoutId(), this, false)
                addView(inflate)
            }
        }

        // Skip
        binding?.tvCountDown?.setOnClickListener {
            // 点击skip按钮，跳过广告
            finishAdActivity()
        }
    }

}