package com.transsion.ad.config

import com.transsion.ad.AdLogger

/**
 * @author: zhangxinbing
 * @date : 2024/6/28 10:33
 * @description: 其他业务需求通过当前类提供的方法设置进来。
 */
object BusinessConfig {

    /**
     * 会员功能与广告交互
     */
    fun setSkipShowAd(isPassed: Boolean) {
        MemberBusinessSwitch.setSkipShowAd(isPassed)
    }

    /**
     * 如果全局的弹窗正在展示，那就加载插屏和激励视频广告
     */
    fun setGlobalDialogShowState(isShow: Boolean) {
        GlobalDialogSwitch.setShowDialogState(isShow)
    }

    /**
     * 会员模式下，广告通过配置的白名单列表进行展示
     */
    fun setAdSceneIdWhitList(strings: List<String>) {
        MemberBusinessSwitch.setAdSceneIdWhitList(strings)
    }

    /**
     * 全搜的时候热启动不展示热启动广告
     */
    fun setFullSearchModelSkipHotSplashAd() {
        AdLogger.logSdkE("${javaClass.simpleName} --> setFullSearchModelSkipHotSplashAd() --> 接收到了deeplink事件 --> 全搜的时候热启动不展示热启动广告")
        FullSearchModel.setSkipHotSplash(isSkip = true)
    }
}