package com.transsion.ad.db.mcc

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Query

/**
 * @author: zhangxinbing
 * @date : 2024/1/2 16:51
 * @description:
 */
@Dao
interface LocalMccDao {

    /***获取所有信息*/
    @Query("SELECT * FROM local_mcc")
    suspend fun getAllLocalMccList(): List<LocalMcc>

    /***获取第一条信息*/
    @Query("SELECT * FROM local_mcc LIMIT 1")
    suspend fun getFirstLocalMcc(): LocalMcc?

    /***条件查询*/
    @Query("SELECT * FROM local_mcc WHERE Iso = :value")
    suspend fun getLocalMccByColumnValue(value: String): LocalMcc?

    /***插入信息*/
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insert(localMcc: LocalMcc)

    /***插入信息*/
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insert(localMccList: List<LocalMcc>)

    /***删除所有信息*/
    @Query("DELETE FROM local_mcc")
    suspend fun deleteAll()
}