package com.transsion.ad.db.pslink

import androidx.room.*

/**
 * @author shmizhangxinbing
 * @date : 2025/7/14 15:52
 * @description:
 */
@Dao
interface AttributionPointDao {

    @Insert
    suspend fun insertAttributionPoint(attributionPoint: AttributionPoint) // 插入归因埋点

    @Delete
    suspend fun deleteAttributionPoint(attributionPoint: AttributionPoint?) // 删除指定的归因埋点

    @Update
    suspend fun updateAttributionPoint(attributionPoint: AttributionPoint?) // 更新归因埋点

    @Query("SELECT * FROM attribution_points WHERE type = :type")
    suspend fun getAttributionPointsByType(type: AttributionPoint.AttributionType): List<AttributionPoint> // 根据类型查询归因埋点

    @Query("SELECT * FROM attribution_points")
    suspend fun getAllAttributionPoints(): List<AttributionPoint> // 查询所有归因埋点

    @Query(
        "SELECT * FROM attribution_points " + "WHERE :currentTimestamp - updateTimestamp >= :timeThreshold " + // 增加时间差条件，阈值作为参数
                "ORDER BY " + "CASE type WHEN 'CLICK' THEN 0 ELSE 1 END, " + // CLICK 优先
                "failCount ASC, " + // failCount 小的优先
                "updateTimestamp DESC " + // updateTimestamp 大的优先
                "LIMIT 1"
    )
    suspend fun getTopAttributionPoints(
        currentTimestamp: Long, // 当前时间戳
        timeThreshold: Long // 时间差阈值，动态传入，默认5000毫秒
    ): AttributionPoint?


    /**
     *  查询是否存在指定 psId、type 和 reportUrl 的记录
     */
    @Query("SELECT EXISTS(SELECT 1 FROM attribution_points WHERE psId = :psId AND type = :type AND reportUrl = :reportUrl)")
    suspend fun isAttributionPointExists(
        psId: String?, type: AttributionPoint.AttributionType, reportUrl: String?
    ): Boolean

}