package com.transsion.ad.db.pslink

import android.os.Parcelable
import androidx.annotation.Keep
import androidx.room.Entity
import androidx.room.PrimaryKey
import kotlinx.parcelize.Parcelize

/**
 * @author: liupeng
 * @date : 2024/7/29 14:12
 * @description: 广告计划数据库操作
 *
 * */
@Parcelize
@Keep
@Entity(tableName = "ps_link_ad")
data class PsLinkAdPlan(
    //场景+psItem Id
    @PrimaryKey var id: Int,
    // 包断计划ID
    var nonId: String,
    //广告类型是ps
    var adSource: String,
    //场景名称 = ps场景id = ps广告位id
    var extAdSlot: String,
    //按插入顺序 排序
    var rank: Int = 0,
    //ps appid 用于识别app信息是否要更新
    var psPlanId: String? = null,
    //ps商单转化信息
    var psLinkAdInfoStr: String? = null,
    //ps商单信息
    var psInfoJson: String? = null,

    // 更新时间戳，默认当前时间
    // 根据时间戳获取列表里面的一个数据
    var updateTimestamp: Long? = null

) : Parcelable