package com.transsion.ad.db.pslink

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Query
import androidx.room.Update
import com.transsion.ad.db.pslink.PsLinkAdPlan

/**
 * @author: liupeng
 * @date : 2024/7/29 14:12
 * @description: 广告计划数据库操作
 *
 * */
@Dao
interface PsLinkAdPlanDao {

    /**
     * 获取所有匹配 extAdSlot 的数据的对象个数
     */
    @Query("SELECT COUNT(*) FROM ps_link_ad WHERE extAdSlot = :extAdSlot")
    suspend fun getCountByExtAdSlot(extAdSlot: String?): Int

    /**
     * 根据 extAdSlot 查询 updateTimestamp 最小的记录
     */
    @Query("SELECT * FROM ps_link_ad WHERE extAdSlot = :extAdSlot ORDER BY updateTimestamp ASC LIMIT 1")
    suspend fun getPsLinkAdBySlotWithMinTimestamp(extAdSlot: String): PsLinkAdPlan?

    /**
     * 更新整个 PsLinkAdPlan 对象
     */
    @Update
    suspend fun updatePsLinkAdPlan(psLinkAdPlan: PsLinkAdPlan?)

    /**
     * 获取对应场景的广告
     * @param newVersion String
     * @return List<NonAdPlans>
     */
    @Query("SELECT * FROM ps_link_ad where extAdSlot=:extAdSlot order by rank asc")
    suspend fun getPslinkListAdBySlot(extAdSlot: String): List<PsLinkAdPlan>?

    @Query("SELECT * FROM ps_link_ad where extAdSlot=:extAdSlot & rank=:rank")
    suspend fun getPslinkAdBySlot(extAdSlot: String, rank: Int): PsLinkAdPlan?

    @Query("SELECT * FROM ps_link_ad")
    suspend fun getAllPslink(): List<PsLinkAdPlan>?

    /**
     * 移除ps场景的广告list
     * @param newVersion String
     * @return List<NonAdPlans>
     */
    @Query("DELETE FROM ps_link_ad WHERE extAdSlot =:extAdSlot")
    suspend fun deleteExpiredPlansBySlot(extAdSlot: String)


    /**
     * 根据包断广告删除计划
     * @param newVersion String
     * @return List<NonAdPlans>
     */
    @Query("DELETE FROM ps_link_ad WHERE id =:id")
    suspend fun deleteExpiredPlansById(id: String)

    /**
     * 插入对应广告场景
     * @param newVersion String
     * @return List<NonAdPlans>
     */
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insertPslinkAdList(list: List<PsLinkAdPlan>)

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insertPslinkAd(item: PsLinkAdPlan)

}