package com.transsion.ad.hi

import com.blankj.utilcode.constant.MemoryConstants
import com.blankj.utilcode.util.Utils
import com.cloud.hisavana.net.CommonOkHttpClient
import com.hisavana.mediation.config.TAdManager
import com.tn.lib.net.manager.NetServiceGenerator
import com.tn.lib.util.device.TNDeviceHelper
import com.transsion.ad.AdLogger
import com.transsion.ad.scene.SceneGlobalConfig
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.delay
import kotlinx.coroutines.withContext
import java.util.concurrent.atomic.AtomicBoolean

/**
 * @author: zhangxinbing
 * @date : 2023/12/11 15:10
 * @description:
 */
object HiSavanaAdManager {

    private var isInitializing: AtomicBoolean = AtomicBoolean(false)    // 标记广告SDK初始化中
    private var isInitialized: AtomicBoolean = AtomicBoolean(false)     // 标记广告SDK初始化完成

    private fun getClassTag(): String = javaClass.simpleName


    // =============================================================================================


    /**
     * 广告是否初始化了 -- 如果没有初始化完成那就不请求广告
     */
    fun isInitialized(): Boolean = isInitialized.get()

    /**
     * 初始化广告SDK
     */
    suspend fun initHiAdSdk(hisavanaAppId: String, adTestDevice: Boolean, isDebug: Boolean) {
        //2g & 开关不打开直接关闭sdk初始化
        if (isAdLowMemoryDevice()) {
            AdLogger.logAdInitE("${getClassTag()} --> initHiAdSdk() --> 2g & 开关不打开直接关闭sdk初始化")
            return
        }

        // 只初始化一次
        if (isInitializing.get()) {
            AdLogger.logAdInitE("${getClassTag()} --> initHiAdSdk() --> isInitializing == true")
            return
        }
        isInitializing.set(true)

        // 初始化 HiSavana SDK
        withContext(Dispatchers.IO) {
            // 这里广告SDK放入子线程初始化
            kotlin.runCatching {
                // 需要在初始化广告前调用
                val httpClient = NetServiceGenerator.instance.getHttpClient()
                CommonOkHttpClient.setOkHttpDispatcher(httpClient?.dispatcher)

                // TODO 测试
//                AdxServerConfig.setAppModle(1)

                TAdManager.init(
                    Utils.getApp()?.applicationContext, TAdManager.AdConfigBuilder()
                        // 必须设置，请在广告平台申请
                        .setAppId(hisavanaAppId)
                        // 可选项，是否打印广告日志，默认为false；假如设置为true时会打印log，关键字ADSDK_M、ADSDK_N
                        .setDebug(isDebug)
                        // 可选项，是否请求测试广告，默认为false；假如为true时请求广告平台的测试广告，否则请求广告平台的正式广告
                        .testDevice(isDebug && adTestDevice)
                        // 可选项，视频类广告是否全局静音
                        .setMuteVideo(true).build()
                )

                // HiSavana 初始化标识
                //AdLogger.logSdk("${getClassTag()} ====================== MB initAd --> complete -- delay delay delay delay delay -- isInit = false ======================")
                // 这里延迟是为了处理HiSavana广告SDK初始化异常
                delay(5000)
                isInitialized.set(true)
                AdLogger.logAdInit("${getClassTag()} --> initHiAdSdk() --> complete -- isInitialized = ${isInitialized.get()}")

                // 测试的时候输出一下 场景配置信息
//                if (isDebug) {
//                    val value =
//                        AdMmkv.mmkvWithID.getString(MbAdContents.MMKV_KEY_AD_SCENE_CONFIG_DATA, "")
//                    val array = GsonUtils.fromJson(value, JsonArray::class.java)
//                    AdLogger.logAdInit("${getClassTag()} --> 场景配置信息 --> config = $array")
//                }
            }
        }
    }


    // =============================================================================================


    /**
     * 是否为低于某个内存
     * @return Boolean
     */
    private fun isAdLowMemoryDevice(): Boolean {
        val totalMem = TNDeviceHelper.getMemoryInfo(Utils.getApp()).totalMem
        val lowMemoryValue = SceneGlobalConfig.getLowMemoryValue()
        return if (totalMem <= MemoryConstants.GB.times(lowMemoryValue.toDouble())) {
            true
        } else {
            false
        }
    }
}

