package com.transsion.ad.middle.banner

import android.view.ViewGroup
import com.blankj.utilcode.util.Utils
import com.hisavana.common.bean.TAdErrorCode
import com.hisavana.common.bean.TAdRequestBody
import com.hisavana.common.interfacz.TAdListener
import com.hisavana.mediation.ad.TBannerView
import com.transsion.ad.AdLogger
import com.transsion.ad.hi.HiSavanaAdManager
import com.transsion.ad.middle.WrapperAdListener
import com.transsion.ad.monopoly.model.MbAdSource
import com.transsion.ad.monopoly.model.MbAdType
import com.transsion.ad.report.AdReportProvider
import com.transsion.ad.scene.SceneCommonConfig
import com.transsion.ad.strategy.AdContextManager

/**
 * @author: zhangxinbing
 * @date : 2024/2/2 17:07
 * @description: Hisavana横幅广告
 */
internal class HiSavanaBannerProvider(val mSceneId: String?, private val adSize: Int) : TAdListener() {


    private var mHiSavanaId: String? = null

    /**
     * 当前Banner的状态
     */
    private var currentState = AD_BANNER_STATE_NONE

    /**
     * 承载广告的View
     */
    private var adview: TBannerView? = null

    private var mListener: WrapperAdListener? = null

    private fun getClassTag(): String = javaClass.simpleName


    // =============================================================================================

    companion object {
        const val AD_BANNER_STATE_NONE = 0 // 无状态
        const val AD_BANNER_STATE_LOADING = 1 // 加载中
        const val AD_BANNER_STATE_ERROR = 2 // 加载失败
        const val AD_BANNER_STATE_LOADED = 3 // 加载成功
        const val AD_BANNER_STATE_SHOWED = 4 // 已展示
    }


    // =============================================================================================


    override fun onLoad() {
        super.onLoad()
        currentState = AD_BANNER_STATE_LOADED
        // 请求到之后 返回给场景
        mListener?.onBannerViewReady(adview)
    }

    override fun onError(p0: TAdErrorCode?) {
        currentState = AD_BANNER_STATE_ERROR
        mListener?.onError(p0)
    }

    override fun onShow(source: Int) {
        currentState = AD_BANNER_STATE_SHOWED
        // 埋点上报 统一处理
        AdReportProvider.display(
            sceneId = mSceneId,
            adPlanId = "",
            adSource = source,
            adId = mHiSavanaId,
            adType = MbAdType.MB_AD_TYPE_BANNER,
            isAdShowFinal = false,
            psId = null
        )
    }

    override fun onClicked(source: Int) {
        // 埋点上报 统一处理
        AdReportProvider.adClick(
            sceneId = mSceneId,
            adPlanId = "",
            adSource = source,
            adId = mHiSavanaId,
            adType = MbAdType.MB_AD_TYPE_BANNER,
            isAdShowFinal = false,
            psId = null
        )
    }

    override fun onClosed(p0: Int) {
        //
    }


    // =============================================================================================


    /**
     * 资源回收 --> 页面销毁、下拉刷新
     */
    fun destroy() {
        AdLogger.logSdkBanner(
            "${getClassTag()} --> destroy() -- sceneId = $mSceneId"
        )

        mListener = null
        (adview?.parent as? ViewGroup)?.removeView(adview)
        adview?.destroy()
        adview = null
    }

    /**
     * 加载广告
     */
    fun loadAd(listener: WrapperAdListener, ctxMap: Map<String, Any>) {
        mListener = listener
        mHiSavanaId = SceneCommonConfig.getHiSavanaPlacementId(mSceneId)
        currentState = AD_BANNER_STATE_LOADING

        if (HiSavanaAdManager.isInitialized().not()) {
            mListener?.onError(
                TAdErrorCode(
                    MbAdSource.MB_AD_SOURCE_HISAVANA,
                    "HiSavana 广告SDK未初始化 -- sceneId = $mSceneId"
                )
            )
            return
        }

        // 首次创建对象
        if (null == adview) {
            adview = TBannerView(Utils.getApp())
            // 通知HiSavana当前是限制级的上线文
            if (AdContextManager.isDangerGenre(ctxMap)) {
                adview?.setContainVulgarContent(true)
            }
            adview?.setAdSize(adSize)
            adview?.setAdUnitId(mHiSavanaId)
            adview?.setHideAdCloseView(true)
            val tAdRequest = TAdRequestBody.AdRequestBodyBuild().setAdListener(this).build()
            adview?.setRequestBody(tAdRequest)
        }
        adview?.loadAd()
    }
}