package com.transsion.ad.middle.banner

import android.content.Context
import android.text.TextUtils
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.TextureView
import android.view.View
import android.widget.FrameLayout
import android.widget.ImageView
import androidx.appcompat.widget.AppCompatImageView
import com.blankj.utilcode.util.Utils
import com.bumptech.glide.Glide
import com.transsion.ad.AdLogger
import com.transsion.ad.report.AdReportProvider
import com.transsion.ad.R
import com.transsion.ad.monopoly.intercept.NonAdShowedTimesManager
import com.transsion.ad.monopoly.model.AdMaterialList
import com.transsion.ad.monopoly.model.AdPlans
import com.transsion.ad.monopoly.model.MbAdShowLevel
import com.transsion.ad.strategy.AdClickManager
import com.transsion.ad.strategy.AdTagManager
import com.transsion.ad.strategy.MeasureManager
import com.transsion.ad.view.AdTagView
import com.transsion.player.MediaSource
import com.transsion.player.config.VodConfig
import com.transsion.player.enum.ScaleMode
import com.transsion.player.orplayer.IPlayerListener
import com.transsion.player.orplayer.ORPlayer
import com.transsion.player.orplayer.PlayError
import com.transsion.ad.middle.WrapperAdListener
import com.transsion.ad.monopoly.model.MbAdSource
import com.transsion.ad.monopoly.model.MbAdType
import com.transsion.ad.monopoly.plan.AdPlanUtil

/**
 * @author: zhangxinbing
 * @date : 2024/2/4 14:26
 * @description: 非标准广告
 */
@Deprecated("use BiddingBannerManager")
internal class NonBannerView : FrameLayout, MeasureManager.ViewVisibilityListener {


    private var mListener: WrapperAdListener? = null

    /**
     * 场景信息
     */
    private var mSceneId: String = ""

    /**
     * 广告计划信息
     */
    private var mAdPlans: AdPlans? = null

    /**
     * 非标广告素材信息
     */
    private var mAdMaterialList: AdMaterialList? = null

    /**
     * 视频播放器
     */
    private var mOrPlayer: ORPlayer? = null

    private var isMute = false

    private fun getClassTag(): String = javaClass.simpleName


    // =============================================================================================


    constructor(context: Context) : this(context, null)
    constructor(context: Context, attrs: AttributeSet?) : this(context, attrs, 0)
    constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
        context, attrs, defStyleAttr
    )


    // ============================ 曝光检测 =========================================================


    /***广告开始展示的时间 时间戳 毫秒*/
    private var showTime = 0L

    /***是否已经上报过一次曝光了*/
    private var isReportAdDisplay = false

    override fun onVisibilityChanged(isVisible: Boolean) {
        if (isVisible) {
            // 开始展示的时间
            if (showTime == 0L) {
                showTime = System.currentTimeMillis()
            }

            // 视频状态处理
            if (mOrPlayer?.isPlaying() == false) {
                mOrPlayer?.play()
            }

            // 曝光上报
            if (!isReportAdDisplay) {
                isReportAdDisplay = true
                AdReportProvider.display(
                    sceneId = mSceneId,
                    adPlanId = mAdPlans?.id,
                    adSource = MbAdSource.MB_AD_SOURCE_BUY_OUT,
                    adId = mAdMaterialList?.id,
                    adType = MbAdType.MB_AD_TYPE_BANNER,
                    isAdShowFinal = MbAdShowLevel.isAdShowLevel(mAdPlans),
                    psId = AdPlanUtil.getPsId(mAdPlans)
                )

                AdLogger.logSdkBanner(
                    "${getClassTag()} --> Banner 广告展示 --> sceneId = $mSceneId --> isAdShowLevel = ${
                        MbAdShowLevel.isAdShowLevel(
                            mAdPlans
                        )
                    }"
                )
                saveShowCount()
            }
        } else {
            mOrPlayer?.pause()

            // 播放时长上报
            reportShowTime()
        }
    }

    override fun getVisibilityView(): View = this


    // =============================================================================================


    /**
     * 资源回收
     */
    fun destroy() {
        AdLogger.logSdkBanner("${getClassTag()} --> destroy() --> sceneId = $mSceneId")
        removeAllViews()
        // 资源回收
        mOrPlayer?.release()
        // 添加检测
        MeasureManager.removeSession(this)

        // 资源回收之前需要判断一下是否需要上报一下展示时长埋点
        reportShowTime()

        // 监听 WebView的生命周期
        //IWebViewActivityStateListener.reset()
    }

    /**
     * 加载广告
     */
    fun loadAd(sceneId: String, adPlans: AdPlans?, listener: WrapperAdListener?, isMute: Boolean) {
        mSceneId = sceneId
        mAdPlans = adPlans
        mListener = listener
        this.isMute = isMute

        // 目前规定一个计划只有一个素材
        if (mAdPlans?.adMaterialList?.isNotEmpty() == true) {
            mAdMaterialList = mAdPlans?.adMaterialList?.get(0)
        }

        AdLogger.logSdkBanner("${getClassTag()} --> loadAd() --> sceneId = $sceneId")

        // 渲染
        assemble()

        // 准备就绪之后将View回调出去
        mListener?.onBannerViewReady(this)
    }


    // =============================================================================================


    private fun assemble() {

        // 加入监听 可见性
        MeasureManager.addSession(this@NonBannerView)

        val nonBannerRoot = LayoutInflater.from(Utils.getApp())
            .inflate(R.layout.non_banner_view_root_layout, this, false)

        // viewRoot?.findViewById<TextView>(viewBinder.callToActionId)?.setOnClickListener {
        nonBannerRoot?.setOnClickListener {
            // 广告点击事件处理
            AdClickManager.adClick(
                deeplink = mAdMaterialList?.deeplink,
                h5Url = mAdMaterialList?.h5Link,
                adPlan = mAdPlans
            )

            // 点击埋点曝光
            AdReportProvider.adClick(
                sceneId = mSceneId,
                adPlanId = mAdPlans?.id,
                adSource = MbAdSource.MB_AD_SOURCE_BUY_OUT,
                adId = mAdMaterialList?.id,
                adType = MbAdType.MB_AD_TYPE_BANNER,
                isAdShowFinal = MbAdShowLevel.isAdShowLevel(mAdPlans),
                psId = AdPlanUtil.getPsId(mAdPlans)
            )
        }


        // 展示媒体内容
        if (mAdMaterialList?.type == AdMaterialList.NON_AD_TYPE_TEXT) {
            showImage(nonBannerRoot, mAdMaterialList)
        } else {
            playVideo(nonBannerRoot, mAdMaterialList)
        }

        nonBannerRoot?.findViewById<AppCompatImageView>(R.id.mute)?.apply {

            visibility = if (isMute) {
                View.VISIBLE
            } else {
                View.GONE
            }

            setOnClickListener {
                if (mOrPlayer?.isMute() == true) {
                    mOrPlayer?.setMute(false)
                    setImageResource(R.mipmap.ad_volumeon)
                } else {
                    mOrPlayer?.setMute(true)
                    setImageResource(R.mipmap.ad_volumeoff)
                }
            }

        }
        addView(nonBannerRoot)

        nonBannerRoot?.findViewById<AdTagView>(R.id.adIcon)?.apply {
            AdTagManager.handleForAdTagView(this)
        }
    }

    /**
     * 加载视频
     */
    private fun playVideo(nonBannerRoot: View?, adMaterialList: AdMaterialList?) {
        nonBannerRoot?.findViewById<FrameLayout>(R.id.flAdContainer)?.apply {
            removeAllViews()
            // 创建展示视频的View
            val textureView = TextureView(context)
            addView(textureView)
            // 创建播放器
            mOrPlayer = ORPlayer.Builder(context)
                .vodConfig(VodConfig(clearFrameWhenStop = false, openAudioFocus = false)).builder()
                .apply {
                    setMute(true)
                    setTextureView(textureView)
                    setScaleMode(ScaleMode.SCALE_ASPECT_FILL)
                    setLooping(true)
                    setPlayerListener(object : IPlayerListener {

                        override fun onPlayError(
                            errorInfo: PlayError, mediaSource: MediaSource?,
                        ) {
                            super.onPlayError(errorInfo, mediaSource)
                            AdLogger.logSdkBannerE("${getClassTag()} --> playVideo() --> onPlayError() --> errorInfo = $errorInfo -- sceneId = $mSceneId")
                        }

                        override fun onPrepare(mediaSource: MediaSource?) {
                            super.onPrepare(mediaSource)
                            play()
                        }

                    })
                }

            // 设置资源
            if (TextUtils.isEmpty(adMaterialList?.video?.path)) {
                mOrPlayer?.setDataSource(
                    MediaSource(
                        adMaterialList?.video?.url ?: "", adMaterialList?.video?.url ?: ""
                    )
                )
            } else {
                mOrPlayer?.setDataSource(
                    MediaSource(
                        adMaterialList?.video?.path ?: "", adMaterialList?.video?.path ?: ""
                    )
                )
            }

            // 开始播放
            mOrPlayer?.prepare()
        }
    }

    /**
     * 加载图片
     */
    private fun showImage(nonBannerRoot: View?, adMaterialList: AdMaterialList?) {
        nonBannerRoot?.findViewById<FrameLayout>(R.id.flAdContainer)?.apply {
            removeAllViews()
            val imageView = ImageView(context)
            imageView.scaleType = ImageView.ScaleType.CENTER_CROP

            // 如果本地地址是空的，那就不使用线上地址在线加载
            if (TextUtils.isEmpty(adMaterialList?.image?.path)) {
                Glide.with(context).load(adMaterialList?.image?.url).centerCrop().into(imageView)
            } else {
                Glide.with(context).load(adMaterialList?.image?.path).centerCrop().into(imageView)
            }
            addView(imageView)
        }
    }


    // =============================================================================================


    /**
     * 保存当前展示次数
     */
    private fun saveShowCount() {
        NonAdShowedTimesManager.saveShowedTimes(mAdPlans)
//        CoroutineScope(Dispatchers.IO).launch {
//            val nonAdPlans = AdPlansTransform.transformAdPlans2NonAdPlans(mAdPlans)
//            val showedTimes = nonAdPlans.showedTimes ?: 0
//            nonAdPlans.showedTimes = showedTimes + 1
//            nonAdPlans.showDate = AdUtils.getCurrentDate()
//            AppDatabase.getInstance(Utils.getApp()).nonAdPlansDao().update(nonAdPlans)
//        }
    }

    /**
     * 上报累计展示埋点
     */
    private fun reportShowTime() {
        if (showTime > 0) {
            // 上报曝光时长
            AdReportProvider.adShowTime(
                sceneId = mSceneId,
                adPlanId = mAdPlans?.id,
                displayTime = (System.currentTimeMillis() - showTime),
                adId = mAdMaterialList?.id,
                adType = MbAdType.MB_AD_TYPE_BANNER,
                isAdShowFinal = MbAdShowLevel.isAdShowLevel(mAdPlans)
            )
            showTime = 0
        }
    }
}