package com.transsion.ad.middle.banner

import android.content.Context
import android.text.TextUtils
import android.view.View
import com.hisavana.common.bean.TAdErrorCode
import com.hisavana.common.constant.BannerSize
import com.transsion.ad.AdLogger
import com.transsion.ad.report.AdReportProvider
import com.transsion.ad.monopoly.manager.AdPlansStorageManager
import com.transsion.ad.monopoly.model.AdPlans
import com.transsion.ad.monopoly.model.MbAdShowLevel
import com.transsion.ad.scene.SceneOnOff
import com.transsion.ad.middle.WrapperAdListener
import com.transsion.ad.monopoly.model.MbAdSource
import com.transsion.ad.monopoly.model.MbAdType
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext

/**
 * @author: zhangxinbing
 * @date : 2024/2/2 16:46
 * @description: Banner 广告封装
 */
@Deprecated("use BiddingBannerManager")
class WrapperBanner : WrapperAdListener() {

    private var mContext: Context? = null   // 传递进来的上下文
    private var hiSavanaBanner: HiSavanaBannerProvider? = null // HI广告加载对象
    private var nonBannerView: NonBannerView? = null  // 包断BannerView
    private var mListener: WrapperAdListener? = null // 状态回调
    private var mSceneId: String = "" // 场景ID
    private var mAdShowFinalPlan: AdPlans? = null // 兜底广告计划
    private var mAdPlans: AdPlans? = null
    private var isMute = false // 默认展示
    private fun getClassTag(): String = javaClass.simpleName


    // ============================ 👇Hi广告加载回调 =================================================


    override fun onBannerViewReady(bannerView: View?) {
        super.onBannerViewReady(bannerView)
        //AdLogger.logSdkBanner("${getClassTag()} --> onBannerViewReady() --> Banner 加载完成")
        mListener?.onBannerViewReady(bannerView)
    }

    override fun onError(p0: TAdErrorCode?) {
        super.onError(p0)
        // HiSavana 加载失败加载兜底广告计划
        AdLogger.logSdkBannerE("${getClassTag()} --> onError() --> Hi Banner 加载失败 --> p0 = ${p0?.errorMessage} --> 继续加载兜底广告")
        innerLoadAdShowFinal()
    }


    // ============================== API ==========================================================


    /**
     * 资源回收
     */
    fun destroy() {
        mListener = null

        hiSavanaBanner?.destroy()
        hiSavanaBanner = null

        nonBannerView?.destroy()
        nonBannerView = null

        mContext = null

        AdLogger.logSdkBanner(
            "${getClassTag()} --> destroy() --> sceneId = $mSceneId", writeToFile = false
        )
    }

    /**
     * 加载Banner广告
     */
    suspend fun loadBannerAd(
        sceneId: String,
        context: Context,
        listener: WrapperAdListener?,
        ctxMap: Map<String, Any> = emptyMap(),
        isMute: Boolean = false, // 默认展示
        adSize: Int = BannerSize.SIZE_320x250
    ) {
        this.isMute = isMute
        // 统一判断
        val errorMsg = SceneOnOff.isSceneOffV2(sceneId)
        if (TextUtils.isEmpty(errorMsg).not()) {
            onFailCallback(listener = listener, errorMsg = errorMsg)
            return
        }

        innerLoadAd(sceneId, context, listener, ctxMap, adSize)
    }


    // ======================== 👇广告加载流程 =======================================================


    /**
     * 失败回调
     */
    private fun onFailCallback(listener: WrapperAdListener?, errorMsg: String) {
        AdLogger.logSdkSplashE(errorMsg)
        listener?.onError(TAdErrorCode(MbAdSource.MB_AD_SOURCE_WRAPPER_AD, errorMsg))
    }

    private suspend fun innerLoadAd(
        sceneId: String, context: Context, listener: WrapperAdListener?, ctxMap: Map<String, Any>,
        adSize: Int
    ) {
        // 关键信息保存
        mSceneId = sceneId
        mListener = listener
        mContext = context

        // 加载非标还是HiSavana广告
        mAdPlans = withContext(Dispatchers.IO) {
            AdPlansStorageManager.getAdPlans(sceneId = sceneId, ctxMap = ctxMap)
        }

        // 兜底广告计划
        mAdShowFinalPlan = withContext(Dispatchers.IO) {
            AdPlansStorageManager.getAdPlans(
                sceneId = sceneId, adShowLevel = MbAdShowLevel.MB_AD_SHOW_FINAL, ctxMap = ctxMap
            )
        }

        // 广告触发 统一入口处理
        AdReportProvider.trigger(
            sceneId = sceneId,
            adType = MbAdType.MB_AD_TYPE_BANNER,
            adSource = if (mAdPlans == null) MbAdSource.MB_AD_SOURCE_HISAVANA_TRIGGER else MbAdSource.MB_AD_SOURCE_MB_TRIGGER,
            planId = mAdPlans?.id
        )

        // 广告展示优先级 --> 非标广告 > HiSavana广告
        if (null == mAdPlans) {
            innerLoadHiSavanaAd(sceneId, ctxMap, adSize)
        } else if (SceneOnOff.isSceneNonOff(sceneId).not()) {
            loadNonBannerAd(mAdPlans, sceneId)
        } else {
            innerLoadHiSavanaAd(sceneId, ctxMap, adSize)
        }
    }


    /**
     * 加载HiSavana广告
     */
    private fun innerLoadHiSavanaAd(sceneId: String, ctxMap: Map<String, Any>, adSize: Int) {
        // 加载 HiSavana 广告
        if (SceneOnOff.isSceneHiOff(sceneId).not()) {
            // 如果缓存不存在那就重新创建一个
            if (null == hiSavanaBanner) {
                hiSavanaBanner = HiSavanaBannerProvider(sceneId, adSize)
            }
            hiSavanaBanner?.loadAd(this, ctxMap)
        } else {
            innerLoadAdShowFinal()
        }
    }

    /**
     * 加载包断广告
     */
    private fun loadNonBannerAd(mAdPlans: AdPlans?, sceneId: String) {
        mContext?.let {
            nonBannerView = NonBannerView(it)
            nonBannerView?.loadAd(sceneId, mAdPlans, this, isMute)
        } ?: kotlin.run {
            onFailCallback(listener = mListener, errorMsg = "mContext == null")
        }
    }

    /**
     * 加载兜底包断广告
     */
    private fun innerLoadAdShowFinal() {
        if (mAdShowFinalPlan == null) {
            onFailCallback(
                mListener,
                "${getClassTag()} --> innerLoadAdShowFinal() --> 当前没有兜底广告 --> sceneId = $mSceneId"
            )
        } else {
            // 当前有兜底广告可用
            //AdLogger.logSdkBanner("${javaClass.simpleName} --> innerLoadAdShowFinal() --> 当前有兜底广告可用 --> sceneId = $mSceneId", writeToFile = false)
            // 能从数据库取出来，那就一定是可用使用的
            //onNonNativeReady(mAdShowFinalPlan)
            loadNonBannerAd(mAdShowFinalPlan, mSceneId)
        }
    }

}
