package com.transsion.ad.middle.icon

import android.text.TextUtils
import com.blankj.utilcode.util.Utils
import com.hisavana.common.bean.TAdErrorCode
import com.hisavana.common.bean.TAdNativeInfo
import com.hisavana.common.bean.TAdRequestBody
import com.hisavana.common.interfacz.TAdListener
import com.hisavana.mediation.ad.TNativeAd
import com.transsion.ad.AdLogger
import com.transsion.ad.hi.HiSavanaAdManager
import com.transsion.ad.scene.SceneCommonConfig
import com.transsion.ad.middle.WrapperAdListener
import com.transsion.ad.monopoly.model.MbAdSource

/**
 * @author: zhangxinbing
 * @date : 2024/5/28 18:00
 * @description: Icon 广告独立出来,没有缓存
 */
class HiSavanaIconAdManager : TAdListener() {

    /**
     * 当前正在请求中
     */
    private var isLoading = false

    /**
     * 广告加载对象 负责广告的加载
     */
    private var tNativeAd: TNativeAd? = null

    private var mListener: WrapperAdListener? = null

    /**
     * 场景调用的时候传进来的场景ID
     */
    private var mSceneId: String? = null

    private fun getClassTag(): String = javaClass.simpleName


    // ============================ 广告SDK回调 =====================================================


    /**
     * 广告数据加载完成还未展示，此回调方法适用于Banner、Interstitial、Splash 和 preload 类型的Native广告
     *
     * 获取到广告之后保存到本地缓存池
     */
    override fun onLoad() {
        super.onLoad()
        // 获取到广告了修改状态
        isLoading = false

        // 将结果进行分发
        dispense()
    }

    /**
     * 请求过程中发生错误的回调
     */
    override fun onError(p0: TAdErrorCode?) {
        isLoading = false
        p0?.let {
            mListener?.onError(
                TAdErrorCode(
                    it.errorCode, it.errorMessage + "-- placementId = " + getPlacementId()
                )
            )
        }
    }

    override fun onShow(source: Int) {
        mListener?.onShow(source)
    }

    override fun onNativeFeedShow(source: Int, tNativeInfo: TAdNativeInfo?) {
        super.onNativeFeedShow(source, tNativeInfo)
        mListener?.onNativeFeedShow(source, tNativeInfo)
    }

    override fun onShowError(source: TAdErrorCode?) {
        super.onShowError(source)
        mListener?.onShowError(source)
    }

    override fun onClicked(source: Int) {
        mListener?.onClicked(source)
    }

    override fun onNativeFeedClicked(source: Int, tNativeInfo: TAdNativeInfo?) {
        super.onNativeFeedClicked(source, tNativeInfo)
        mListener?.onClicked(source)
    }

    override fun onClosed(p0: Int) {
        mListener?.onClosed(p0)
    }


    // ======================================== API ================================================


    /**
     * 资源回收
     */
    fun destroy() {
        mListener = null
        tNativeAd?.destroy()
        tNativeAd = null
    }

    /**
     * 设置回调
     */
    fun setListener(listener: WrapperAdListener) {
        mListener = listener
    }

    /**
     * 场景信息传递进来
     */
    fun setSceneId(sceneId: String) {
        mSceneId = sceneId
    }

    fun getSceneId(): String? = mSceneId

    /**
     * 获取广告加载对象
     */
    fun getNativeAd(): TNativeAd? = tNativeAd

    /**
     * 加载广告
     */
    fun loadAd() {
        // 如果没有初始化，那就不进行任何操作
        if (HiSavanaAdManager.isInitialized().not()) {
            mListener?.onError(
                TAdErrorCode(
                    MbAdSource.MB_AD_SOURCE_HISAVANA, "广告SDK没有初始化"
                )
            )
            return
        }

        // 如果配置为空那就直接返回
        if (TextUtils.isEmpty(getPlacementId())) {
            mListener?.onError(
                TAdErrorCode(
                    MbAdSource.MB_AD_SOURCE_HISAVANA, "当前场景配置不存在"
                )
            )
            return
        }

        // 如果正在请求中那就return 这个isLoading 仅在SDK回调的onLoad和onError修改
        if (isLoading) {
            return
        }
        isLoading = true

        // 触发埋点 因为一个触发有多个展示，所以Icon广告没有埋点触发和展示
        // AdReportManager.trigger(sceneId = getSceneId() ?: "", MbAdType.MB_AD_TYPE_ICON)

        // 加载广告
        if (null == tNativeAd) {
            tNativeAd = TNativeAd(Utils.getApp(), getPlacementId())
            tNativeAd?.setRequestBody(
                TAdRequestBody.AdRequestBodyBuild().setAdListener(this).build()
            )
            AdLogger.logSdkIcon(
                "${getClassTag()} --> loadAd() --> mPlacementId = ${getPlacementId()} --> create TNativeAd() =================== "
            )
        }

//        AdLogger.logSdkIcon("${getClassTag()} --> loadAd() --> 开始加载广告 --> mSceneId = ${getSceneId()}")
        tNativeAd?.loadAd()
    }


    // =============================================================================================


    /**
     * 获取HiSavana 广告位ID
     */
    private fun getPlacementId(): String {
        return SceneCommonConfig.getHiSavanaPlacementId(getSceneId()) ?: ""
    }

    /**
     * 分发结果
     */
    private fun dispense() {
        // getNativeAdInfo()	获取Native广告，返回一个List(2.6.8.+新增)
        // getNativeInfoSize()	获取当前可用的广告的数量(2.6.8.+新增)
        val nativeAdInfo = tNativeAd?.nativeAdInfo
//        AdLogger.logSdkIcon("${getClassTag()} --> dispense() --> nativeAdInfo?.size = ${nativeAdInfo?.size} --> 回调出去 --> mSceneId = ${getSceneId()}")
        nativeAdInfo?.let {
            mListener?.onHiIconAdReady(it)
        }
    }

}