package com.transsion.ad.middle.icon

import com.transsion.ad.middle.WrapperAdListener
import com.transsion.ad.ps.PSDistributionRequestManager
import com.transsion.ad.ps.PsLinkUtils
import com.transsion.ad.ps.model.RecommendInfo
import com.transsion.ad.scene.SceneCommonConfig

/**
 * @author: zhangxinbing
 * @date : 2025/5/14 10:17
 * @description: PS 接口请求
 */
class PSDistributionProvider : WrapperAdListener() {

    private var mListener: WrapperAdListener? = null  // 通用回调接口
    private var isFilteringInstalled: Boolean = false // 是否过滤已安装


    // =============================================================================================


    override fun onPSDistributionReady(data: MutableList<RecommendInfo>?) {
        super.onPSDistributionReady(data)

        val value: MutableList<RecommendInfo>?
        if (isFilteringInstalled) {
            // 过滤一下数据
            val temporaryStoragePs: MutableList<RecommendInfo> = mutableListOf()
            data?.forEach { itemInfo ->
                // 判断当前应用是否已经安装 -- 如果已经安装了那就不向用户展示了
                if (PsLinkUtils.checkAppInstalled(itemInfo.packageName).not()) {
                    temporaryStoragePs.add(itemInfo)
                }
            }
            value = temporaryStoragePs
        } else {
            value = data
        }

        // 将结果回调出去
        mListener?.onPSDistributionReady(value)
    }


    // =============================================================================================


    fun destroy() {
        mListener = null
    }

    /**
     * 设置回调
     */
    fun setListener(listener: WrapperAdListener?) {
        mListener = listener
    }

    fun setFilteringInstalled(isFilteringInstalled: Boolean) {
        this.isFilteringInstalled = isFilteringInstalled
    }

    /**
     * 加载广告
     */
    suspend fun loadAd(
        pageIndex: Int = 0,
        retry: Boolean = true,
        scene: String,
        pushModel: String = "",
    ) {
        PSDistributionRequestManager.getPsLinkListV2(
            pageIndex = pageIndex,
            retry = retry,
            pageSize = getX(scene = scene),
            scene = scene,
            pushModel = pushModel,
            listener = this
        )
    }

    /**
     * 获取 PS列表请求数量
     */
    private fun getX(scene: String): Int {
        return SceneCommonConfig.getSceneX(
            sceneId = scene, default = PSDistributionRequestManager.PAGE_SIZE
        )
    }

}