package com.transsion.ad.middle.icon

import android.content.Context
import android.os.Handler
import android.os.Looper
import android.text.TextUtils
import android.view.View
import com.hisavana.common.bean.TAdErrorCode
import com.hisavana.common.bean.TAdNativeInfo
import com.hisavana.mediation.ad.TAdNativeView
import com.transsion.ad.AdLogger
import com.transsion.ad.middle.WrapperAdListener
import com.transsion.ad.middle.nativead.AbsAdLayoutProvider
import com.transsion.ad.monopoly.model.MbAdSource
import com.transsion.ad.monopoly.model.MbAdType
import com.transsion.ad.ps.model.RecommendInfo
import com.transsion.ad.report.AdReportProvider
import com.transsion.ad.scene.SceneOnOff
import com.transsion.ad.scene.SceneStorage
import kotlinx.coroutines.runBlocking
import java.util.concurrent.atomic.AtomicBoolean

/**
 * @author: zhangxinbing
 * @date : 2025/5/14 10:17
 * @description: 加载 Icon = PS + HI
 */
class WrapperIconAdManager : WrapperAdListener() {

    private var hiIconView: View? = null
    private var mCallback: WrapperAdListener? = null // 回调
    private var mSceneId: String? = null // 广告场景ID
    private var targetNum: Int = 0  // 默认返回一条数据
    private var buyOutIconViewSet: MutableSet<BuyOutIconView?> = mutableSetOf() // 包断广告IconView
    private var tAdNativeViewSet: MutableSet<TAdNativeView?> = mutableSetOf() // 包断广告IconView
    private var tAdNativeInfoSet: MutableSet<TAdNativeInfo?> = mutableSetOf() // 包断广告IconView
    private var isLoading: AtomicBoolean = AtomicBoolean(false) // 标记是否正在加载中
    private fun getClassTag(): String = javaClass.simpleName

    private val mHandler by lazy {
        Handler(Looper.getMainLooper())
    } // 用于竞价计时

    private val delayRunnable = Runnable {
        assemblyData("竞价时间到")
        isLoading.set(false)
    } // 延时活动

    /**
     * 两个接口暂存数据
     */
    private var temporaryStorageHi: MutableList<TAdNativeInfo> = mutableListOf()
    private var temporaryStoragePs: MutableList<RecommendInfo> = mutableListOf()

    /**
     * Icon 广告加载对象
     */
    private var adManager: HiSavanaIconAdManager? = null
    private var pSDistribution: PSDistributionProvider? = null


    // ================================ 广告数据结果回调 ==============================================


    override fun onPSDistributionReady(data: MutableList<RecommendInfo>?) {
        super.onPSDistributionReady(data)
        AdLogger.logSdkIcon("${getClassTag()} --> onPSDistributionReady() --> mSceneId = ${getSceneId()} --> data.size = ${data?.size}")
        temporaryStoragePs.clear()
        data?.let {
            temporaryStoragePs.addAll(data)
        }
        // 其他数据是否回来了
        if (temporaryStorageHi.isNotEmpty()) {
            mHandler.post {
                assemblyData("数据都回来了 --> onPSDistributionReady")
            }
        }
    }

    override fun onHiIconAdReady(tAdNativeInfos: MutableList<TAdNativeInfo>) {
        super.onHiIconAdReady(tAdNativeInfos)
        AdLogger.logSdkIcon("${getClassTag()} --> onIconAdReady() --> mSceneId = ${getSceneId()} --> tAdNativeInfos.size =  = ${tAdNativeInfos.size}")

        // 保存数据
        tAdNativeInfos.let {
            temporaryStorageHi.clear()
            temporaryStorageHi.addAll(it)
        }
        // 其他数据是否回来了
        if (temporaryStoragePs.isNotEmpty()) {
            mHandler.post {
                assemblyData("数据都回来了 --> onHiIconAdReady")
            }
        }
    }

    override fun onError(p0: TAdErrorCode?) {
        super.onError(p0)
        AdLogger.logSdkIcon("${getClassTag()} --> onError() --> p0 = $p0 --> mSceneId = ${getSceneId()}")
    }

    override fun onClicked(p0: Int) {
        super.onClicked(p0)
        //AdLogger.logSdkIcon("${getClassTag()} --> onClicked() --> p0 = $p0 --> mSceneId = ${getSceneId()}")
        // 统一上报点击埋点
        AdReportProvider.adClick(
            triggerId = "",
            sceneId = getSceneId(),
            adPlanId = "",
            adSource = p0,
            adId = "",
            adType = MbAdType.MB_AD_TYPE_ICON,
            psId = null
        )

        mCallback?.onClicked(MbAdSource.MB_AD_SOURCE_HISAVANA)
    }

    override fun onMbIconClick(info: RecommendInfo?) {
        super.onMbIconClick(info)
        // 统一上报点击埋点
        AdReportProvider.adClick(
            triggerId = "",
            sceneId = getSceneId(),
            adPlanId = "",
            adSource = MbAdSource.MB_AD_SOURCE_BUY_OUT,
            adId = "",
            adType = MbAdType.MB_AD_TYPE_ICON,
            psId = info?.id
        )

        mCallback?.onClicked(MbAdSource.MB_AD_SOURCE_BUY_OUT)
    }

    override fun onShow(p0: Int) {
        super.onShow(p0)
        //AdLogger.logSdkIcon("${getClassTag()} --> onShow() --> p0 = $p0 --> mSceneId = ${getSceneId()}")
        // 统一上报展示埋点
        AdReportProvider.display(
            triggerId = "",
            sceneId = getSceneId(),
            adPlanId = "",
            adSource = p0,
            adId = "",
            adType = MbAdType.MB_AD_TYPE_ICON,
            psId = null
        )
    }

    override fun onMbIconShow(info: RecommendInfo?) {
        super.onMbIconShow(info)
        AdReportProvider.display(
            triggerId = "",
            sceneId = getSceneId(),
            adPlanId = "",
            adSource = MbAdSource.MB_AD_SOURCE_BUY_OUT,
            adId = "",
            adType = MbAdType.MB_AD_TYPE_ICON,
            psId = info?.id
        )
    }


    // =============================================================================================


    /**
     * 资源回收
     */
    fun destroy() {
        mHandler.removeCallbacksAndMessages(null)
        mCallback = null
        temporaryStorageHi.clear()
        temporaryStoragePs.clear()
        pSDistribution?.destroy()
        buyOutIconViewSet.forEach {
            it?.destroy()
        }
        tAdNativeViewSet.forEach {
            it?.release()
        }
        tAdNativeInfoSet.forEach {
            it?.release()
        }
    }

    fun getSceneId(): String? = mSceneId

    /**
     * 加载广告
     */
    suspend fun loadIconAd(
        sceneId: String, isFilteringInstalled: Boolean, targetNum: Int, listener: WrapperAdListener?
    ) {
        val errorMsg = SceneOnOff.isSceneOffV2(sceneId)
        if (TextUtils.isEmpty(errorMsg).not()) {
            onFailCallback(listener = listener, errorMsg = errorMsg)
            return
        }

        if (isLoading.get()) {
            return
        }
        isLoading.set(true)
        mCallback = listener
        mSceneId = sceneId
        this.targetNum = targetNum

        // 加载广告
        innerLoadAd(sceneId, isFilteringInstalled)
    }


    // =================================== 广告展示 ==================================================


    /**
     * 展示广告
     */
    fun bindHiIconView(
        absAdLayoutProvider: AbsAdLayoutProvider?,
        tAdNativeView: TAdNativeView?,
        viewContext: Context?,
        nativeInfo: TAdNativeInfo?
    ) {
        nativeInfo?.let { info ->
            absAdLayoutProvider?.getHiViewBinder(
                adLayoutProvider = absAdLayoutProvider.getAdLayoutProvider(viewContext),
                mNativeInfo = nativeInfo
            )?.let { binder ->
                tAdNativeView?.let { tAdNativeView ->
                    adManager?.getNativeAd()?.bindNativeView(tAdNativeView, info, binder)
                }
            }
        }

        // 保存一下数据 资源回收
        tAdNativeViewSet.add(tAdNativeView)
        tAdNativeInfoSet.add(nativeInfo)

        runBlocking {
            absAdLayoutProvider?.getIconId()?.let {
                hiIconView =
                    absAdLayoutProvider.getAdLayout(viewContext = viewContext).findViewById(it)
            }
        }

    }

    fun bindPsIconView(
        recommendInfo: RecommendInfo?,
        absAdLayoutProvider: AbsAdLayoutProvider?,
        buyOutIconView: BuyOutIconView?,
        viewContext: Context?,
    ) {
        buyOutIconView?.setCallback(this)
        buyOutIconView?.setSceneId(sceneId = getSceneId())
        buyOutIconView?.bindNativeView(
            recommendInfo = recommendInfo,
            adLayoutProvider = absAdLayoutProvider?.getAdLayoutProvider(viewContext)
        )
        buyOutIconViewSet.add(buyOutIconView)
    }

    fun clickAd() {
        AdLogger.logSdkIconE("${getClassTag()} --> clickAd() --> 模拟点击广告")
        runBlocking {
            if (buyOutIconViewSet.isNotEmpty()) {
                buyOutIconViewSet.first()?.clickAd()
            }
        }

        runBlocking {
            hiIconView?.performClick()
        }

    }


    // ===================================== 加载数据 ================================================


    /**
     * 失败回调
     */
    private fun onFailCallback(listener: WrapperAdListener?, errorMsg: String) {
        AdLogger.logSdkIconE(errorMsg)
        listener?.onError(TAdErrorCode(MbAdSource.MB_AD_SOURCE_WRAPPER_AD, errorMsg))
    }

    /**
     * 获取竞价时间 s
     */
    private fun getBindingTime(): Int {
        return SceneStorage.getSceneConfig(getSceneId())?.get("bindingTime")?.asInt ?: 2
    }

    /**
     * 获取优先级
     * ps hi
     */
    private fun isHiPriority(): Boolean {
        return TextUtils.equals(
            SceneStorage.getSceneConfig(getSceneId())?.get("priority")?.asString ?: "hi", "hi"
        )
    }

    /**
     * 加载广告
     */
    private suspend fun innerLoadAd(sceneId: String, isFilteringInstalled: Boolean) {
        val error = SceneOnOff.isSceneOffV2(sceneId)
        if (TextUtils.isEmpty(error).not()) {
            return
        }

        AdLogger.logSdkIcon(
            "${getClassTag()} --> innerLoadAd() --> 开始加载广告 --> sceneId = $sceneId",
            writeToFile = false
        )

        // 场景开关判断
        if (SceneOnOff.isSceneHiOff(sceneId).not()) {
            // PS 接口和EW同时请求
            // 1. 加载HiSavana广告
            if (adManager == null) {
                adManager = HiSavanaIconAdManager()
                adManager?.setSceneId(sceneId)
                adManager?.setListener(this)
            }
            adManager?.loadAd()
        }

        // 场景开关判断
        if (SceneOnOff.isSceneNonOff(sceneId).not()) {
            // 2. 加载PS商单
            if (pSDistribution == null) {
                pSDistribution = PSDistributionProvider()
                pSDistribution?.setListener(this)
                pSDistribution?.setFilteringInstalled(isFilteringInstalled)
            }
            pSDistribution?.loadAd(scene = sceneId)
        }

        // 3. 竞价时间是4秒
        mHandler.postDelayed(delayRunnable, getBindingTime() * 1000L)
    }


    // ================================== 处理数据 ===================================================


    /**
     * 结果回来之后进行展示
     *
     * 因为是并行发起两个请求，最多等待4秒之后开始展示数据。
     */
    private fun assemblyData(msg: String = "") {
        // 重置延时消息
        mHandler.removeCallbacks(delayRunnable)
        runCatching {
            // 组装数据
            val excessiveList = combineAndRetrieveData(isHiFirst = isHiPriority())
            AdLogger.logSdkIcon("${getClassTag()} --> assemblyData() --> msg = $msg --> targetNum = $targetNum --> 组装数据 --> size = ${excessiveList.size}")

            val value = if (targetNum > 0) {
                excessiveList.take(targetNum).toMutableList()
            } else {
                excessiveList
            }
            mCallback?.onWrapperIconReady(value)
        }
    }

    private fun getHi(): WrapperIconBean {
        val downloadInterceptEntity = WrapperIconBean(
            type = WrapperIconBean.WRAPPER_ICON_ITEM_HI,
            recommendInfo = null,
            nativeInfo = temporaryStorageHi.removeAt(0)
        )
        return downloadInterceptEntity
    }

    private fun getPs(): WrapperIconBean {
        val downloadInterceptEntity = WrapperIconBean(
            type = WrapperIconBean.WRAPPER_ICON_ITEM_PS,
            recommendInfo = temporaryStoragePs.removeAt(0),
            nativeInfo = null
        )
        return downloadInterceptEntity
    }

    private fun combineAndRetrieveData(isHiFirst: Boolean = false): MutableList<WrapperIconBean> {
        val result = mutableListOf<WrapperIconBean>()
        var index = 0

        while (temporaryStorageHi.isNotEmpty() || temporaryStoragePs.isNotEmpty()) {
            val isHiTurn = if (isHiFirst) index % 2 == 0 else index % 2 == 1

            if (isHiTurn) {
                if (temporaryStorageHi.isNotEmpty()) {
                    result.add(getHi())
                } else if (temporaryStoragePs.isNotEmpty()) {
                    result.add(getPs())
                }
            } else {
                if (temporaryStoragePs.isNotEmpty()) {
                    result.add(getPs())
                } else if (temporaryStorageHi.isNotEmpty()) {
                    result.add(getHi())
                }
            }
            index++
        }
        return result
    }
}