package com.transsion.ad.middle.intercept

import android.app.Activity
import com.blankj.utilcode.util.ActivityUtils
import com.hisavana.common.bean.TAdErrorCode
import com.hisavana.common.interfacz.TAdListener
import com.hisavana.mediation.ad.TBaseAd
import com.transsion.ad.AdLogger
import com.transsion.ad.report.AdReportProvider
import com.transsion.ad.hi.HiSavanaAdManager
import com.transsion.ad.scene.SceneCommonConfig
import com.transsion.ad.middle.WrapperAdListener
import com.transsion.ad.monopoly.model.MbAdSource

/**
 * @author: zhangxinbing
 * @date : 2024/7/23 11:22
 * @description:
 */
@Deprecated("使用 BiddingInterstitialManager")
internal abstract class BaseInterceptHiSavanaAdManager(private val mSceneId: String) :
    TAdListener() {

    /***外部接收广告状态回调*/
    private var mListener: WrapperAdListener? = null

    /***插屏广告是否正在展示*/
    private var isShowing = false

    protected fun getClassTag(): String = javaClass.simpleName

    companion object {
        const val HI_SAVANA_AD_SHOW_ERROR_IS_SHOWING_TAG = "当前正在展示Hi广告"
    }


    // ======================= 下面是广告SDK回调 ======================================================


    /**
     * 广告数据加载完成还未展示，此回调方法适用于Banner、Interstitial、Splash 和 preload 类型的Native广告
     */
    override fun onLoad() {
        super.onLoad()
        AdLogger.logSdkIntercept(
            "${getClassTag()} --> onLoad() --> 广告加载成功 --> mSceneId = $mSceneId -- hiId = ${
                SceneCommonConfig.getHiSavanaPlacementId(
                    mSceneId
                )
            }"
        )
        mListener?.onLoad()
    }

    /**
     * 请求过程中发生错误的回调
     */
    override fun onError(errorCode: TAdErrorCode?) {
        AdLogger.logSdkInterceptE(
            "${getClassTag()} --> onError() --> errorCode = $errorCode --> mSceneId = $mSceneId -- hiId = ${
                SceneCommonConfig.getHiSavanaPlacementId(
                    mSceneId
                )
            }"
        )
        mListener?.onError(errorCode)
    }

    /**
     * 广告展示失败回调
     */
    override fun onShowError(errorCode: TAdErrorCode?) {
        super.onShowError(errorCode)
        AdLogger.logSdkInterceptE(
            "${getClassTag()} --> onShowError() --> errorCode = $errorCode --> mSceneId = $mSceneId -- hiId = ${
                SceneCommonConfig.getHiSavanaPlacementId(
                    mSceneId
                )
            }"
        )
        mListener?.onShowError(errorCode)
    }

    /**
     * 广告展示成功回调
     */
    override fun onShow(source: Int) {
        isShowing = true

        AdLogger.logSdkIntercept(
            "${getClassTag()} --> onShow() --> mSceneId = $mSceneId -- hiId = ${
                SceneCommonConfig.getHiSavanaPlacementId(
                    mSceneId
                )
            }"
        )
        AdReportProvider.display(
            sceneId = mSceneId,
            adPlanId = "",
            adSource = source,
            adId = getHiId(),
            adType = getAdType(),
            isAdShowFinal = false,
            psId = null
        )
        mListener?.onShow(source)
    }

    /**
     * 广告点击回调
     */
    override fun onClicked(source: Int) {
        AdLogger.logSdkIntercept(
            "${getClassTag()} --> onClicked() --> source = $source --> mSceneId = $mSceneId -- hiId = ${
                SceneCommonConfig.getHiSavanaPlacementId(
                    mSceneId
                )
            }"
        )
        AdReportProvider.adClick(
            sceneId = mSceneId,
            adPlanId = "",
            adSource = source,
            adId = getHiId(),
            adType = getAdType(),
            isAdShowFinal = false,
            psId = null
        )
        mListener?.onClicked(source)
    }

    /**
     * 广告关闭回调，并不是所有广告都会唤起此方法。
     */
    override fun onClosed(source: Int) {
        isShowing = false

        AdLogger.logSdkIntercept(
            "${getClassTag()} --> onClosed() --> source = $source --> mSceneId = $mSceneId -- hiId = ${
                SceneCommonConfig.getHiSavanaPlacementId(
                    mSceneId
                )
            }"
        )
        mListener?.onClosed(source)
        // 广告展示完毕 -- 资源回收
        innerReset()
    }

    /**
     * 激励视频广告播放完毕
     */
    override fun onRewarded() {
        super.onRewarded()
        AdLogger.logSdkIntercept(
            "${getClassTag()} --> onRewarded() --> mSceneId = $mSceneId -- hiId = ${
                SceneCommonConfig.getHiSavanaPlacementId(
                    mSceneId
                )
            }"
        )
        mListener?.onRewarded()
    }


    // ================================ 抽象方法 父类定义 =============================================


    abstract fun getAdType(): Int

    abstract fun getAdInstance(): TBaseAd<*>?

    abstract fun show(topActivity: Activity, ctxMap: Map<String, Any>?)

    abstract fun reset()


    // ============================= API ===========================================================


    /**
     * 将回调设置进来
     */
    fun setListener(listener: WrapperAdListener?): BaseInterceptHiSavanaAdManager {
        mListener = listener
        return this
    }

    /**
     * 资源回收 -- 因为是全局的所以只需要断开引用就可以了
     */
    fun destroy() {
        setListener(null)
    }

    /**
     * 加载广告
     */
    fun load(tag: String? = null) {
        AdLogger.logSdkIntercept(
            "${getClassTag()} --> load() --> $tag --> mSceneId = $mSceneId -- hiId = ${
                SceneCommonConfig.getHiSavanaPlacementId(
                    mSceneId
                )
            }"
        )
        innerLoad()
    }

    /**
     * 展示广告
     */
    fun showAd(ctxMap: Map<String, Any>?) {
        AdLogger.logSdkIntercept(
            "${getClassTag()} --> showAd() --> mSceneId = $mSceneId -- hiId = ${
                SceneCommonConfig.getHiSavanaPlacementId(
                    mSceneId
                )
            }"
        )
        innerShowAd(ctxMap)
    }


    // ================================ 内部逻辑 =====================================================


    /**
     * 广告加载流程
     */
    private fun innerLoad() {
        // 如果没有初始化，那就不进行任何操作
        if (HiSavanaAdManager.isInitialized().not()) {
            AdLogger.logSdkIntercept(
                "${getClassTag()} --> innerLoad() --> 广告SDK没有初始化 --> mSceneId = $mSceneId -- hiId = ${
                    SceneCommonConfig.getHiSavanaPlacementId(
                        mSceneId
                    )
                }"
            )
            mListener?.onError(
                TAdErrorCode(
                    MbAdSource.MB_AD_SOURCE_HISAVANA, "广告SDK没有初始化 --> mSceneId = $mSceneId"
                )
            )
            return
        }

        // 如果不存在广告，那就重新加载，SDK内部处理了重复调用
        if (isShowing) {
            AdLogger.logSdkIntercept(
                "${getClassTag()} --> innerLoad() --> $HI_SAVANA_AD_SHOW_ERROR_IS_SHOWING_TAG --> mSceneId = $mSceneId -- hiId = ${
                    SceneCommonConfig.getHiSavanaPlacementId(
                        mSceneId
                    )
                }"
            )
            mListener?.onError(
                TAdErrorCode(
                    MbAdSource.MB_AD_SOURCE_HISAVANA, HI_SAVANA_AD_SHOW_ERROR_IS_SHOWING_TAG
                )
            )
            return
        }

        if (getAdInstance()?.hasAd() == false) {
            getAdInstance()?.loadAd()
        } else {
            AdLogger.logSdkIntercept(
                "${getClassTag()} --> innerLoad() --> 广告已经加载完成 不需要重复加载了 -- isShowing = $isShowing -- hasAd = ${getAdInstance()?.hasAd()} --> mSceneId = $mSceneId -- hiId = ${
                    SceneCommonConfig.getHiSavanaPlacementId(
                        mSceneId
                    )
                }"
            )
            // 已经存在广告了直接返回
            mListener?.onLoad()
        }
    }

    /**
     * 广告展示流程
     */
    private fun innerShowAd(ctxMap: Map<String, Any>?) {
        // 如果已经是广告页面了，那就不展示广告了
        val topActivity = ActivityUtils.getTopActivity()
        if (null == topActivity) {
            AdLogger.logSdkInterceptE("${getClassTag()} --> null == topActivity --> mSceneId = $mSceneId -- hiId = ${getHiId()}")
            mListener?.onShowError(
                TAdErrorCode(
                    MbAdSource.MB_AD_SOURCE_HISAVANA, "null == topActivity --> mSceneId = $mSceneId"
                )
            )
            return
        }

        if (isShowing) {
            AdLogger.logSdkInterceptE("${getClassTag()} --> showAd() --> isShowing = $isShowing -- 当前正在展示插屏广告，return -- hiId = ${getHiId()}")
            mListener?.onShowError(
                TAdErrorCode(
                    MbAdSource.MB_AD_SOURCE_HISAVANA,
                    "showAd() --> $HI_SAVANA_AD_SHOW_ERROR_IS_SHOWING_TAG --> mSceneId = $mSceneId"
                )
            )
            return
        }

        if (getAdInstance()?.hasAd() == true) {
            AdLogger.logSdkIntercept("${getClassTag()} --> showAd() --> 开始展示广告 --> mSceneId = $mSceneId -- hiId = ${getHiId()}")
            // 在到达广告场景时可以优先调用，我们会根据此方法来更好的展示广告(2.6.8.+新增)
            getAdInstance()?.enterScene(mSceneId, 1)
            show(topActivity, ctxMap)
        } else {
            AdLogger.logSdkIntercept("${getClassTag()} --> showAd() --> 开始展示广告 -- 当前还没有广告 --> mSceneId = $mSceneId -- hiId = ${getHiId()}")
            mListener?.onShowError(
                TAdErrorCode(
                    MbAdSource.MB_AD_SOURCE_HISAVANA, "当前还没有广告 --> mSceneId = $mSceneId"
                )
            )

            // 如果直接展示失败了之后就不在继续回调后续的事件了
            destroy()

            // 同步加载一个
            load("showAd() -- 当前还没有广告 -- load()")
        }
    }

    /**
     * onClosed() --> 资源回收 --> 预加载
     */
    private fun innerReset() {
        getAdInstance()?.destroy()
        reset()
        mListener = null
        AdLogger.logSdkIntercept(
            "${getClassTag()} --> destroy() --> 资源回收 -- tInterstitialAd = null -->  load() --> mSceneId = $mSceneId -- hiId = ${getHiId()}"
        )

        // 同步加载一个
        load("innerReset() -- 预加载一个插屏广告")
    }

    private fun getHiId(): String? {
        return SceneCommonConfig.getHiSavanaPlacementId(mSceneId)
    }

}