package com.transsion.ad.middle.intercept

import android.annotation.SuppressLint
import android.content.Intent
import android.content.pm.ActivityInfo
import android.os.Build
import android.os.Bundle
import android.os.Handler
import android.os.Looper
import android.text.TextUtils
import android.view.TextureView
import android.view.View
import android.view.ViewGroup
import android.view.Window
import android.widget.ImageView
import androidx.activity.OnBackPressedCallback
import androidx.appcompat.app.AppCompatActivity
import androidx.localbroadcastmanager.content.LocalBroadcastManager
import com.bumptech.glide.Glide
import com.transsion.ad.AdLogger
import com.transsion.ad.report.AdReportProvider
import com.transsion.ad.monopoly.intercept.NonAdShowedTimesManager
import com.transsion.ad.monopoly.model.AdMaterialList
import com.transsion.ad.monopoly.model.AdPlans
import com.transsion.ad.monopoly.model.MbAdShowLevel
import com.transsion.ad.strategy.AdClickManager
import com.transsion.ad.strategy.MeasureManager
import com.transsion.player.MediaSource
import com.transsion.player.config.VodConfig
import com.transsion.player.orplayer.IPlayerListener
import com.transsion.player.orplayer.ORPlayer
import com.transsion.player.orplayer.PlayError
import com.transsion.ad.monopoly.model.MbAdSource
import com.transsion.ad.monopoly.model.MbAdType
import com.transsion.ad.monopoly.plan.AdPlanUtil

/**
 * @author: zhangxinbing
 * @date : 2024/7/22 15:55
 * @description:
 */
@Deprecated("使用 BiddingInterstitialManager")
internal abstract class BaseInterceptMbAdActivity : AppCompatActivity(),
    MeasureManager.ViewVisibilityListener {


    // =============================================================================================


    companion object {

        /**
         * 跨进城传递数据 key
         */
        const val NON_INTERSTITIAL_AD_ACTIVITY_EXTRA_AD_PLAN =
            "com.transsion.wrapperad.middle.intercept.BaseInterceptAdActivity.AdPlan"

        const val NON_INTERSTITIAL_ACTIVITY_EXTRA_SCENE_ID =
            "com.transsion.wrapperad.middle.intercept.BaseInterceptAdActivity.SceneId"

        /**
         * 插屏 -- 本地广播 -- 广告关闭
         */
        const val NON_INTERCEPT_ACTIVITY_LOCAL_BROADCAST_ACTION_ON_DESTROY_INTERSTITIAL =
            "com.transsion.wrapperad.middle.intercept.BaseInterceptAdActivity.Action.onDestroy.Interstitial"

        /**
         * 插屏 -- 获取奖励
         */
        const val NON_INTERCEPT_ACTIVITY_LOCAL_BROADCAST_ACTION_ON_REWARDED_INTERSTITIAL =
            "com.transsion.wrapperad.middle.intercept.BaseInterceptAdActivity.Action.onRewarded.Interstitial"

        /**
         * 插屏 -- 展示
         */
        const val NON_INTERCEPT_ACTIVITY_LOCAL_BROADCAST_ACTION_ON_SHOW_INTERSTITIAL =
            "com.transsion.wrapperad.middle.intercept.BaseInterceptAdActivity.Action.onShow.Interstitial"

        /**
         * 激励视频 -- 本地广播 -- 广告关闭
         */
        const val NON_INTERCEPT_ACTIVITY_LOCAL_BROADCAST_ACTION_ON_DESTROY_VIDEO =
            "com.transsion.wrapperad.middle.intercept.BaseInterceptAdActivity.Action.onDestroy.Video"

        /**
         * 激励视频 -- 获取奖励
         */
        const val NON_INTERCEPT_ACTIVITY_LOCAL_BROADCAST_ACTION_ON_REWARDED_VIDEO =
            "com.transsion.wrapperad.middle.intercept.BaseInterceptAdActivity.Action.onRewarded.Video"

        /**
         * 激励视频 -- 展示
         */
        const val NON_INTERCEPT_ACTIVITY_LOCAL_BROADCAST_ACTION_ON_SHOW_VIDEO =
            "com.transsion.wrapperad.middle.intercept.BaseInterceptAdActivity.Action.onShow.Video"
    }


    // =============================================================================================


    /**
     * 广告位 信息
     */
    var mAdPlan: AdPlans? = null

    private var mSceneId: String? = null

    /**
     * 非标广告素材信息
     */
    var mAdMaterialList: AdMaterialList? = null

    /**
     * 视频播放器
     */
    private var mOrPlayer: ORPlayer? = null

    /**
     * 当前界面是否可以销毁
     */
    private var isCanFinish: Boolean = false

    /**
     * 是否展示关闭广告弹窗
     */
    private var isShowCloseAdDialog: Boolean = false

    /**
     * 是否打开视频的声音
     */
    private var mIsMute: Boolean = true

    /**
     * 广告倒计时
     */
    private val mHandler = Handler(Looper.getMainLooper())


    // ================================ 生命周期方法 =================================================


    @SuppressLint("SourceLockedOrientationActivity")
    override fun onCreate(savedInstanceState: Bundle?) {
        // 广告默认竖屏展示
        if (Build.VERSION.SDK_INT != Build.VERSION_CODES.O) {
            requestedOrientation = ActivityInfo.SCREEN_ORIENTATION_PORTRAIT
        }
        super.onCreate(savedInstanceState)
        // 移除标题
        requestWindowFeature(Window.FEATURE_NO_TITLE)

        setContentView(setAdContentView())

        // 初始化数据
        initData()

        // 展示广告
        showAd()

        onBackPressedDispatcher.addCallback(this, object : OnBackPressedCallback(true) {
            override fun handleOnBackPressed() {
                if (isCanFinish.not()) {
                    // 激励视频有弹窗提示
                    if (getAdType() == MbAdType.MB_AD_TYPE_VIDEO) {
                        // Close Ad 弹窗
                        showCloseAdDialog()
                    }
                } else {
                    finish()
                }
            }
        })

        // 广告点击事件
        setAdClick()
    }

    override fun onDestroy() {
        super.onDestroy()

        mOrPlayer?.release()

        // 创建一个Intent，指定广播的动作
        val intent = getAdDestroyIntent()
        // 添加额外的数据（如果需要）
        intent.putExtra("key", "value")
        LocalBroadcastManager.getInstance(this).sendBroadcast(intent)

        // 移除
        MeasureManager.removeSession(this)
    }


    // ============================= 抽象方法 父类定义 ================================================


    abstract fun setAdContentView(): Int

    abstract fun getAdType(): Int

    abstract fun setAdClick()

    abstract fun getAdDestroyIntent(): Intent

    abstract fun getAdShowIntent(): Intent

    abstract fun getAdImageView(): ImageView?

    abstract fun getAdTextureView(): TextureView?

    abstract fun getCountDownTimes(): Int

    abstract fun refreshCountDownView(i: Int)

    abstract fun showCloseAdDialog()

    abstract fun onAdCompletion()


    // =============================================================================================


    fun setMute(): Boolean {
        mIsMute = mIsMute.not()
        mOrPlayer?.setMute(mIsMute)
        return mIsMute
    }

    fun closeAd() {
        isCanFinish = true
        onBackPressedDispatcher.onBackPressed()
    }

    /**
     * 展示和关闭退出激励视频弹窗
     */
    fun setShowCloseAdDialog(isShow: Boolean) {
        isShowCloseAdDialog = isShow
    }

    /**
     * 广告点击事件处理
     */
    fun adClick() {
        AdReportProvider.adClick(
            sceneId = mSceneId,
            adPlanId = mAdPlan?.id,
            adSource = MbAdSource.MB_AD_SOURCE_BUY_OUT,
            adId = mAdMaterialList?.id,
            adType = getAdType(),
            isAdShowFinal = MbAdShowLevel.isAdShowLevel(mAdPlan),
            psId = AdPlanUtil.getPsId(mAdPlan)
        )
        AdClickManager.adClick(mAdMaterialList?.deeplink, mAdMaterialList?.h5Link, adPlan = mAdPlan)
    }


    // ======================= 下面是曝光监听 ========================================================


    /***广告开始展示的时间 时间戳 毫秒*/
    private var showTime = 0L

    /***是否已经上报过一次曝光了*/
    private var isReportAdDisplay = false

    override fun onVisibilityChanged(isVisible: Boolean) {
        if (isVisible) {
            play()
        } else {
            pause()
        }
    }

    fun play() {
        // 开始展示的时间
        if (showTime == 0L) {
            showTime = System.currentTimeMillis()
        }

        // 视频状态处理
        if (mOrPlayer?.isPlaying() == false && isShowCloseAdDialog.not() && mOrPlayer?.isComplete() == false) {
            mOrPlayer?.play()
        }

        // 曝光上报
        if (!isReportAdDisplay) {
            isReportAdDisplay = true
            AdReportProvider.display(
                sceneId = mSceneId,
                adPlanId = mAdPlan?.id,
                adSource = MbAdSource.MB_AD_SOURCE_BUY_OUT,
                adId = mAdMaterialList?.id,
                adType = getAdType(),
                isAdShowFinal = MbAdShowLevel.isAdShowLevel(mAdPlan),
                psId = AdPlanUtil.getPsId(mAdPlan)
            )

            AdLogger.logSdkIntercept(
                "${javaClass.simpleName} --> 广告展示 --> sceneId = $mSceneId --> isAdShowLevel = ${
                    MbAdShowLevel.isAdShowLevel(
                        mAdPlan
                    )
                }", writeToFile = false
            )

            // 广告展示
            runOnUiThread {
                val intent = getAdShowIntent()
                intent.putExtra("key", "value")
                LocalBroadcastManager.getInstance(this).sendBroadcast(intent)
            }

            // 保存展示次数
            NonAdShowedTimesManager.saveShowedTimes(mAdPlan)
        }
    }

    fun pause() {
        mOrPlayer?.pause()
        // 播放时长上报
        reportShowTime()
    }

    /**
     * 上报累计展示埋点
     */
    private fun reportShowTime() {
        if (showTime > 0) {
            // 上报曝光时长
            AdReportProvider.adShowTime(
                sceneId = mSceneId,
                adPlanId = mAdPlan?.id,
                displayTime = (System.currentTimeMillis() - showTime),
                adId = mAdMaterialList?.id,
                adType = getAdType(),
                isAdShowFinal = MbAdShowLevel.isAdShowLevel(mAdPlan)
            )
            showTime = 0
        }
    }


    // ============================ 下面是广告展示 ====================================================


    /**
     * 展示广告
     */
    private fun showAd() {
        // 目前规定一个计划只有一个素材
        mAdMaterialList = mAdPlan?.adMaterialList?.get(0)
        // 展示媒体内容
        if (mAdMaterialList?.type == AdMaterialList.NON_AD_TYPE_TEXT) {
            getAdImageView()?.visibility = View.VISIBLE
            getAdTextureView()?.visibility = View.VISIBLE
            showImage()
        } else {
            getAdImageView()?.visibility = View.GONE
            getAdTextureView()?.visibility = View.VISIBLE
            playVideo()
        }
    }

    /**
     * 图片广告
     */
    private fun showImage() {
        // 图片广告不需要展示音量按钮的
        changeAudioIconContainer(showAudioIcon = false)

        startCountDown()
        // 如果本地地址是空的，那就不使用线上地址在线加载
        getAdImageView()?.let {
            if (TextUtils.isEmpty(mAdMaterialList?.image?.path)) {
                Glide.with(this).load(mAdMaterialList?.image?.url).into(it)
            } else {
                Glide.with(this).load(mAdMaterialList?.image?.path).into(it)
            }
        }
    }

    abstract fun changeAudioIconContainer(showAudioIcon: Boolean)

    /**
     * 视频广告
     */
    private fun playVideo() {
        // 视频广告需要展示音量Icon
        changeAudioIconContainer(showAudioIcon = true)

        // 创建播放器
        mOrPlayer = ORPlayer.Builder(this)
            .vodConfig(VodConfig(clearFrameWhenStop = true, openAudioFocus = false)).builder()
            .apply {
                setMute(true)
                setTextureView(getAdTextureView())
                setLooping(getAdType() == MbAdType.MB_AD_TYPE_INTERSTITIAL) // 插屏需要循环播放，激励视频不需要循环播放
                setPlayerListener(object : IPlayerListener {

                    override fun onPlayError(
                        errorInfo: PlayError, mediaSource: MediaSource?
                    ) {
                        super.onPlayError(errorInfo, mediaSource)
                        AdLogger.logSdkInterceptE("${javaClass.simpleName} --> playVideo() --> onPlayError() --> errorInfo = $errorInfo -- sceneId = $mSceneId")
                    }

                    override fun onPrepare(mediaSource: MediaSource?) {
                        super.onPrepare(mediaSource)
                        play()
                    }

                    override fun onVideoPause(mediaSource: MediaSource?) {
                        super.onVideoPause(mediaSource)
                        pauseCountDown()
                    }

                    override fun onVideoStart(mediaSource: MediaSource?) {
                        super.onVideoStart(mediaSource)
                        startCountDown()
                    }

                    override fun onCompletion(mediaSource: MediaSource?) {
                        super.onCompletion(mediaSource)
                        pauseCountDown()
                        onAdCompletion()
                        // 这里是为了处理 视频小于倒计时时间的情况
                        isCanFinish = true
                        refreshCountDownView(0)
                    }
                })
            }

        // 开始播放
        if (TextUtils.isEmpty(mAdMaterialList?.video?.path)) {
            mOrPlayer?.setDataSource(
                MediaSource(
                    mAdMaterialList?.video?.url ?: "", mAdMaterialList?.video?.url ?: ""
                )
            )
        } else {
            mOrPlayer?.setDataSource(
                MediaSource(
                    mAdMaterialList?.video?.path ?: "", mAdMaterialList?.video?.path ?: ""
                )
            )
        }

        AdLogger.logSdkIntercept("${javaClass.simpleName} --> playVideo() --> url = ${mAdMaterialList?.video?.url} --> path = ${mAdMaterialList?.video?.path}")
        mOrPlayer?.prepare()
    }


    // =============================================================================================


    /**
     * 倒计时时间
     */
    private var countDownTimes: Int = 0

    /**
     * 倒计时任务
     */
    private val countdownRunnable = Runnable {
        refreshCountDownView(countDownTimes)
        countDownTimes--
        startCountDown()
    }

    /**
     * 开始倒计时
     */
    fun startCountDown() {
        pauseCountDown()
        if (countDownTimes < 0) {
            isCanFinish = true
        } else {
            mHandler.postDelayed(countdownRunnable, 1000)
        }
    }

    fun pauseCountDown() {
        mHandler.removeCallbacksAndMessages(null)
    }

    private fun initData() {
        // 全屏显示 必须在setContentViw之后设置全屏。否则不会生效。
        window.setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT)
        //设置点击外部空白处可以关闭Activity true:可以关闭 false:不能关闭
        this.setFinishOnTouchOutside(false)

        // 添加到曝光测量
        MeasureManager.addSession(this)

        // 接受传递过来的数据
        mAdPlan = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
            intent?.getParcelableExtra(
                NON_INTERSTITIAL_AD_ACTIVITY_EXTRA_AD_PLAN, AdPlans::class.java
            )
        } else {
            intent?.getParcelableExtra(NON_INTERSTITIAL_AD_ACTIVITY_EXTRA_AD_PLAN)
        }
        mSceneId = intent?.getStringExtra(NON_INTERSTITIAL_ACTIVITY_EXTRA_SCENE_ID) ?: ""

        AdLogger.logSdkIntercept("${javaClass.simpleName} --> onCreate --> 开始展示广告了 --> mSceneId = $mSceneId -- mAdPlan = $mAdPlan")

        // 倒计时组件
        countDownTimes = getCountDownTimes()
    }

}