package com.transsion.ad.middle.intercept

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.content.IntentFilter
import android.text.TextUtils
import androidx.localbroadcastmanager.content.LocalBroadcastManager
import com.blankj.utilcode.util.Utils
import com.hisavana.common.bean.TAdErrorCode
import com.transsion.ad.AdLogger
import com.transsion.ad.monopoly.model.AdMaterialList
import com.transsion.ad.monopoly.model.AdPlans
import com.transsion.ad.middle.WrapperAdListener
import com.transsion.ad.monopoly.model.MbAdSource

/**
 * @author: zhangxinbing
 * @date : 2024/7/22 17:18
 * @description: 这个类处理广播事件
 */
@Deprecated("使用 BiddingInterstitialManager")
abstract class BaseNonAdManager {

    /**
     * 广播接收到事件之后 --> 通过回调传递出去
     */
    private var mCallback: WrapperAdListener? = null

    fun getClassTag(): String = javaClass.simpleName


    // ================================ API ========================================================


    /**
     * 将回调设置进来
     */
    fun setListener(listener: WrapperAdListener?): BaseNonAdManager {
        mCallback = listener
        return this
    }

    /**
     * 资源回收
     */
    fun destroy() {
        mCallback = null
        unregisterReceiver()
    }

    /**
     * 展示广告
     */
    fun showAd(adPlans: AdPlans?, mSceneId: String?) {
        val hasResource = checkResource(adPlans)
        if (hasResource) {
            Utils.getApp()?.let {
                // 注册事件广播
                val filter = IntentFilter()
                registerReceiver(filter)
                LocalBroadcastManager.getInstance(Utils.getApp())
                    .registerReceiver(myReceiver, filter)

                // 跳转界面
                val intent = getIntent(it, adPlans, mSceneId)
                intent.putExtra(
                    BaseInterceptMbAdActivity.NON_INTERSTITIAL_AD_ACTIVITY_EXTRA_AD_PLAN, adPlans
                ) // 广告计划
                intent.putExtra(
                    BaseInterceptMbAdActivity.NON_INTERSTITIAL_ACTIVITY_EXTRA_SCENE_ID, mSceneId
                ) // 场景ID
                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
                intent.addFlags(Intent.FLAG_ACTIVITY_NO_ANIMATION)
                // 打开页面
                it.startActivity(intent)
            }
        } else {
            AdLogger.logSdkIntercept("${getClassTag()} --> showAd() --> hasResource == false --> 广告未加载成功")
            mCallback?.onPlanAdShowError(
                TAdErrorCode(
                    MbAdSource.MB_AD_SOURCE_BUY_OUT, "广告未加载成功"
                )
            )
        }
    }


    // ============================ 抽象方法 父类定义 =================================================


    /**
     * 这个intent是用于区分跳转的是激励视频还是插屏广告页面
     */
    abstract fun getIntent(context: Context, adPlans: AdPlans?, mSceneId: String?): Intent

    /**
     * 注册广播
     */
    abstract fun registerReceiver(filter: IntentFilter)


    // ================================== 内部逻辑 ===================================================


    /**
     * 创建一个BroadcastReceiver
     */
    private val myReceiver: BroadcastReceiver = object : BroadcastReceiver() {
        @Override
        override fun onReceive(context: Context?, intent: Intent) {
            // 处理接收到的广播
            // val data = intent.getStringExtra("key")
            // 执行相关的操作
            AdLogger.logSdkInterceptE("${getClassTag()} --> 包断广告 --> 接收到本地广播 --> action = ${intent.action} --> mCallback = $mCallback")
            when (intent.action) {
                BaseInterceptMbAdActivity.NON_INTERCEPT_ACTIVITY_LOCAL_BROADCAST_ACTION_ON_SHOW_VIDEO, BaseInterceptMbAdActivity.NON_INTERCEPT_ACTIVITY_LOCAL_BROADCAST_ACTION_ON_SHOW_INTERSTITIAL -> {
                    mCallback?.onShow(MbAdSource.MB_AD_SOURCE_BUY_OUT)
                }

                BaseInterceptMbAdActivity.NON_INTERCEPT_ACTIVITY_LOCAL_BROADCAST_ACTION_ON_REWARDED_VIDEO, BaseInterceptMbAdActivity.NON_INTERCEPT_ACTIVITY_LOCAL_BROADCAST_ACTION_ON_REWARDED_INTERSTITIAL -> {
                    mCallback?.onRewarded()
                }

                BaseInterceptMbAdActivity.NON_INTERCEPT_ACTIVITY_LOCAL_BROADCAST_ACTION_ON_DESTROY_VIDEO, BaseInterceptMbAdActivity.NON_INTERCEPT_ACTIVITY_LOCAL_BROADCAST_ACTION_ON_DESTROY_INTERSTITIAL -> {
                    mCallback?.onClosed(MbAdSource.MB_AD_SOURCE_BUY_OUT)
                }
            }
        }
    }

    /**
     * 资源回收
     */
    private fun unregisterReceiver() {
        AdLogger.logSdkInterceptE(
            "${getClassTag()} --> unregisterReceiver() --> LocalBroadcastManager -- unregisterReceiver",
            writeToFile = false
        )
        LocalBroadcastManager.getInstance(Utils.getApp()).unregisterReceiver(myReceiver)
    }

    /**
     * 检查资源是否存在
     */
    private fun checkResource(adPlans: AdPlans?): Boolean {
        var hasResource = false
        adPlans?.adMaterialList?.forEach {
            hasResource = if (it.type == AdMaterialList.NON_AD_TYPE_TEXT) {
                TextUtils.isEmpty(it.image?.path).not()
            } else {
                TextUtils.isEmpty(it.video?.path).not()
            }
        }
        return hasResource
    }

}