package com.transsion.ad.middle.intercept

import android.text.TextUtils
import com.hisavana.common.bean.TAdErrorCode
import com.hisavana.common.bean.TAdNativeInfo
import com.transsion.ad.AdLogger
import com.transsion.ad.config.GlobalDialogSwitch
import com.transsion.ad.middle.WrapperAdListener
import com.transsion.ad.monopoly.manager.AdPlansStorageManager
import com.transsion.ad.monopoly.model.AdPlans
import com.transsion.ad.monopoly.model.MbAdShowLevel
import com.transsion.ad.monopoly.model.MbAdSource
import com.transsion.ad.report.AdReportProvider
import com.transsion.ad.scene.SceneOnOff
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext

/**
 * @author: zhangxinbing
 * @date : 2024/7/8 19:56
 * @description: 激励视频 + 插屏
 */
@Deprecated("使用 BiddingInterstitialManager")
abstract class BaseWrapperAdManager : WrapperAdListener() {

    private var mAdPlans: AdPlans? = null // 包断广告 -- 广告计划
    private var mAdShowFinalPlan: AdPlans? = null // 包断广告 -- 兜底计划
    var mSceneId: String? = null // 场景调用的时候传进来的场景ID

    /**
     * 场景传进来的回调，如果为空就是预加载，预加载仅对HiSavana有作用，因为可用的包断广告计划都是下载到本地了。
     * 激励视频和插屏有预加载，其他的没有这个功能
     */
    var mListener: WrapperAdListener? = null

    private var isShow = false // 广告是否展示

    fun getClassTag(): String = javaClass.simpleName


    // ===================== 下面是接口中转 因为目前三种广告请求只能串行请求，所以需要知道回调结果 ============
    // ===================== 下面是接口中转 因为目前三种广告请求只能串行请求，所以需要知道回调结果 ============
    // ===================== 下面是接口中转 因为目前三种广告请求只能串行请求，所以需要知道回调结果 ============


    /**
     * HiSavana 广告加载成功回调
     */
    override fun onLoad() {
        super.onLoad()
        // 将结果透传出去
        mListener?.onLoad()
    }

    /**
     * HiSavana 广告加载失败
     */
    override fun onError(p0: TAdErrorCode?) {
        super.onError(p0)
        // TODO HiSavana 广告加载失败了继续加载兜底广告
        // mListener?.onError(p0)
        if (p0?.errorMessage?.contains(BaseInterceptHiSavanaAdManager.HI_SAVANA_AD_SHOW_ERROR_IS_SHOWING_TAG) == true) {
            mListener?.onError(p0)
        } else {
            loadAdShowFinal()
        }
    }

    /**
     * HiSavana 广告展示错误
     */
    override fun onShowError(p0: TAdErrorCode?) {
        super.onShowError(p0)
        // TODO HiSavana 广告展示失败了继续展示兜底广告
        if (p0?.errorMessage?.contains(BaseInterceptHiSavanaAdManager.HI_SAVANA_AD_SHOW_ERROR_IS_SHOWING_TAG) == true) {
            isShow = false
            mListener?.onShowError(p0)
        } else {
            showInnerAdShowFinal()
        }
    }

    /**
     * HiSavana 广告展示回调
     */
    override fun onShow(p0: Int) {
        super.onShow(p0)
        isShow = true
        mListener?.onShow(p0)
    }

    /**
     * HiSavana 广告点击回调
     */
    override fun onClicked(p0: Int) {
        super.onClicked(p0)
        mListener?.onClicked(p0)
    }

    /**
     * HiSavana 广告关闭回调
     */
    override fun onClosed(p0: Int) {
        super.onClosed(p0)
        isShow = false
        mListener?.onClosed(p0)
    }

    /**
     * HiSavana 广告关闭回调
     */
    override fun onClosed(p0: TAdNativeInfo?) {
        super.onClosed(p0)
        mListener?.onClosed(p0)
    }

    /**
     * HiSavana 广告获得激励回调
     */
    override fun onRewarded() {
        super.onRewarded()
        mListener?.onRewarded()
    }

    /**
     * 包断广告展示失败的时候回调
     */
    override fun onPlanAdShowError(p0: TAdErrorCode?) {
        super.onPlanAdShowError(p0)
        isShow = false
        mListener?.onShowError(p0)
    }


    // ======================= 👇父类定义 ===========================================================


    abstract fun onAdDestroy(sceneId: String?) // 广告销毁的时候调用

    abstract fun getAdType(): Int // 获取广告类型，触发埋点需要这个值

    abstract fun loadHiSavanaAd(sceneId: String, listener: WrapperAdListener?) // 加载HiSavana广告

    abstract fun showHiSavanaAd(
        sceneId: String, listener: WrapperAdListener?, ctxMap: Map<String, Any>?
    ) // 展示HiSavana广告

    abstract fun showMbAd(
        sceneId: String, adPlans: AdPlans?, listener: WrapperAdListener?
    ) // 展示Mb广告

    abstract fun getNonAdManager(): BaseNonAdManager // 广告展示管理


    // ============================= API ===========================================================


    /**
     * 广告回收
     */
    fun destroy() {
        onAdDestroy(mSceneId)
        mSceneId = null
        mAdShowFinalPlan = null
        mListener = null
    }

    /**
     * 加载广告
     *
     * 当listener为空的时候是预加载
     */
    suspend fun loadAd(sceneId: String, listener: WrapperAdListener?) {
        // 已经在使用了
//        if (mListener != null) {
//            onFailCallback(listener = listener, errorMsg = "已经在使用了")
//            return
//        }

        // 统一判断
        val errorMsg = SceneOnOff.isSceneOffV2(sceneId)
        if (TextUtils.isEmpty(errorMsg).not()) {
            onFailCallback(listener = listener, errorMsg = errorMsg)
            return
        }

        // 全局弹窗展示的时候不加载广告
        if (GlobalDialogSwitch.isDialogShow()) {
            onFailCallback(
                listener = listener,
                errorMsg = "${getClassTag()} --> loadAd() --> 全局弹窗展示的时候不加载广告"
            )
            return
        }

        // 内部处理加载逻辑，具体实现在子类
        innerLoadAd(sceneId, listener)
    }

    /**
     * 展示广告
     *
     * 调用showAd() 之后一定要调用destroy()
     */
    suspend fun showAd(
        sceneId: String,
        listener: WrapperAdListener?,
        immediatelyShow: Boolean = false,
        ctxMap: Map<String, Any> = emptyMap()
    ) {
        // 统一判断
        val errorMsg = SceneOnOff.isSceneOffV2(sceneId)
        if (TextUtils.isEmpty(errorMsg).not()) {
            onFailCallback(listener = listener, errorMsg = errorMsg)
            return
        }

        // 全局弹窗展示的时候不加载广告
        if (GlobalDialogSwitch.isDialogShow()) {
            onFailCallback(
                listener = listener,
                errorMsg = "${getClassTag()} --> showAd() --> 全局弹窗展示的时候不加载广告"
            )
            return
        }

        // 内部处理展示逻辑，具体实现在子类
        innerShowAd(sceneId, listener, immediatelyShow, ctxMap)
    }

    /**
     * 当前是否正在展示
     */
    fun isShow() = isShow


    // ========================= 广告加载 内部逻辑实现 =================================================


    /**
     * 失败回调
     */
    private fun onFailCallback(listener: WrapperAdListener?, errorMsg: String) {
        AdLogger.logSdkSplashE("${getClassTag()} --> onFailCallback --> $errorMsg")
        listener?.onError(TAdErrorCode(MbAdSource.MB_AD_SOURCE_WRAPPER_AD, errorMsg))
    }


    /**
     * 加载插屏广告 加载结果将通过 listener 回调, 如果listener是空的那就是预加载
     */
    private suspend fun innerLoadAd(sceneId: String, listener: WrapperAdListener?) {
        AdLogger.logSdkIntercept("${javaClass.simpleName} --> innerLoadAd() --> sceneId = $sceneId")

        // 通过sceneId获取广告配置,广告回收的时候也需要用到
        mSceneId = sceneId
        mListener = listener

        // 获取符合条件的广告计划
        mAdPlans = withContext(Dispatchers.IO) {
            AdPlansStorageManager.getAdPlans(sceneId = sceneId, ctxMap = emptyMap())
        }

        // 兜底广告计划
        mAdShowFinalPlan = withContext(Dispatchers.IO) {
            AdPlansStorageManager.getAdPlans(
                sceneId, adShowLevel = MbAdShowLevel.MB_AD_SHOW_FINAL, ctxMap = emptyMap()
            )
        }

        // listener == null 意味着场景不需要结果回调，这个是预加载，不需要上报触发埋点。
        if (null != mListener) {
            // 广告触发 统一入口处理
            AdReportProvider.trigger(
                sceneId = sceneId,
                adType = getAdType(),
                adSource = if (mAdPlans == null) MbAdSource.MB_AD_SOURCE_HISAVANA_TRIGGER else MbAdSource.MB_AD_SOURCE_MB_TRIGGER,
                planId = mAdPlans?.id
            )
        }

        // 广告展示优先级 --> 非标广告 > HiSavana广告
        if (null == mAdPlans) {
            innerLoadHiSavanaAd(sceneId)
        } else {
            // 加载 非标广告
            if (SceneOnOff.isSceneNonOff(sceneId).not()) {
                loadPlanAd(sceneId)
            } else {
                innerLoadHiSavanaAd(sceneId)
            }
        }
    }

    /**
     * 加载HiSavana 广告
     */
    private fun innerLoadHiSavanaAd(sceneId: String) {
        // 加载之前判断场景是否关闭
        if (SceneOnOff.isSceneHiOff(sceneId).not()) {
            AdLogger.logSdkIntercept("${javaClass.simpleName} --> innerLoadHiSavanaAd() --> 加载HiSavana广告 --> sceneId = $sceneId")
            // 如果场景传入的回调是空的，那就是预加载不需要返回结果的，所以仅仅是触发HiSavana预加载广告。
            if (mListener == null) {
                loadHiSavanaAd(sceneId, null)
            } else {
                loadHiSavanaAd(sceneId, this)
            }
        } else {
            // 广告位关闭了加载兜底包断广告
            loadAdShowFinal()
        }
    }

    /**
     * 加载包断广告
     */
    open fun loadPlanAd(sceneId: String) {
        // 能获取到广告计划，那一定是可用的
        AdLogger.logSdkIntercept("${javaClass.simpleName} --> innerLoadHiSavanaAd() --> 当前包断广告可用 --> sceneId = $mSceneId")
        mListener?.onLoad()
    }

    /**
     * 加载兜底包断广告
     */
    open fun loadAdShowFinal() {
        if (mAdShowFinalPlan == null) {
            AdLogger.logSdkIntercept("${javaClass.simpleName} --> innerLoadHiSavanaAd() --> 当前没有兜底广告 --> sceneId = $mSceneId")
            mListener?.onError(
                TAdErrorCode(
                    MbAdSource.MB_AD_SOURCE_WRAPPER_AD, "没有兜底广告 --> sceneId = $mSceneId"
                )
            )
        } else {
            // 当前有兜底广告可用
            AdLogger.logSdkIntercept("${javaClass.simpleName} --> innerLoadHiSavanaAd() --> 当前有兜底广告可用 --> sceneId = $mSceneId")
            mListener?.onLoad()
        }
    }


    // =============================== 广告展示 内部逻辑实现 ===========================================


    /**
     * 展示广告
     */
    private suspend fun innerShowAd(
        sceneId: String,
        listener: WrapperAdListener?,
        immediatelyShow: Boolean,
        ctxMap: Map<String, Any>
    ) {
        AdLogger.logSdkIntercept("${javaClass.simpleName} --> innerShowAd() --> sceneId = $sceneId")

        // 通过sceneId获取广告配置
        mSceneId = sceneId
        mListener = listener

        // 获取包断广告计划的配置
        val mAdPlans = withContext(Dispatchers.IO) {
            AdPlansStorageManager.getAdPlans(sceneId = sceneId, ctxMap = ctxMap)
        }

        // 兜底广告计划
        mAdShowFinalPlan = withContext(Dispatchers.IO) {
            AdPlansStorageManager.getAdPlans(
                sceneId, adShowLevel = MbAdShowLevel.MB_AD_SHOW_FINAL, ctxMap = emptyMap()
            )
        }

        if (immediatelyShow) {
            AdReportProvider.trigger(
                sceneId = sceneId,
                adType = getAdType(),
                adSource = if (mAdPlans == null) MbAdSource.MB_AD_SOURCE_HISAVANA_TRIGGER else MbAdSource.MB_AD_SOURCE_MB_TRIGGER,
                planId = mAdPlans?.id
            )
        }

        // 广告展示优先级 --> 非标广告 > HiSavana广告
        if (null == mAdPlans) {
            innerShowHiSavanaAd(sceneId, this, ctxMap)
        } else {
            // 加载 非标广告
            if (SceneOnOff.isSceneNonOff(sceneId).not()) {
                showMbAd(sceneId, mAdPlans, this)
            } else {
                AdLogger.logSdkIntercept(
                    "${javaClass.simpleName} --> innerShowAd() --> 非标广告场景关闭 --> 继续加载HiSavana广告 --> sceneId = $sceneId",
                    writeToFile = false
                )
                innerShowHiSavanaAd(sceneId, this, ctxMap)
            }
        }
    }

    private fun innerShowHiSavanaAd(
        sceneId: String, listener: WrapperAdListener?, ctxMap: Map<String, Any>?
    ) {
        // 加载 HiSavana 广告
        if (SceneOnOff.isSceneHiOff(sceneId).not()) {
            AdLogger.logSdkIntercept("${javaClass.simpleName} --> innerShowHiSavanaAd() --> 展示HiSavana广告 --> sceneId = $sceneId")
            showHiSavanaAd(sceneId, listener, ctxMap)
        } else {
            showInnerAdShowFinal()
        }
    }

    /**
     * 展示兜底广告计划
     *
     * 在包断广告和HiSavana都展示失败的时候展示兜底广告
     */
    fun showInnerAdShowFinal() {
        if (mAdShowFinalPlan == null) {
            AdLogger.logSdkIntercept("${javaClass.simpleName} --> showInnerAdShowFinal() --> 没有兜底广告可用于展示 --> sceneId = $mSceneId")
            mListener?.onShowError(
                TAdErrorCode(
                    MbAdSource.MB_AD_SOURCE_WRAPPER_AD, "没有兜底广告可用于展示"
                )
            )
        } else {
            AdLogger.logSdkIntercept("${javaClass.simpleName} --> showInnerAdShowFinal() --> 加载包断兜底广告 --> sceneId = $mSceneId")
            showMbAd(mSceneId ?: "", mAdShowFinalPlan, this)
        }
    }

    suspend fun isAdPlansExist(sceneId: String, ctxMap: Map<String, Any>): Boolean {
        val adPlans = withContext(Dispatchers.IO) {
            AdPlansStorageManager.getAdPlans(sceneId = sceneId, ctxMap = ctxMap)
        }
        return adPlans != null
    }
}